/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class PasteCommandHelper {
    private PasteCommandHelper() {
    }

    public static IStatus createPasteCommands(Collection<?> pasteElements, CompoundCommand commands, final EObject owner, EStructuralFeature feature, EditingDomain domain, int index, boolean useIndex) {
        IStatus status = Status.OK_STATUS;
        EStructuralFeature feat = feature;
        SharedCopyPasteElements instance = SharedCopyPasteElements.getInstance();
        for (final Object pasteElement : pasteElements) {
            Object originalObject = instance.getOriginalObject(instance.getPasteCopyOfCopiedObject(pasteElement));
            if (originalObject == null && (originalObject = instance.getOriginalObject(pasteElement)) == null) {
                originalObject = pasteElement;
            }
            EStructuralFeature containingFeature = ((EObject)originalObject).eContainingFeature();
            EList ownerContainments = owner.eClass().getEAllContainments();
            feat = ownerContainments.contains(containingFeature) ? containingFeature : PasteCommandHelper.getNewTargetContainingFeature((EObject)originalObject, owner, containingFeature);
            boolean append = true;
            Session session = SessionManager.INSTANCE.getSession(owner);
            if (session != null && !session.equals(SessionManager.INSTANCE.getSession((EObject)originalObject)) && !CrossReferencerHelper.isSelfContained((EObject)((EObject)originalObject), (boolean)false)) {
                append = false;
            }
            if (append) {
                Object command = null;
                if (feat != null) {
                    if (feat.isMany()) {
                        featureCommand = feat;
                        command = new RecordingCommand((TransactionalEditingDomain)domain){

                            protected void doExecute() {
                                ((EList)owner.eGet(featureCommand)).addAll(Collections.singletonList(pasteElement));
                            }
                        };
                    } else {
                        featureCommand = feat;
                        command = new RecordingCommand((TransactionalEditingDomain)domain){

                            protected void doExecute() {
                                owner.eSet(featureCommand, Collections.singletonList(pasteElement));
                            }
                        };
                    }
                } else {
                    command = AddCommand.create((EditingDomain)domain, (Object)owner, null, pasteElement);
                }
                if (command != null) {
                    commands.append(command);
                    continue;
                }
                status = new Status(4, "org.polarsys.capella.core.ui.toolkit", Messages.CapellaPasteCommand_error_command, null);
                commands.append((Command)UnexecutableCommand.INSTANCE);
                continue;
            }
            status = new Status(4, "org.polarsys.capella.core.ui.toolkit", Messages.CapellaPasteCommand_error_session, null);
            commands.append((Command)UnexecutableCommand.INSTANCE);
        }
        return status;
    }

    protected static EStructuralFeature getNewTargetContainingFeature(EObject originalObject, EObject newOwner, EStructuralFeature originalContainingFeature) {
        if (originalObject instanceof Part) {
            if (newOwner instanceof ComponentPkg && originalContainingFeature == CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES) {
                return CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS;
            }
            if (newOwner instanceof Component && originalContainingFeature == CsPackage.Literals.COMPONENT_PKG__OWNED_PARTS) {
                return CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES;
            }
        } else if ((originalObject instanceof Component || originalObject instanceof ComponentPkg) && (originalObject.eContainer() instanceof Component && newOwner instanceof ComponentPkg || originalObject.eContainer() instanceof ComponentPkg && newOwner instanceof Component)) {
            String originalFeatureName = originalContainingFeature.getName();
            Optional<EStructuralFeature> newFeatureOptional = newOwner.eClass().getEAllStructuralFeatures().stream().filter(f -> f.getName().equals(originalFeatureName)).findAny();
            if (newFeatureOptional.isPresent()) {
                return newFeatureOptional.get();
            }
        }
        return null;
    }
}

