/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.communication.properties.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.information.communication.properties.Messages;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticKindGroup;

public class CommunicationLinkProtocolGroup
extends AbstractSemanticKindGroup {
    private Button _communicationLinkBtnUnset = this.createButton((Enumerator)CommunicationLinkProtocol.UNSET);
    private Button _communicationLinkBtnSynchronous;
    private Button _communicationLinkBtnAsynchronous;
    private Button _communicationLinkBtnUnicast;
    private Button _communicationLinkBtnMulticast;
    private Button _communicationLinkBtnBroadcast;
    private Button _communicationLinkBtnRead;
    private Button _communicationLinkBtnAccept;

    public CommunicationLinkProtocolGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this(parent, Messages.getString("CommunicationLinkProtocol.Label"), widgetFactory, true, true, true);
    }

    public CommunicationLinkProtocolGroup(Composite parent, String text, TabbedPropertySheetWidgetFactory widgetFactory, boolean showCallProtocols, boolean showSendProtocols, boolean showAccessProtocols) {
        super(parent, widgetFactory, text, CommunicationLinkProtocolGroup.getNumColumns(showCallProtocols, showSendProtocols, showAccessProtocols));
        if (showCallProtocols) {
            this._communicationLinkBtnSynchronous = this.createButton((Enumerator)CommunicationLinkProtocol.SYNCHRONOUS);
            this._communicationLinkBtnAsynchronous = this.createButton((Enumerator)CommunicationLinkProtocol.ASYNCHRONOUS);
        }
        if (showSendProtocols) {
            this._communicationLinkBtnUnicast = this.createButton((Enumerator)CommunicationLinkProtocol.UNICAST);
            this._communicationLinkBtnMulticast = this.createButton((Enumerator)CommunicationLinkProtocol.MULTICAST);
            this._communicationLinkBtnBroadcast = this.createButton((Enumerator)CommunicationLinkProtocol.BROADCAST);
        }
        if (showAccessProtocols) {
            this._communicationLinkBtnRead = this.createButton((Enumerator)CommunicationLinkProtocol.READ);
            this._communicationLinkBtnAccept = this.createButton((Enumerator)CommunicationLinkProtocol.ACCEPT);
        }
    }

    private static int getNumColumns(boolean showCallProtocols, boolean showSendProtocols, boolean showAccessProtocols) {
        return 1 + (showCallProtocols ? 2 : 0) + (showSendProtocols ? 3 : 0) + (showAccessProtocols ? 2 : 0);
    }

    public void synchronizeProtocolsStatus(ExchangeMechanism exchangeMechanism) {
        if (exchangeMechanism != null) {
            switch (exchangeMechanism.getValue()) {
                case 2: {
                    this.enableCallProtocols(true);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
                case 3: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(true);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
                case 4: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(true);
                    this.enableUnsetProtocols(true);
                    break;
                }
                default: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
            }
        } else {
            this.enableCallProtocols(false);
            this.enableSendProtocols(false);
            this.enableAccessProtocols(false);
            this.enableUnsetProtocols(true);
        }
        this.loadData(this.semanticElement);
    }

    public void synchronizeProtocolsStatus(CommunicationLinkKind communicationLinkKind) {
        if (communicationLinkKind != null) {
            switch (communicationLinkKind.getValue()) {
                case 5: {
                    this.enableCallProtocols(true);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
                case 3: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(true);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
                case 8: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(true);
                    this.enableUnsetProtocols(true);
                    break;
                }
                default: {
                    this.enableCallProtocols(false);
                    this.enableSendProtocols(false);
                    this.enableAccessProtocols(false);
                    this.enableUnsetProtocols(true);
                    break;
                }
            }
        } else {
            this.enableCallProtocols(false);
            this.enableSendProtocols(false);
            this.enableAccessProtocols(false);
            this.enableUnsetProtocols(true);
        }
        this.loadData(this.semanticElement);
    }

    protected void enableAccessProtocols(boolean enabled) {
        this.enableButton(this._communicationLinkBtnRead, enabled);
        this.enableButton(this._communicationLinkBtnAccept, enabled);
    }

    protected void enableCallProtocols(boolean enabled) {
        this.enableButton(this._communicationLinkBtnSynchronous, enabled);
        this.enableButton(this._communicationLinkBtnAsynchronous, enabled);
    }

    protected void enableSendProtocols(boolean enabled) {
        this.enableButton(this._communicationLinkBtnUnicast, enabled);
        this.enableButton(this._communicationLinkBtnMulticast, enabled);
        this.enableButton(this._communicationLinkBtnBroadcast, enabled);
    }

    protected void enableUnsetProtocols(boolean enabled) {
        this.enableButton(this._communicationLinkBtnUnset, enabled);
    }

    public List<Button> getSemanticFields() {
        ArrayList<Button> fields = new ArrayList<Button>();
        fields.add(this._communicationLinkBtnRead);
        fields.add(this._communicationLinkBtnAccept);
        fields.add(this._communicationLinkBtnSynchronous);
        fields.add(this._communicationLinkBtnAsynchronous);
        fields.add(this._communicationLinkBtnUnicast);
        fields.add(this._communicationLinkBtnMulticast);
        fields.add(this._communicationLinkBtnBroadcast);
        fields.add(this._communicationLinkBtnUnset);
        return fields;
    }

    public Button getDefaultSemanticField() {
        return this._communicationLinkBtnUnset;
    }
}

