/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.ProjectionMessages;

public abstract class AbstractTransitionCommand
extends AbstractReadWriteCommand {
    protected Collection<EObject> rootElements = null;
    private IProgressMonitor progressMonitor = null;
    protected Collection<EObject> elements = null;

    public String getName() {
        return ProjectionMessages.transition_title;
    }

    public AbstractTransitionCommand(Collection<EObject> rootElements) {
        this(rootElements, (IProgressMonitor)new NullProgressMonitor());
    }

    public AbstractTransitionCommand(Collection<EObject> rootElements, IProgressMonitor progressMonitor) {
        this.rootElements = rootElements;
        this.progressMonitor = progressMonitor;
    }

    protected Collection<EObject> retrieveModelElements(EObject modelElement) {
        return Collections.singleton(modelElement);
    }

    protected abstract AbstractTransform getTransformation(EObject var1);

    public void run() {
        LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
        try {
            if (this.rootElements != null && this.rootElements.size() > 0) {
                this.elements = new ArrayList<EObject>();
                for (EObject rootElement : this.rootElements) {
                    this.elements.addAll(this.retrieveModelElements(rootElement));
                }
                this.progressMonitor.beginTask(this.getName() + ProjectionMessages.transition_processing, this.elements.size());
                for (EObject relatedElement : this.elements) {
                    AbstractTransform transform;
                    if (relatedElement != null && (transform = this.getTransformation(relatedElement)) != null) {
                        transform.setContext(relatedElement);
                        transform.execute();
                    }
                    this.progressMonitor.worked(1);
                }
            }
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.polarsys.capella.common.tools.report.appenders.reportlogview.logview");
            }
            catch (PartInitException e) {
                CapellaActionsActivator.getDefault().log(4, e.getMessage(), (Throwable)e);
            }
        }
    }
}

