/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.tiger.IFinalizer;
import org.polarsys.capella.core.tiger.IResolver;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class ResolverFinalizer
implements IFinalizer,
IResolver {
    private static String RESOLVER_MAPPINGS = "resolverMappings";

    protected Map<InternalValue<EObject>, List<EObject>> getMappings(ITransfo transfo_p) {
        if (transfo_p.get((Object)RESOLVER_MAPPINGS) == null) {
            transfo_p.put((Object)RESOLVER_MAPPINGS, new HashMap());
        }
        return (Map)transfo_p.get((Object)RESOLVER_MAPPINGS);
    }

    protected List<EObject> getCachedValue(EObject[] context_p, ITransfo transfo_p) {
        InternalValue<EObject> key = new InternalValue<EObject>(context_p);
        Map<InternalValue<EObject>, List<EObject>> mappings = this.getMappings(transfo_p);
        return mappings.get(key);
    }

    protected void setCachedValue(EObject[] context_p, List<EObject> value_p, ITransfo transfo_p) {
        InternalValue<EObject> key = new InternalValue<EObject>(context_p);
        Map<InternalValue<EObject>, List<EObject>> mappings = this.getMappings(transfo_p);
        mappings.put(key, value_p);
    }

    protected void setCachedValue(EObject[] context_p, EObject value_p, ITransfo transfo_p) {
        InternalValue<EObject> key = new InternalValue<EObject>(context_p);
        Map<InternalValue<EObject>, List<EObject>> mappings = this.getMappings(transfo_p);
        mappings.put(key, (List)((Object)Collections.singleton(value_p)));
    }

    public void finalize(ITransfo transfo_p) {
        Object result;
        if (transfo_p != null && transfo_p.containsKey((Object)RESOLVER_MAPPINGS) && (result = transfo_p.get((Object)RESOLVER_MAPPINGS)) != null && result instanceof List) {
            ((List)result).clear();
            transfo_p.remove((Object)RESOLVER_MAPPINGS);
        }
    }

    public List<EObject> resolve(EObject source_p, List<EObject> items_p, String title_p, String message_p, boolean multipleSelection_p, ITransfo transfo_p, EObject[] context_p) {
        List resultObject = this.getCachedValue(context_p, transfo_p);
        if (resultObject != null) {
            return resultObject;
        }
        IResolver resolver = Query.getResolver((ITransfo)transfo_p);
        if (resolver != null) {
            resultObject = resolver.resolve(source_p, items_p, title_p, message_p, multipleSelection_p, transfo_p, context_p);
        }
        if (resultObject != null && resultObject.size() > 0) {
            this.setCachedValue(context_p, resultObject, transfo_p);
        }
        return resultObject;
    }

    public static ResolverFinalizer getResolver(ITransfo transfo_p) {
        for (IFinalizer finalizer : transfo_p.getFinalizers()) {
            if (!(finalizer instanceof ResolverFinalizer)) continue;
            return (ResolverFinalizer)finalizer;
        }
        return null;
    }

    protected class InternalValue<A> {
        A[] table;

        public InternalValue(A[] firstValue_p) {
            this.table = firstValue_p;
        }

        public int hashCode() {
            int hash = 17;
            if (this.table != null) {
                A[] AArray = this.table;
                int n = this.table.length;
                int n2 = 0;
                while (n2 < n) {
                    A element = AArray[n2];
                    hash += 31 * element.hashCode();
                    ++n2;
                }
            }
            return hash;
        }

        public boolean equals(Object obj_p) {
            if (obj_p instanceof InternalValue) {
                InternalValue p = (InternalValue)obj_p;
                if (p.table == this.table) {
                    return true;
                }
                if (p.table != null && this.table != null && p.table.length == this.table.length) {
                    int i = 0;
                    while (i < this.table.length) {
                        if (p.table[i] == this.table[i] || this.table[i] != null && this.table[i].equals(p.table[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            return false;
        }
    }
}

