/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractMessageDialog;

public abstract class AbstractMessageDialogWithViewer
extends AbstractMessageDialog {
    public static final int DEFAULT_DIALOG_HEIGHT = 550;
    public static final int DEFAULT_DIALOG_WIDTH = 450;
    private Viewer _viewer;

    public AbstractMessageDialogWithViewer(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Shell activeShell = shell.getDisplay().getActiveShell();
        if (activeShell != null) {
            Rectangle bounds = activeShell.getBounds();
            int width = this.getDialogWidth();
            int height = this.getDialogHeight();
            shell.setBounds(bounds.x + (bounds.width - width) / 2, bounds.y + (bounds.height - height) / 2, width, height);
        }
    }

    protected Control createCustomArea(Composite parent) {
        Composite containingComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        containingComposite.setLayout((Layout)layout);
        containingComposite.setLayoutData((Object)new GridData(1808));
        this.createViewerArea(containingComposite);
        return containingComposite;
    }

    protected abstract Viewer createViewer(Composite var1);

    protected void createViewerArea(Composite parent) {
        this._viewer = this.createViewer(parent);
        this._viewer.setInput(this.getInitialInputData());
    }

    protected int getDialogHeight() {
        return 550;
    }

    protected int getDialogWidth() {
        return 450;
    }

    protected abstract Object getInitialInputData();

    protected Viewer getViewer() {
        return this._viewer;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }
}

