/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentRealization;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocator;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.ClassifierHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.InterfaceAllocatorHelper;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionalBlockHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.CommunicationLinkExchangerHelper;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;

public class ComponentHelper {
    private static ComponentHelper instance;

    private ComponentHelper() {
    }

    public static ComponentHelper getInstance() {
        if (instance == null) {
            instance = new ComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(Component element, EStructuralFeature feature) {
        List<Interface> ret = null;
        if (feature.equals(CsPackage.Literals.COMPONENT__REALIZED_COMPONENTS)) {
            ret = this.getRealizedComponents(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__REALIZING_COMPONENTS)) {
            ret = this.getRealizingComponents(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__PROVIDED_INTERFACES)) {
            ret = this.getProvidedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__REQUIRED_INTERFACES)) {
            ret = this.getRequiredInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__IMPLEMENTED_INTERFACES)) {
            ret = this.getImplementedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__USED_INTERFACES)) {
            ret = this.getUsedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__IMPLEMENTED_INTERFACE_LINKS)) {
            ret = this.getImplementedInterfaceLinks(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__USED_INTERFACE_LINKS)) {
            ret = this.getUsedInterfaceLinks(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_COMPONENT_PORTS)) {
            ret = this.getContainedComponentPorts(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_PARTS)) {
            ret = this.getContainedParts(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__CONTAINED_PHYSICAL_PORTS)) {
            ret = this.getContainedPhysicalPorts(element);
        } else if (feature.equals(CsPackage.Literals.COMPONENT__REPRESENTING_PARTS)) {
            ret = this.getRepresentingParts(element);
        }
        if (ret == null) {
            ret = AbstractFunctionalBlockHelper.getInstance().doSwitch((AbstractFunctionalBlock)element, feature);
        }
        if (ret == null) {
            ret = ClassifierHelper.getInstance().doSwitch((Classifier)element, feature);
        }
        if (ret == null) {
            ret = InterfaceAllocatorHelper.getInstance().doSwitch((InterfaceAllocator)element, feature);
        }
        if (ret == null) {
            ret = CommunicationLinkExchangerHelper.getInstance().doSwitch((CommunicationLinkExchanger)element, feature);
        }
        return ret;
    }

    protected List<Component> getRealizedComponents(Component element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Component cpnt;
            if (!(trace instanceof ComponentRealization) || (cpnt = ((ComponentRealization)trace).getRealizedComponent()) == null) continue;
            ret.add(cpnt);
        }
        return ret;
    }

    protected List<Component> getRealizingComponents(Component element) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            Component cpnt;
            if (!(trace instanceof ComponentRealization) || (cpnt = ((ComponentRealization)trace).getRealizingComponent()) == null) continue;
            ret.add(cpnt);
        }
        return ret;
    }

    protected List<Interface> getProvidedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof ComponentPort)) continue;
            ret.addAll((Collection<Interface>)((ComponentPort)feature).getProvidedInterfaces());
        }
        return ret;
    }

    protected List<Interface> getRequiredInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof ComponentPort)) continue;
            ret.addAll((Collection<Interface>)((ComponentPort)feature).getRequiredInterfaces());
        }
        return ret;
    }

    protected List<InterfaceImplementation> getImplementedInterfaceLinks(Component element) {
        return element.getOwnedInterfaceImplementations();
    }

    protected List<InterfaceUse> getUsedInterfaceLinks(Component element) {
        return element.getOwnedInterfaceUses();
    }

    protected List<Interface> getImplementedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceImplementation interfaceImplementation : element.getImplementedInterfaceLinks()) {
            Interface itf = interfaceImplementation.getImplementedInterface();
            if (itf == null) continue;
            ret.add(itf);
        }
        return ret;
    }

    protected List<Interface> getUsedInterfaces(Component element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceUse interfaceUse : element.getUsedInterfaceLinks()) {
            Interface itf = interfaceUse.getUsedInterface();
            if (itf == null) continue;
            ret.add(itf);
        }
        return ret;
    }

    protected List<ComponentPort> getContainedComponentPorts(Component element) {
        ArrayList<ComponentPort> ret = new ArrayList<ComponentPort>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof ComponentPort)) continue;
            ret.add((ComponentPort)feature);
        }
        return ret;
    }

    protected List<Part> getContainedParts(Component element) {
        ArrayList<Part> ret = new ArrayList<Part>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof Part)) continue;
            ret.add((Part)feature);
        }
        return ret;
    }

    protected List<PhysicalPort> getContainedPhysicalPorts(Component element) {
        ArrayList<PhysicalPort> ret = new ArrayList<PhysicalPort>();
        for (Feature feature : element.getOwnedFeatures()) {
            if (!(feature instanceof PhysicalPort)) continue;
            ret.add((PhysicalPort)feature);
        }
        return ret;
    }

    protected List<Part> getRepresentingParts(Component element) {
        EList typedElements = element.getTypedElements();
        ArrayList<Part> ret = new ArrayList<Part>();
        for (TypedElement typedElement : typedElements) {
            if (!(typedElement instanceof Part)) continue;
            ret.add((Part)typedElement);
        }
        return ret;
    }
}

