/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.helpers.interaction.delegates.AbstractCapabilityHelper;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.oa.OperationalCapability;

public class CapabilityHelper {
    private static CapabilityHelper instance;

    private CapabilityHelper() {
    }

    public static CapabilityHelper getInstance() {
        if (instance == null) {
            instance = new CapabilityHelper();
        }
        return instance;
    }

    public Object doSwitch(Capability element, EStructuralFeature feature) {
        List<SystemComponent> ret = null;
        if (feature.equals(CtxPackage.Literals.CAPABILITY__PURPOSE_MISSIONS)) {
            ret = this.getPurposeMissions(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__PURPOSES)) {
            ret = this.getPurposes(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__INVOLVED_SYSTEM_COMPONENTS)) {
            ret = this.getInvolvedSystemComponents(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__REALIZED_OPERATIONAL_CAPABILITIES)) {
            ret = this.getRealizedOperationalCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.CAPABILITY__REALIZING_CAPABILITY_REALIZATIONS)) {
            ret = this.getRealizingCapabilityRealizations(element);
        }
        if (ret == null) {
            ret = AbstractCapabilityHelper.getInstance().doSwitch((AbstractCapability)element, feature);
        }
        return ret;
    }

    protected List<CapabilityExploitation> getPurposes(Capability element) {
        return EObjectExt.getReferencers((EObject)element, (EReference)CtxPackage.Literals.CAPABILITY_EXPLOITATION__CAPABILITY);
    }

    protected List<Mission> getPurposeMissions(Capability element) {
        ArrayList<Mission> ret = new ArrayList<Mission>();
        for (CapabilityExploitation exploitation : element.getPurposes()) {
            Mission mission = exploitation.getMission();
            if (mission == null) continue;
            ret.add(mission);
        }
        return ret;
    }

    protected List<SystemComponent> getInvolvedSystemComponents(Capability element) {
        ArrayList<SystemComponent> ret = new ArrayList<SystemComponent>();
        for (CapabilityInvolvement involvement : element.getOwnedCapabilityInvolvements()) {
            SystemComponent systemComponent = involvement.getSystemComponent();
            if (systemComponent == null) continue;
            ret.add(systemComponent);
        }
        return ret;
    }

    protected List<OperationalCapability> getRealizedOperationalCapabilities(Capability element) {
        ArrayList<OperationalCapability> ret = new ArrayList<OperationalCapability>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizedCapability()) instanceof OperationalCapability)) continue;
            ret.add((OperationalCapability)capability);
        }
        return ret;
    }

    protected List<CapabilityRealization> getRealizingCapabilityRealizations(Capability element) {
        ArrayList<CapabilityRealization> ret = new ArrayList<CapabilityRealization>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            AbstractCapability capability;
            if (!(trace instanceof AbstractCapabilityRealization) || !((capability = ((AbstractCapabilityRealization)trace).getRealizingCapability()) instanceof CapabilityRealization)) continue;
            ret.add((CapabilityRealization)capability);
        }
        return ret;
    }
}

