/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractCapabilityExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;

public class CapabilityExt {
    public static void addInvolvedSystemComponent(Capability capability, SystemComponent systemComponent) {
        if (capability != null && systemComponent != null && !CapabilityExt.getInvolvedSystemComponents(capability).contains(systemComponent)) {
            CapabilityInvolvement involvementLnk = CtxFactory.eINSTANCE.createCapabilityInvolvement();
            capability.getOwnedCapabilityInvolvements().add((Object)involvementLnk);
            involvementLnk.setInvolved((InvolvedElement)systemComponent);
        }
    }

    public static List<SystemComponent> getInvolvedSystemComponents(Capability capability) {
        return CapabilityExt.getInvolvedSystemComponents(capability, false);
    }

    public static List<SystemComponent> getInvolvedSystemComponents(Capability capability, boolean recurse) {
        if (recurse) {
            ArrayList<SystemComponent> involvedSystemComponents = new ArrayList<SystemComponent>((Collection<SystemComponent>)capability.getInvolvedSystemComponents());
            for (AbstractCapability superCapability : AbstractCapabilityExt.getInheritanceHierarchy((AbstractCapability)capability)) {
                involvedSystemComponents.addAll(CapabilityExt.getInvolvedSystemComponents((Capability)superCapability, false));
            }
            return involvedSystemComponents;
        }
        return capability.getInvolvedSystemComponents();
    }

    public static List<Mission> getPurposeMissions(Capability capability) {
        return CapabilityExt.getPurposeMissions(capability, false);
    }

    public static List<Mission> getPurposeMissions(Capability capability1, boolean recurse) {
        ArrayList<Mission> purposeMissions = new ArrayList<Mission>();
        for (CapabilityExploitation exploitation : capability1.getPurposes()) {
            Mission mission = exploitation.getMission();
            if (mission == null) continue;
            purposeMissions.add(mission);
        }
        for (AbstractCapability capability : AbstractCapabilityExt.getIncludingHierarchy((AbstractCapability)capability1)) {
            for (CapabilityExploitation exploitation : ((Capability)capability).getPurposes()) {
                Mission mission = exploitation.getMission();
                if (mission == null) continue;
                purposeMissions.add(mission);
            }
        }
        if (recurse) {
            for (AbstractCapability capability : AbstractCapabilityExt.getInheritanceHierarchy((AbstractCapability)capability1)) {
                purposeMissions.addAll(CapabilityExt.getPurposeMissions((Capability)capability, false));
            }
        }
        return purposeMissions;
    }

    public static boolean hasInvolved(Capability capability, SystemComponent systemComponent) {
        return capability.getInvolvedSystemComponents().contains((Object)systemComponent);
    }

    public static void removeInvolvedSystemComponent(Capability capability, SystemComponent component) {
        List capabilityInvolvementsToRemove = capability.getOwnedCapabilityInvolvements().stream().filter(involvement -> involvement.getSystemComponent() == component).collect(Collectors.toList());
        for (CapabilityInvolvement involvement2 : capabilityInvolvementsToRemove) {
            involvement2.destroy();
        }
    }

    public static Set<Scenario> getAllRelatedScenarios(AbstractCapability capability) {
        EList ownedScenarios = capability.getOwnedScenarios();
        LinkedHashSet<Scenario> externalReferencedScenarios = new LinkedHashSet<Scenario>();
        for (Scenario ownedScenario : ownedScenarios) {
            CapabilityExt.recursiveGetExternalReferencedScenarios(ownedScenario, externalReferencedScenarios);
        }
        externalReferencedScenarios.removeAll((Collection<?>)ownedScenarios);
        return externalReferencedScenarios;
    }

    private static void recursiveGetExternalReferencedScenarios(Scenario aScenario, Set<Scenario> alreadyGatheredScenarios) {
        EList referencedScenarios = aScenario.getReferencedScenarios();
        List uses = aScenario.getOwnedTimeLapses().stream().filter(InteractionUse.class::isInstance).map(InteractionUse.class::cast).collect(Collectors.toList());
        List usedScenarios = uses.stream().map(interactionUse -> interactionUse.getReferencedScenario()).collect(Collectors.toList());
        HashSet allReferencedScenarios = new HashSet(referencedScenarios);
        allReferencedScenarios.addAll(usedScenarios);
        for (Scenario aReferencedScenario : allReferencedScenarios) {
            if (alreadyGatheredScenarios.contains(aReferencedScenario)) continue;
            alreadyGatheredScenarios.add(aReferencedScenario);
            CapabilityExt.recursiveGetExternalReferencedScenarios(aReferencedScenario, alreadyGatheredScenarios);
        }
    }
}

