/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;

public class CommunicationLinkExchangerHelper {
    private static CommunicationLinkExchangerHelper instance;

    private CommunicationLinkExchangerHelper() {
    }

    public static CommunicationLinkExchangerHelper getInstance() {
        if (instance == null) {
            instance = new CommunicationLinkExchangerHelper();
        }
        return instance;
    }

    public Object doSwitch(CommunicationLinkExchanger element, EStructuralFeature feature) {
        List<CommunicationLink> ret = null;
        if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__PRODUCE)) {
            ret = this.getProduce(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__CONSUME)) {
            ret = this.getConsume(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__SEND)) {
            ret = this.getSend(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__RECEIVE)) {
            ret = this.getReceive(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__CALL)) {
            ret = this.getCall(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__EXECUTE)) {
            ret = this.getExecute(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__WRITE)) {
            ret = this.getWrite(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__ACCESS)) {
            ret = this.getAccess(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__ACQUIRE)) {
            ret = this.getAcquire(element);
        } else if (feature.equals(CommunicationPackage.Literals.COMMUNICATION_LINK_EXCHANGER__TRANSMIT)) {
            ret = this.getTransmit(element);
        }
        return ret;
    }

    protected List<CommunicationLink> getProduce(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.PRODUCE);
    }

    protected List<CommunicationLink> getConsume(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.CONSUME);
    }

    protected List<CommunicationLink> getSend(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.SEND);
    }

    protected List<CommunicationLink> getReceive(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.RECEIVE);
    }

    protected List<CommunicationLink> getCall(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.CALL);
    }

    protected List<CommunicationLink> getExecute(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.EXECUTE);
    }

    protected List<CommunicationLink> getWrite(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.WRITE);
    }

    protected List<CommunicationLink> getAccess(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.ACCESS);
    }

    protected List<CommunicationLink> getAcquire(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.ACQUIRE);
    }

    protected List<CommunicationLink> getTransmit(CommunicationLinkExchanger element) {
        return this.getLinks(element, CommunicationLinkKind.TRANSMIT);
    }

    private List<CommunicationLink> getLinks(CommunicationLinkExchanger element, CommunicationLinkKind kind) {
        ArrayList<CommunicationLink> links = new ArrayList<CommunicationLink>();
        for (CommunicationLink link : element.getOwnedCommunicationLinks()) {
            if (!kind.equals((Object)link.getKind())) continue;
            links.add(link);
        }
        return links;
    }
}

