/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.GeneralizableElementHelper;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemRealization;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.InformationRealization;
import org.polarsys.capella.core.data.information.Operation;

public class ExchangeItemHelper {
    private static ExchangeItemHelper instance;

    private ExchangeItemHelper() {
    }

    public static ExchangeItemHelper getInstance() {
        if (instance == null) {
            instance = new ExchangeItemHelper();
        }
        return instance;
    }

    public Object doSwitch(ExchangeItem element, EStructuralFeature feature) {
        List<Operation> ret = null;
        if (feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__REALIZED_EXCHANGE_ITEMS)) {
            ret = this.getRealizedExchangeItems(element);
        } else if (feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__REALIZING_EXCHANGE_ITEMS)) {
            ret = this.getRealizingExchangeItems(element);
        } else if (feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__REALIZING_OPERATIONS)) {
            ret = this.getRealizingOperations(element);
        } else if (feature.equals(InformationPackage.Literals.EXCHANGE_ITEM__ALLOCATOR_INTERFACES)) {
            ret = this.getAllocatorInterfaces(element);
        }
        if (ret == null) {
            ret = GeneralizableElementHelper.getInstance().doSwitch((GeneralizableElement)element, feature);
        }
        return ret;
    }

    protected List<ExchangeItem> getRealizedExchangeItems(ExchangeItem element) {
        ArrayList<ExchangeItem> ret = new ArrayList<ExchangeItem>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getTargetElement()) instanceof ExchangeItem)) continue;
            ret.add((ExchangeItem)elt);
        }
        return ret;
    }

    protected List<ExchangeItem> getRealizingExchangeItems(ExchangeItem element) {
        ArrayList<ExchangeItem> ret = new ArrayList<ExchangeItem>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement elt;
            if (!(trace instanceof InformationRealization) || !((elt = trace.getSourceElement()) instanceof ExchangeItem)) continue;
            ret.add((ExchangeItem)elt);
        }
        return ret;
    }

    protected List<Operation> getRealizingOperations(ExchangeItem element) {
        ArrayList<Operation> ret = new ArrayList<Operation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            Operation op;
            if (!(trace instanceof ExchangeItemRealization) || (op = ((ExchangeItemRealization)trace).getRealizingOperation()) == null) continue;
            ret.add(op);
        }
        return ret;
    }

    protected List<Interface> getAllocatorInterfaces(ExchangeItem element) {
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (EObject obj : EObjectExt.getReferencers((EObject)element, (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM)) {
            Interface itf;
            if (!(obj instanceof ExchangeItemAllocation) || (itf = ((ExchangeItemAllocation)obj).getAllocatingInterface()) == null) continue;
            ret.add(itf);
        }
        return ret;
    }
}

