/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.AbstractTypeHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.FeatureHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractEventOperationHelper;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemRealization;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.OperationAllocation;

public class OperationHelper {
    private static OperationHelper instance;

    private OperationHelper() {
    }

    public static OperationHelper getInstance() {
        if (instance == null) {
            instance = new OperationHelper();
        }
        return instance;
    }

    public Object doSwitch(Operation element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(InformationPackage.Literals.OPERATION__ALLOCATED_OPERATIONS)) {
            ret = this.getAllocatedOperations(element);
            return ret;
        }
        if (feature.equals(InformationPackage.Literals.OPERATION__ALLOCATING_OPERATIONS)) {
            ret = this.getAllocatingOperations(element);
            return ret;
        }
        if (feature.equals(InformationPackage.Literals.OPERATION__REALIZED_EXCHANGE_ITEMS)) {
            ret = this.getRealizedExchangeItems(element);
        }
        if (ret == null) {
            ret = FeatureHelper.getInstance().doSwitch((Feature)element, feature);
        }
        if (ret == null) {
            ret = AbstractTypeHelper.getInstance().doSwitch((AbstractType)element, feature);
        }
        if (ret == null) {
            ret = AbstractEventOperationHelper.getInstance().doSwitch((AbstractEventOperation)element, feature);
        }
        return ret;
    }

    protected List<Operation> getAllocatedOperations(Operation element) {
        ArrayList<Operation> ret = new ArrayList<Operation>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Operation op;
            if (!(trace instanceof OperationAllocation) || (op = ((OperationAllocation)trace).getAllocatedOperation()) == null) continue;
            ret.add(op);
        }
        return ret;
    }

    protected List<Operation> getAllocatingOperations(Operation element) {
        ArrayList<Operation> ret = new ArrayList<Operation>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            Operation op;
            if (!(trace instanceof OperationAllocation) || (op = ((OperationAllocation)trace).getAllocatingOperation()) == null) continue;
            ret.add(op);
        }
        return ret;
    }

    protected List<ExchangeItem> getRealizedExchangeItems(Operation element) {
        ArrayList<ExchangeItem> ret = new ArrayList<ExchangeItem>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            AbstractExchangeItem item;
            if (!(trace instanceof ExchangeItemRealization) || !((item = ((ExchangeItemRealization)trace).getRealizedItem()) instanceof ExchangeItem)) continue;
            ret.add((ExchangeItem)item);
        }
        return ret;
    }
}

