/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.services;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.helpers.information.services.InformationNamingHelper;
import org.polarsys.capella.core.data.helpers.information.services.Messages;
import org.polarsys.capella.core.data.information.CollectionValue;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datavalue.AbstractBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractComplexValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractEnumerationValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractExpressionValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.BinaryExpression;
import org.polarsys.capella.core.data.information.datavalue.BinaryOperator;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.ComplexValue;
import org.polarsys.capella.core.data.information.datavalue.ComplexValueReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.datavalue.UnaryExpression;
import org.polarsys.capella.core.data.information.datavalue.UnaryOperator;

public class DataValueNamingHelper {
    public static boolean isReferencedValue(EStructuralFeature feature) {
        return DatavaluePackage.Literals.BOOLEAN_REFERENCE__REFERENCED_VALUE.equals(feature) || DatavaluePackage.Literals.COMPLEX_VALUE_REFERENCE__REFERENCED_VALUE.equals(feature) || DatavaluePackage.Literals.ENUMERATION_REFERENCE__REFERENCED_VALUE.equals(feature) || DatavaluePackage.Literals.NUMERIC_REFERENCE__REFERENCED_VALUE.equals(feature) || DatavaluePackage.Literals.STRING_REFERENCE__REFERENCED_VALUE.equals(feature);
    }

    public static String getValue(DataValue element, EStructuralFeature feature) {
        if (element instanceof AbstractEnumerationValue) {
            return DataValueNamingHelper.getValue((AbstractEnumerationValue)element, feature);
        }
        if (element instanceof AbstractBooleanValue) {
            return DataValueNamingHelper.getValue((AbstractBooleanValue)element, feature);
        }
        if (element instanceof AbstractComplexValue) {
            return DataValueNamingHelper.getValue((AbstractComplexValue)element, feature);
        }
        if (element instanceof NumericValue) {
            return DataValueNamingHelper.getValue((NumericValue)element, feature);
        }
        if (element instanceof AbstractStringValue) {
            return DataValueNamingHelper.getValue((AbstractStringValue)element, feature);
        }
        if (element instanceof CollectionValue) {
            return DataValueNamingHelper.getValue((CollectionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(AbstractBooleanValue element, EStructuralFeature feature) {
        if (element instanceof LiteralBooleanValue) {
            return DataValueNamingHelper.getValue((LiteralBooleanValue)element, feature);
        }
        if (element instanceof BooleanReference) {
            return DataValueNamingHelper.getValue((BooleanReference)element, feature);
        }
        if (element instanceof AbstractExpressionValue) {
            return DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(LiteralBooleanValue element, EStructuralFeature feature) {
        if (element != null) {
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            return name + " = " + (element.isValue() ? "TRUE" : "FALSE");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(BooleanReference element, EStructuralFeature feature) {
        if (element != null) {
            AbstractBooleanValue referencedValue;
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            if ((referencedValue = element.getReferencedValue()) != null) {
                return name + " -> " + DataValueNamingHelper.getValue(referencedValue, feature);
            }
            Property referencedProperty = element.getReferencedProperty();
            if (referencedProperty != null) {
                return name + " -> " + InformationNamingHelper.getValue(referencedProperty);
            }
            return name + " -> " + Messages.getString("UndefinedValue");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(NumericValue element, EStructuralFeature feature) {
        if (element instanceof LiteralNumericValue) {
            return DataValueNamingHelper.getValue((LiteralNumericValue)element, feature);
        }
        if (element instanceof NumericReference) {
            return DataValueNamingHelper.getValue((NumericReference)element, feature);
        }
        if (element instanceof AbstractExpressionValue) {
            return DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(AbstractStringValue element, EStructuralFeature feature) {
        if (element instanceof LiteralStringValue) {
            return DataValueNamingHelper.getValue((LiteralStringValue)element, feature);
        }
        if (element instanceof StringReference) {
            return DataValueNamingHelper.getValue((StringReference)element, feature);
        }
        if (element instanceof AbstractExpressionValue) {
            return DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(CollectionValue element, EStructuralFeature feature) {
        if (element != null) {
            String name = element.getName();
            if (name == null) {
                return "";
            }
            return name;
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(LiteralNumericValue element, EStructuralFeature feature) {
        if (element != null) {
            String name;
            if (DataValueNamingHelper.isReferencedValue(feature) && (name = element.getName()) != null && !name.equals("")) {
                return name;
            }
            String value = element.getValue();
            if (value == null) {
                return "";
            }
            return value;
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(NumericReference element, EStructuralFeature feature) {
        if (element != null) {
            NumericValue referencedValue;
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            if ((referencedValue = element.getReferencedValue()) != null) {
                return name + " -> " + referencedValue.getName();
            }
            Property referencedProperty = element.getReferencedProperty();
            if (referencedProperty != null) {
                return name + " -> " + InformationNamingHelper.getValue(referencedProperty);
            }
            return name + " -> " + Messages.getString("UndefinedValue");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(LiteralStringValue element, EStructuralFeature feature) {
        if (element != null) {
            String name = element.getName();
            if (name != null && !name.equals("")) {
                return name;
            }
            String value = element.getValue();
            if (value != null) {
                return "\"" + value + "\"";
            }
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(StringReference element, EStructuralFeature feature) {
        if (element != null) {
            AbstractStringValue referencedValue;
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            if ((referencedValue = element.getReferencedValue()) != null) {
                return name + " -> " + DataValueNamingHelper.getValue(referencedValue, feature);
            }
            Property referencedProperty = element.getReferencedProperty();
            if (referencedProperty != null) {
                return name + " -> " + InformationNamingHelper.getValue(referencedProperty);
            }
            return name + " -> " + Messages.getString("UndefinedValue");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(AbstractEnumerationValue element, EStructuralFeature feature) {
        if (element instanceof EnumerationLiteral) {
            return DataValueNamingHelper.getValue((EnumerationLiteral)element, feature);
        }
        if (element instanceof EnumerationReference) {
            return DataValueNamingHelper.getValue((EnumerationReference)element, feature);
        }
        if (element instanceof AbstractExpressionValue) {
            return DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(EnumerationReference element, EStructuralFeature feature) {
        if (element != null) {
            AbstractEnumerationValue referencedValue;
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            if ((referencedValue = element.getReferencedValue()) != null) {
                AbstractNamedElement eContainer = (AbstractNamedElement)referencedValue.eContainer();
                return name + " -> " + eContainer.getName() + "." + referencedValue.getName();
            }
            Property referencedProperty = element.getReferencedProperty();
            if (referencedProperty != null) {
                return name + " -> " + InformationNamingHelper.getValue(referencedProperty);
            }
            return name + " -> " + Messages.getString("UndefinedValue");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(EnumerationLiteral element, EStructuralFeature feature) {
        if (element != null) {
            return element.getName();
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(AbstractComplexValue element, EStructuralFeature feature) {
        if (element instanceof ComplexValue) {
            return DataValueNamingHelper.getValue((ComplexValue)element, feature);
        }
        if (element instanceof ComplexValueReference) {
            return DataValueNamingHelper.getValue((ComplexValueReference)element, feature);
        }
        if (element instanceof AbstractExpressionValue) {
            return DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(ComplexValue element, EStructuralFeature feature) {
        if (element != null) {
            return element.getName();
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(ComplexValueReference element, EStructuralFeature feature) {
        if (element != null) {
            Property referencedProperty;
            String name = element.getName();
            if (name == null) {
                name = "";
            }
            if ((referencedProperty = element.getReferencedProperty()) != null) {
                return name + " -> " + InformationNamingHelper.getValue(referencedProperty);
            }
            AbstractComplexValue referencedValue = element.getReferencedValue();
            if (referencedValue != null) {
                return name + " -> " + DataValueNamingHelper.getValue(referencedValue, feature);
            }
            return name + " -> " + Messages.getString("UndefinedValue");
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(AbstractExpressionValue element, EStructuralFeature feature) {
        if (element instanceof BinaryExpression) {
            return DataValueNamingHelper.getValue((BinaryExpression)element, feature);
        }
        if (element instanceof UnaryExpression) {
            return DataValueNamingHelper.getValue((UnaryExpression)element, feature);
        }
        return Messages.getString("UndefinedValue");
    }

    public static String getValue(BinaryExpression element, EStructuralFeature feature) {
        return DataValueNamingHelper.getValue(element, feature, false);
    }

    public static String getValue(BinaryExpression element, EStructuralFeature feature, boolean forceExpand) {
        if (element != null) {
            String name = element.getName();
            if ((name == null || name.equals("")) && BinaryOperator.UNSET.equals((Object)element.getOperator())) {
                String exp = element.getUnparsedExpression();
                if (exp == null) {
                    return "";
                }
                return exp;
            }
            if (!forceExpand && name != null && !name.equals("")) {
                return name;
            }
            String operator = null;
            BinaryOperator op = element.getOperator();
            switch (op) {
                case UNSET: {
                    operator = Messages.getString("UndefinedValue");
                    break;
                }
                case ADD: {
                    operator = Messages.getString("BinaryOperator_ADD");
                    break;
                }
                case DIV: {
                    operator = Messages.getString("BinaryOperator_DIV");
                    break;
                }
                case MAX: {
                    operator = Messages.getString("BinaryOperator_MAX");
                    break;
                }
                case MIN: {
                    operator = Messages.getString("BinaryOperator_MIN");
                    break;
                }
                case MUL: {
                    operator = Messages.getString("BinaryOperator_MUL");
                    break;
                }
                case POW: {
                    operator = Messages.getString("BinaryOperator_POW");
                    break;
                }
                case SUB: {
                    operator = Messages.getString("BinaryOperator_SUB");
                    break;
                }
                case EQU: {
                    operator = Messages.getString("BinaryOperator_EQU");
                    break;
                }
                case IOR: {
                    operator = Messages.getString("BinaryOperator_IOR");
                    break;
                }
                case XOR: {
                    operator = Messages.getString("BinaryOperator_XOR");
                    break;
                }
                case AND: {
                    operator = Messages.getString("BinaryOperator_AND");
                }
            }
            if (operator != null) {
                return operator + "(" + DataValueNamingHelper.getOperandValue(element.getOwnedLeftOperand(), feature) + ", " + DataValueNamingHelper.getOperandValue(element.getOwnedRightOperand(), feature) + ")";
            }
        }
        return Messages.getString("UndefinedValue");
    }

    protected static String getOperandValue(DataValue element, EStructuralFeature feature) {
        String value = null;
        value = element instanceof AbstractExpressionValue ? DataValueNamingHelper.getValue((AbstractExpressionValue)element, feature, true) : DataValueNamingHelper.getValue(element, feature);
        return value;
    }

    public static String getValue(AbstractExpressionValue element, EStructuralFeature feature, boolean forceExpand) {
        if (element instanceof UnaryExpression) {
            return DataValueNamingHelper.getValue((UnaryExpression)element, feature, forceExpand);
        }
        if (element instanceof BinaryExpression) {
            return DataValueNamingHelper.getValue((BinaryExpression)element, feature, forceExpand);
        }
        return null;
    }

    public static String getValue(UnaryExpression element, EStructuralFeature feature) {
        return DataValueNamingHelper.getValue(element, feature, false);
    }

    public static String getValue(UnaryExpression element, EStructuralFeature feature, boolean forceExpand) {
        if (element != null) {
            String name = element.getName();
            if ((name == null || name.equals("")) && UnaryOperator.UNSET.equals((Object)element.getOperator())) {
                String exp = element.getUnparsedExpression();
                if (exp == null) {
                    return "";
                }
                return exp;
            }
            if (!forceExpand && name != null && !name.equals("")) {
                return name;
            }
            String operator = null;
            UnaryOperator op = element.getOperator();
            switch (op) {
                case UNSET: {
                    operator = Messages.getString("UndefinedValue");
                    break;
                }
                case NOT: {
                    operator = Messages.getString("UnaryOperator_NOT");
                    break;
                }
                case POS: {
                    operator = Messages.getString("UnaryOperator_POS");
                    break;
                }
                case PRE: {
                    operator = Messages.getString("UnaryOperator_PRE");
                    break;
                }
                case SUC: {
                    operator = Messages.getString("UnaryOperator_SUC");
                    break;
                }
                case VAL: {
                    operator = Messages.getString("UnaryOperator_VAL");
                }
            }
            if (operator != null) {
                return operator + "(" + DataValueNamingHelper.getValue(element.getOwnedOperand(), feature) + ")";
            }
        }
        return Messages.getString("UndefinedValue");
    }
}

