/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.oa.delegates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.InformationsExchangerHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityOperationalCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;

public class EntityHelper {
    private static EntityHelper instance;

    private EntityHelper() {
    }

    public static EntityHelper getInstance() {
        if (instance == null) {
            instance = new EntityHelper();
        }
        return instance;
    }

    public Object doSwitch(Entity element, EStructuralFeature feature) {
        List<OperationalCapability> ret = null;
        if (feature.equals(OaPackage.Literals.ENTITY__SUB_ENTITIES)) {
            ret = this.getSubEntities(element);
        } else if (feature.equals(OaPackage.Literals.ENTITY__ROLE_ALLOCATIONS)) {
            ret = this.getRoleAllocations(element);
        } else if (feature.equals(OaPackage.Literals.ENTITY__ALLOCATED_OPERATIONAL_ACTIVITIES)) {
            ret = this.getAllocatedOperationalActivities(element);
        } else if (feature.equals(OaPackage.Literals.ENTITY__INVOLVING_OPERATIONAL_CAPABILITIES)) {
            ret = this.getInvolvingOperationalCapabilities(element);
        } else if (feature.equals(OaPackage.Literals.ENTITY__ALLOCATED_ROLES)) {
            ret = this.getAllocatedRoles(element);
        } else if (feature.equals(OaPackage.Literals.ENTITY__REALIZING_SYSTEM_COMPONENTS)) {
            ret = this.getRealizingSystemComponents(element);
        }
        if (ret == null) {
            ret = ComponentHelper.getInstance().doSwitch((Component)element, feature);
        }
        if (ret == null) {
            ret = InformationsExchangerHelper.getInstance().doSwitch((InformationsExchanger)element, feature);
        }
        if (ret == null) {
            ret = InvolvedElementHelper.getInstance().doSwitch((InvolvedElement)element, feature);
        }
        return ret;
    }

    protected List<RoleAllocation> getRoleAllocations(Entity element) {
        ArrayList<RoleAllocation> ret = new ArrayList<RoleAllocation>();
        for (AbstractTrace abstractTrace : element.getOutgoingTraces()) {
            if (!(abstractTrace instanceof RoleAllocation)) continue;
            ret.add((RoleAllocation)abstractTrace);
        }
        return ret;
    }

    protected List<Entity> getSubEntities(Entity element) {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Feature feature : element.getOwnedFeatures()) {
            Type type;
            if (!(feature instanceof Part) || !((type = ((Part)feature).getType()) instanceof Entity)) continue;
            ret.add((Entity)type);
        }
        return ret;
    }

    protected List<OperationalActivity> getAllocatedOperationalActivities(Entity element) {
        ArrayList<OperationalActivity> ret = new ArrayList<OperationalActivity>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof OperationalActivity)) continue;
            ret.add((OperationalActivity)function);
        }
        return ret;
    }

    protected List<OperationalCapability> getInvolvingOperationalCapabilities(Entity element) {
        ArrayList<OperationalCapability> ret = new ArrayList<OperationalCapability>();
        for (Involvement inv : element.getInvolvingInvolvements()) {
            OperationalCapability cap;
            if (!(inv instanceof EntityOperationalCapabilityInvolvement) || (cap = ((EntityOperationalCapabilityInvolvement)inv).getCapability()) == null) continue;
            ret.add(cap);
        }
        return ret;
    }

    protected List<SystemComponent> getRealizingSystemComponents(Entity element) {
        return element.getRealizingComponents().stream().filter(SystemComponent.class::isInstance).map(SystemComponent.class::cast).collect(Collectors.toList());
    }

    protected List<Role> getAllocatedRoles(Entity element) {
        ArrayList<Role> ret = new ArrayList<Role>();
        for (RoleAllocation roleAllocation : element.getRoleAllocations()) {
            Role role = roleAllocation.getRole();
            if (role == null) continue;
            ret.add(role);
        }
        return ret;
    }
}

