/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.validation.statetransition;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.fa.AbstractFunction;

public class MDCHK_StateMachine_AvailableFunctions
extends AbstractModelConstraint {
    private static final String DO_ACTIVITY = "doActivity";
    private static final String ENTRY = "entry";
    private static final String EXIT = "exit";

    public IStatus validate(IValidationContext ctx) {
        State state = (State)ctx.getTarget();
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        EList availableFunctions = state.getAvailableAbstractFunctions();
        for (AbstractEvent activity : state.getDoActivity()) {
            if (activity instanceof AbstractFunction && availableFunctions.contains(activity)) continue;
            result.add(ctx.createFailureStatus(new Object[]{DO_ACTIVITY, activity.getName(), state.getName()}));
        }
        for (AbstractEvent entry : state.getEntry()) {
            if (entry instanceof AbstractFunction && availableFunctions.contains(entry)) continue;
            result.add(ctx.createFailureStatus(new Object[]{ENTRY, entry.getName(), state.getName()}));
        }
        for (AbstractEvent exit : state.getExit()) {
            if (exit instanceof AbstractFunction && availableFunctions.contains(exit)) continue;
            result.add(ctx.createFailureStatus(new Object[]{EXIT, exit.getName(), state.getName()}));
        }
        if (!result.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, result);
        }
        return ctx.createSuccessStatus();
    }
}

