/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.application;

import java.util.HashMap;
import org.eclipse.core.runtime.Platform;

public class ArgumentsHelper {
    private HashMap<String, String> values = null;
    private boolean defaultLoaded = false;
    private static ArgumentsHelper instance = new ArgumentsHelper();

    public static ArgumentsHelper getInstance() {
        return instance;
    }

    private void loadArguments() {
        if (!this.defaultLoaded) {
            this.defaultLoaded = true;
            this.loadArguments(Platform.getApplicationArgs());
        }
    }

    public void loadArguments(String[] args) {
        if (this.values == null) {
            this.values = new HashMap();
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i].toLowerCase();
            if (arg.startsWith("-")) {
                String value;
                String string = value = i < args.length - 1 ? args[i + 1] : null;
                if (value != null && !value.startsWith("-")) {
                    this.values.put(arg, value);
                } else {
                    this.values.put(arg, null);
                }
            }
            ++i;
        }
    }

    public String getString(String parameter) {
        this.loadArguments();
        String arg = parameter.toLowerCase();
        if (this.values.containsKey(arg)) {
            return this.values.get(arg);
        }
        return null;
    }

    public boolean hasParameter(String parameter) {
        this.loadArguments();
        String arg = parameter.toLowerCase();
        return this.values.containsKey(arg);
    }
}

