/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.AbstractFragment;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;

public class AbstractFragmentExt {
    public static boolean isEmpty(CombinedFragment combinedFragment, Scenario scenario) {
        InteractionFragment start = combinedFragment.getStart();
        InteractionFragment finish = combinedFragment.getFinish();
        EList interactionFragments = scenario.getOwnedInteractionFragments();
        int startIndex = interactionFragments.indexOf(start);
        int finishIndex = interactionFragments.indexOf(finish);
        for (InteractionFragment fragment : interactionFragments.subList(startIndex, finishIndex + 1)) {
            if (!(fragment instanceof AbstractEnd)) continue;
            return false;
        }
        return true;
    }

    public static List<InteractionOperand> getOwnedOperands(CombinedFragment combinedFragment, Scenario scenario) {
        ArrayList<InteractionOperand> result = new ArrayList<InteractionOperand>();
        if (scenario == null || combinedFragment == null) {
            return result;
        }
        InteractionFragment start = combinedFragment.getStart();
        InteractionFragment finish = combinedFragment.getFinish();
        EList interactionFragments = scenario.getOwnedInteractionFragments();
        int startIndex = interactionFragments.indexOf(start);
        int finishIndex = interactionFragments.indexOf(finish);
        for (InteractionFragment fragment : interactionFragments.subList(startIndex, finishIndex + 1)) {
            if (!(fragment instanceof InteractionOperand)) continue;
            result.add((InteractionOperand)fragment);
        }
        return result;
    }

    public static List<InstanceRole> getCoveredInstanceRoles(AbstractFragment abstractFragment, Scenario scenario) {
        ArrayList<InstanceRole> coveredInstanceRoles = new ArrayList<InstanceRole>();
        if (scenario == null || abstractFragment == null) {
            return coveredInstanceRoles;
        }
        FragmentEnd srcStart = (FragmentEnd)abstractFragment.getStart();
        for (InstanceRole srcInstanceRole : srcStart.getCoveredInstanceRoles()) {
            for (CapellaElement tgtInstanceRole : CapellaElementExt.getRefinementSrcElements((CapellaElement)srcInstanceRole, InteractionPackage.Literals.INSTANCE_ROLE, (EObject)scenario)) {
                if (tgtInstanceRole == null || coveredInstanceRoles.contains(tgtInstanceRole)) continue;
                coveredInstanceRoles.add((InstanceRole)tgtInstanceRole);
            }
        }
        FragmentEnd srcFinish = (FragmentEnd)abstractFragment.getFinish();
        for (InstanceRole srcInstanceRole : srcFinish.getCoveredInstanceRoles()) {
            for (CapellaElement tgtInstanceRole : CapellaElementExt.getRefinementSrcElements((CapellaElement)srcInstanceRole, InteractionPackage.Literals.INSTANCE_ROLE, (EObject)scenario)) {
                if (tgtInstanceRole == null || coveredInstanceRoles.contains(tgtInstanceRole)) continue;
                coveredInstanceRoles.add((InstanceRole)tgtInstanceRole);
            }
        }
        return coveredInstanceRoles;
    }

    public static List<InstanceRole> getCoveredInstanceRoles(FragmentEnd fragmentStart, FragmentEnd fragmentFinish, Scenario scenario) {
        ArrayList<InstanceRole> coveredInstanceRoles = new ArrayList<InstanceRole>();
        if (scenario == null || fragmentStart == null || fragmentFinish == null) {
            return coveredInstanceRoles;
        }
        EList interactionFragments = scenario.getOwnedInteractionFragments();
        int start = interactionFragments.indexOf(fragmentStart);
        int finish = interactionFragments.indexOf(fragmentFinish);
        for (InteractionFragment fragment : interactionFragments.subList(start, finish)) {
            if (fragment instanceof AbstractEnd) {
                InstanceRole instanceRole = ((AbstractEnd)fragment).getCovered();
                if (instanceRole == null || coveredInstanceRoles.contains(instanceRole)) continue;
                coveredInstanceRoles.add(instanceRole);
                continue;
            }
            if (!(fragment instanceof FragmentEnd)) continue;
            for (InstanceRole instanceRole : ((FragmentEnd)fragment).getCoveredInstanceRoles()) {
                if (instanceRole == null || coveredInstanceRoles.contains(instanceRole)) continue;
                coveredInstanceRoles.add(instanceRole);
            }
        }
        return coveredInstanceRoles;
    }

    public static Set<InstanceRole> getMinimalCoveredInstanceRoles(CombinedFragment fragment) {
        HashSet<InstanceRole> coveredInstanceRoles = new HashSet<InstanceRole>();
        Scenario scenario = (Scenario)fragment.eContainer();
        FragmentEnd fragStart = (FragmentEnd)fragment.getStart();
        FragmentEnd fragFinish = (FragmentEnd)fragment.getFinish();
        EList interactionFragments = scenario.getOwnedInteractionFragments();
        int start = interactionFragments.indexOf(fragStart);
        int finish = interactionFragments.indexOf(fragFinish);
        int currentIndex = start + 1;
        while (currentIndex < finish) {
            InteractionFragment currentFragment;
            if ((currentFragment = (InteractionFragment)interactionFragments.get(currentIndex++)) instanceof AbstractEnd) {
                AbstractEnd ae = (AbstractEnd)currentFragment;
                if (!fragStart.getCoveredInstanceRoles().contains((Object)ae.getCovered())) continue;
                coveredInstanceRoles.add(ae.getCovered());
                continue;
            }
            if (fragment.getReferencedOperands().contains((Object)currentFragment)) continue;
            coveredInstanceRoles.addAll((Collection<InstanceRole>)currentFragment.getCoveredInstanceRoles());
        }
        return coveredInstanceRoles;
    }
}

