/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class ClassifierExt {
    public static List<EObject> getAllTypes(GeneralizableElement classifier) {
        List<EObject> list = new ArrayList<EObject>();
        if (classifier != null) {
            Structure structure = (Structure)classifier.eContainer();
            if (structure != null) {
                BlockArchitecture arch = StructureExt.getRootBlockArchitecture(structure);
                if (arch != null) {
                    if (arch instanceof LogicalArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((LogicalArchitecture)arch).getOwnedDataPkg()));
                        list.addAll(BlockArchitectureExt.getAllInterfaces((BlockArchitecture)((LogicalArchitecture)arch)));
                    } else if (arch instanceof PhysicalArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((PhysicalArchitecture)arch).getOwnedDataPkg()));
                        list.addAll(PhysicalArchitectureExt.getAllInterfaces(arch, null, false));
                    } else if (arch instanceof EPBSArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((EPBSArchitecture)arch).getOwnedDataPkg()));
                    }
                }
                SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)classifier);
                SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng);
                if (sysEng != null) {
                    list.addAll(DataPkgExt.getAllTypesFromDataPkg(ca.getOwnedDataPkg()));
                    list.addAll(InterfacePkgExt.getAllInterfaces(ca.getOwnedInterfacePkg()));
                }
            }
            list = ListExt.removeDuplicates(list);
        }
        return list;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)modelElement);
    }

    public static Component getRootComponent(GeneralizableElement classifier) {
        Structure structure;
        Component comp = null;
        if (classifier != null && (structure = (Structure)classifier.eContainer()) != null) {
            comp = StructureExt.getRootComponent(structure);
        }
        return comp;
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(GeneralizableElement classifier) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (classifier != null) {
            Component parentComp;
            BlockArchitecture compArch = ClassifierExt.getRootBlockArchitecture((ModelElement)classifier);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = ClassifierExt.getRootComponent(classifier)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromParentHierarchy(GeneralizableElement classifier) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (classifier != null) {
            Component parentComp;
            BlockArchitecture compArch = ClassifierExt.getRootBlockArchitecture((ModelElement)classifier);
            if (compArch != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(compArch.getOwnedInterfacePkg()));
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = ClassifierExt.getRootComponent(classifier)) != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(parentComp.getOwnedInterfacePkg()));
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static DataPkg getRootDataPkg(GeneralizableElement classifier) {
        DataPkg dataPkg = null;
        if (classifier != null) {
            EObject container = classifier.eContainer();
            if (container instanceof DataPkg) {
                dataPkg = (DataPkg)container;
            } else if (container instanceof Structure) {
                dataPkg = ClassifierExt.getDataPkg((Structure)container);
            }
        }
        return dataPkg;
    }

    public static DataPkg getDataPkg(Structure structure) {
        DataPkg dataPkg = null;
        if (structure != null) {
            EObject container = structure.eContainer();
            if (container instanceof DataPkg) {
                dataPkg = (DataPkg)container;
            } else if (container instanceof Structure) {
                dataPkg = ClassifierExt.getDataPkg((Structure)container);
            }
        }
        return dataPkg;
    }

    public static Collection<Property> getOwnedProperties(Classifier classifier) {
        HashSet<Property> returnedCollection = new HashSet<Property>();
        for (Feature aFeature : classifier.getOwnedFeatures()) {
            if (!(aFeature instanceof Property)) continue;
            returnedCollection.add((Property)aFeature);
        }
        return returnedCollection;
    }

    public static Collection<Association> getIncomingAndOutgoingAssociations(Classifier classifier) {
        HashSet<Association> returnedCollection = new HashSet<Association>();
        HashSet<Property> linkedProperties = new HashSet<Property>();
        linkedProperties.addAll(ClassifierExt.getOwnedProperties(classifier));
        for (TypedElement aTypedElement : classifier.getTypedElements()) {
            if (!(aTypedElement instanceof Property)) continue;
            linkedProperties.add((Property)aTypedElement);
        }
        for (Property aProperty : linkedProperties) {
            if (aProperty.getAssociation() != null) {
                returnedCollection.add(aProperty.getAssociation());
            }
            if (!(aProperty.eContainer() instanceof Association)) continue;
            returnedCollection.add((Association)aProperty.eContainer());
        }
        return returnedCollection;
    }
}

