/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;

public class LogicalComponentPkgExt {
    public static LogicalComponentPkg getRootLogicalComponentPkg(LogicalComponentPkg lcPkg) {
        LogicalComponentPkg rootPkg = null;
        if (lcPkg != null) {
            EObject container = lcPkg.eContainer();
            if (container instanceof LogicalComponent || container instanceof LogicalArchitecture) {
                return lcPkg;
            }
            if (container instanceof LogicalComponentPkg) {
                rootPkg = LogicalComponentPkgExt.getRootLogicalComponentPkg((LogicalComponentPkg)container);
            }
        }
        return rootPkg;
    }

    public static List<LogicalArchitecture> getAllLogicalArchitectures(LogicalComponentPkg lcPkg) {
        ArrayList<LogicalArchitecture> list = new ArrayList<LogicalArchitecture>();
        if (lcPkg != null) {
            for (LogicalComponent lc : lcPkg.getOwnedLogicalComponents()) {
                list.addAll(LogicalComponentExt.getAllLogicalArchitectures(lc));
            }
            for (LogicalComponentPkg subLCPkg : lcPkg.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllLogicalArchitectures(subLCPkg));
            }
        }
        return list;
    }

    public static List<LogicalComponent> getAllLCsFromLCPkg(LogicalComponentPkg lcPkg) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>();
        if (lcPkg != null) {
            list.addAll((Collection<LogicalComponent>)lcPkg.getOwnedLogicalComponents());
            for (LogicalComponentPkg subLCPkg : lcPkg.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllLCsFromLCPkg(subLCPkg));
            }
        }
        return list;
    }

    public static List<CapellaElement> getAllInterfacesInLogicalComponentPkg(LogicalComponentPkg lcPkg) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (lcPkg != null) {
            for (LogicalComponent lc : lcPkg.getOwnedLogicalComponents()) {
                list.addAll(LogicalComponentExt.getAllInterfacesInLogicalComponent(lc));
            }
            for (LogicalComponentPkg subLCPkg : lcPkg.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(subLCPkg));
            }
        }
        return list;
    }

    public static List<CapellaElement> getAllInterfacesInLogicalComponentPkg(LogicalComponentPkg lcPkg, LogicalComponent currentLC, boolean usedFlag) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (lcPkg != null) {
            for (LogicalComponent lc : lcPkg.getOwnedLogicalComponents()) {
                list.addAll(LogicalComponentExt.getInterfacesFromSameLevelLogicalComponent(lc, currentLC, usedFlag));
            }
            for (LogicalComponentPkg subLCPkg : lcPkg.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(subLCPkg, currentLC, usedFlag));
            }
        }
        return list;
    }
}

