/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class PartExt {
    public static void addPart(AbstractType abstractType, Part part, ComponentArchitecture componentArchitecture) {
        SystemComponentPkg componentPkg = null;
        if (componentArchitecture instanceof SystemAnalysis) {
            componentPkg = ((SystemAnalysis)componentArchitecture).getOwnedSystemComponentPkg();
        } else if (componentArchitecture instanceof LogicalArchitecture) {
            componentPkg = ((LogicalArchitecture)componentArchitecture).getOwnedLogicalComponentPkg();
        } else if (componentArchitecture instanceof PhysicalArchitecture) {
            componentPkg = ((PhysicalArchitecture)componentArchitecture).getOwnedPhysicalComponentPkg();
        }
        if (componentPkg != null) {
            part.setAbstractType(abstractType);
            componentPkg.getOwnedParts().add((Object)part);
        }
    }

    public static final List<ComponentExchange> getComponentExchanges(Part part) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>();
        for (AbstractInformationFlow flow : part.getInformationFlows()) {
            if (!(flow instanceof ComponentExchange)) continue;
            componentExchanges.add((ComponentExchange)flow);
        }
        for (ComponentExchangeEnd end : (Collection)ModelCache.getCache(FunctionalExt::getRelatedComponentExchangeEnds, (Object)part)) {
            EObject owner = end.eContainer();
            if (!(owner instanceof ComponentExchange)) continue;
            componentExchanges.add((ComponentExchange)owner);
        }
        return componentExchanges;
    }

    public static List<Component> getComponentsOfParts(Collection<Part> parts) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Part part : parts) {
            if (!(part.getAbstractType() instanceof Component)) continue;
            components.add((Component)part.getAbstractType());
        }
        return components;
    }

    public static Component getComponentOfPart(Part part) {
        if (part.getAbstractType() instanceof Component) {
            return (Component)part.getAbstractType();
        }
        return null;
    }

    public static List<Part> getSubUsedParts(Part part) {
        return ComponentExt.getSubParts((Component)part.getAbstractType());
    }

    public static List<Part> getSubUsedAndDeployedParts(Part part) {
        ArrayList<Part> result = new ArrayList<Part>();
        result.addAll(PartExt.getDeployedParts(part));
        if (part.getAbstractType() != null) {
            result.addAll(ComponentExt.getSubParts((Component)part.getAbstractType()));
        }
        return result;
    }

    public static List<Component> getSubUsedAndDeployedComponentsOfPart(Part part) {
        return PartExt.getComponentsOfParts(PartExt.getSubUsedAndDeployedParts(part));
    }

    public static List<DeployableElement> getDeployedElements(Part part) {
        ArrayList<DeployableElement> result = new ArrayList<DeployableElement>(1);
        EList deployments = part.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            PartDeploymentLink deploymentLink;
            DeployableElement deployedElement;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (deployedElement = (deploymentLink = (PartDeploymentLink)abstractDeployment).getDeployedElement()) == null) continue;
            result.add(deployedElement);
        }
        return result;
    }

    public static List<Part> getDeployedParts(Part part) {
        ArrayList<Part> result = new ArrayList<Part>();
        for (DeployableElement element : PartExt.getDeployedElements(part)) {
            if (!(element instanceof Part)) continue;
            result.add((Part)element);
        }
        return result;
    }

    public static List<DeployableElement> getAllDeployableElements(Part part) {
        ArrayList<DeployableElement> result = new ArrayList<DeployableElement>(1);
        ArrayList<Part> parts = new ArrayList<Part>(1);
        List<DeployableElement> deployedElements = PartExt.getDeployedElements(part);
        result.addAll(deployedElements);
        for (DeployableElement deployableElement : deployedElements) {
            if (!(deployableElement instanceof Part)) continue;
            parts.add((Part)deployableElement);
        }
        for (Part partx : parts) {
            result.addAll(PartExt.getAllDeployableElements(partx));
        }
        return result;
    }

    public static boolean isDeploying(Part partDeployer, Part deployed) {
        EList deployments = partDeployer.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            PartDeploymentLink deploymentLink;
            DeployableElement deployedElement;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (deployedElement = (deploymentLink = (PartDeploymentLink)abstractDeployment).getDeployedElement()) == null || !deployedElement.equals(deployed)) continue;
            return true;
        }
        return false;
    }

    public static List<DeploymentTarget> getDeployingElements(Part part) {
        ArrayList<DeploymentTarget> result = new ArrayList<DeploymentTarget>(1);
        EList deployingLinks = part.getDeployingLinks();
        for (AbstractDeploymentLink abstractDeployment : deployingLinks) {
            PartDeploymentLink deploymentLink;
            DeploymentTarget location;
            if (!(abstractDeployment instanceof PartDeploymentLink) || (location = (deploymentLink = (PartDeploymentLink)abstractDeployment).getLocation()) == null) continue;
            result.add(location);
        }
        return result;
    }

    public static List<Component> getAllDeployableComponents(Component component) {
        ArrayList<Component> result = new ArrayList<Component>(1);
        EList abstractTypedElements = component.getAbstractTypedElements();
        for (AbstractTypedElement abstractTypedElement : abstractTypedElements) {
            if (!(abstractTypedElement instanceof Part)) continue;
            Part part = (Part)abstractTypedElement;
            List<DeployableElement> deployedElements = PartExt.getAllDeployableElements(part);
            for (DeployableElement deployableElement : deployedElements) {
                AbstractType abstractType;
                if (!(deployableElement instanceof Part) || (abstractType = ((Part)deployableElement).getAbstractType()) == null || !(abstractType instanceof Component)) continue;
                result.add((Component)abstractType);
            }
        }
        return result;
    }

    public static List<Part> getAllPartsFromBlockArch(BlockArchitecture architecture) {
        ArrayList<Part> result = new ArrayList<Part>();
        Collection<Component> allComponents = BlockArchitectureExt.getAllComponents(architecture);
        for (CapellaElement capellaElement : allComponents) {
            if (!(capellaElement instanceof Component)) continue;
            Component currentComponent = (Component)capellaElement;
            for (Part part : currentComponent.getRepresentingParts()) {
                result.add(part);
            }
        }
        return result;
    }

    public static List<Part> getAllPartsFromPhysicalArchitecture(PhysicalArchitecture blockArch) {
        ArrayList<Part> result = new ArrayList<Part>();
        Collection<Component> allComponents = BlockArchitectureExt.getAllComponents((BlockArchitecture)blockArch);
        for (Component aComponent : allComponents) {
            for (Part part : aComponent.getRepresentingParts()) {
                result.add(part);
            }
        }
        return result;
    }

    public static Collection<Part> getFirstPartAncestors(Part currentPart) {
        LinkedList<Part> parents = new LinkedList<Part>();
        parents.addAll((Collection)ModelCache.getCache(PartExt::getDeployingElements, (Object)currentPart));
        Component directParent = ComponentExt.getDirectParent(currentPart);
        if (directParent != null) {
            parents.addAll((Collection<Part>)directParent.getRepresentingParts());
        }
        return parents;
    }

    public static boolean isDeployable(Part part) {
        if (CapellaModelPreferencesPlugin.getDefault().isMultipleDeploymentAllowed()) {
            return true;
        }
        return part.getDeployingParts().isEmpty();
    }

    public static boolean isDeployed(Part part) {
        return !part.getDeployingParts().isEmpty();
    }

    public static boolean canMoveInto(Part source, Component target) {
        Collection representingParts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)target);
        for (Part part : representingParts) {
            Collection<Part> parts = ComponentExt.getPartAncestors(part);
            if (!parts.contains(source)) continue;
            return false;
        }
        return ComponentExt.canMoveInto((Component)source.getAbstractType(), target);
    }

    public static boolean canMoveInto(Part source, ComponentPkg target) {
        Component parentComponent = ComponentPkgExt.getParentComponent(target);
        if (parentComponent != null) {
            return PartExt.canMoveInto(source, parentComponent);
        }
        return ComponentExt.isActor((EObject)source) && ComponentExt.canCreateABActor((EObject)target) || !ComponentExt.isActor((EObject)source) && ComponentExt.canCreateABComponent((EObject)target);
    }

    public static boolean canMoveInto(Part source, ModelElement target) {
        if (target instanceof Component) {
            return PartExt.canMoveInto(source, (Component)target);
        }
        if (target instanceof ComponentPkg) {
            return PartExt.canMoveInto(source, (ComponentPkg)target);
        }
        return false;
    }
}

