/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.model.helpers.SequenceLinkEndExt;

public class SequenceLinkExt {
    private SequenceLinkExt() {
    }

    private static void findClosestSemanticFCIFunctionsAsTargets(SequenceLink sequenceLink, Set<FunctionalChainInvolvementFunction> closestSemanticFCIFunctions, Set<SequenceLinkEnd> visitedEnds) {
        SequenceLinkEnd targetEnd = sequenceLink.getTarget();
        if (!visitedEnds.contains(targetEnd)) {
            visitedEnds.add(targetEnd);
            if (targetEnd instanceof FunctionalChainInvolvementFunction) {
                closestSemanticFCIFunctions.add((FunctionalChainInvolvementFunction)targetEnd);
            } else {
                SequenceLinkEndExt.getOutgoingSequenceLinks(targetEnd).stream().forEach(link -> SequenceLinkExt.findClosestSemanticFCIFunctionsAsTargets(link, closestSemanticFCIFunctions, visitedEnds));
            }
        }
    }

    public static Set<FunctionalChainInvolvementFunction> findClosestSemanticFCIFunctionsAsTargets(SequenceLink seqLink) {
        HashSet<FunctionalChainInvolvementFunction> closestSemanticFCIFunctionAsTarget = new HashSet<FunctionalChainInvolvementFunction>();
        HashSet<SequenceLinkEnd> visitedEnds = new HashSet<SequenceLinkEnd>();
        SequenceLinkExt.findClosestSemanticFCIFunctionsAsTargets(seqLink, closestSemanticFCIFunctionAsTarget, visitedEnds);
        return closestSemanticFCIFunctionAsTarget;
    }

    private static void findClosestFCIFunctionsAsSources(SequenceLink seqLink, Set<FunctionalChainInvolvementFunction> closestSemanticFCIFunctions, Set<SequenceLinkEnd> visitedEnds) {
        SequenceLinkEnd sourceEnd = seqLink.getSource();
        if (!visitedEnds.contains(sourceEnd)) {
            visitedEnds.add(sourceEnd);
            if (sourceEnd instanceof FunctionalChainInvolvementFunction) {
                closestSemanticFCIFunctions.add((FunctionalChainInvolvementFunction)sourceEnd);
            } else {
                SequenceLinkEndExt.getIncomingSequenceLinks(sourceEnd).stream().forEach(link -> SequenceLinkExt.findClosestFCIFunctionsAsSources(link, closestSemanticFCIFunctions, visitedEnds));
            }
        }
    }

    public static Set<FunctionalChainInvolvementFunction> findClosestSemanticFCIFunctionsAsSources(SequenceLink seqLink) {
        HashSet<FunctionalChainInvolvementFunction> closestFCIFunctionsAsSources = new HashSet<FunctionalChainInvolvementFunction>();
        HashSet<SequenceLinkEnd> visitedEnds = new HashSet<SequenceLinkEnd>();
        SequenceLinkExt.findClosestFCIFunctionsAsSources(seqLink, closestFCIFunctionsAsSources, visitedEnds);
        return closestFCIFunctionsAsSources;
    }

    public static Set<FunctionalChainInvolvementLink> getAllFCILBetweenClosestFunctionGroups(SequenceLink seqLink) {
        HashSet<FunctionalChainInvolvementLink> involvementLinks = new HashSet<FunctionalChainInvolvementLink>();
        Set<FunctionalChainInvolvementFunction> incomingFunctions = SequenceLinkExt.findClosestSemanticFCIFunctionsAsSources(seqLink);
        Set<FunctionalChainInvolvementFunction> outgoingFunctions = SequenceLinkExt.findClosestSemanticFCIFunctionsAsTargets(seqLink);
        for (FunctionalChainInvolvementFunction function : incomingFunctions) {
            EList outgoingInvolvementLinks = function.getOutgoingInvolvementLinks();
            for (FunctionalChainInvolvementLink link : outgoingInvolvementLinks) {
                if (!outgoingFunctions.contains(link.getTarget()) || link.getTarget().equals(function)) continue;
                involvementLinks.add(link);
            }
        }
        return involvementLinks;
    }
}

