/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyViolation;

public class DependencyChecker {
    protected SemanticEditingDomainFactory.SemanticEditingDomain domain;
    protected Map<EObject, Set<EObject>> correctLinks = new HashMap<EObject, Set<EObject>>();
    protected Map<IModelIdentifier, Set<IModelIdentifier>> modelIndentifier2AllReferencedModelIdentifiers = new HashMap<IModelIdentifier, Set<IModelIdentifier>>();
    protected Set<DependencyViolation> dependencyViolations = new HashSet<DependencyViolation>();

    public DependencyChecker(SemanticEditingDomainFactory.SemanticEditingDomain domain) {
        this.domain = domain;
    }

    public Set<DependencyViolation> getDependencyViolations() {
        return this.dependencyViolations;
    }

    public Set<IModelIdentifier> getAllReferencedLibraryIdentifiers(IModel model) {
        Set<IModelIdentifier> res = this.modelIndentifier2AllReferencedModelIdentifiers.get(model.getIdentifier());
        if (res == null) {
            res = new HashSet<IModelIdentifier>();
            for (IModel referencedModel : LibraryManagerExt.getAllReferences((IModel)model)) {
                res.add(referencedModel.getIdentifier());
            }
            this.modelIndentifier2AllReferencedModelIdentifiers.put(model.getIdentifier(), res);
        }
        return res;
    }

    public boolean checkLink(EObject source, EObject target, EReference reference) {
        if (source.eResource() != target.eResource()) {
            if (this.doesLinkHasBeenDeclaredAsCorrect(source, target)) {
                return true;
            }
            IModel sourceModel = ILibraryManager.INSTANCE.getModel(source);
            IModel targetModel = ILibraryManager.INSTANCE.getModel(target);
            if (sourceModel != null && targetModel != null && !sourceModel.equals(targetModel)) {
                boolean res = this.getAllReferencedLibraryIdentifiers(sourceModel).contains(targetModel.getIdentifier());
                if (res) {
                    this.declareLinkAsCorrect(source, target);
                } else {
                    this.dependencyViolations.add(new DependencyViolation(source, target, reference));
                }
                return res;
            }
        }
        return true;
    }

    public boolean checkAllLinks(EObject object) {
        for (EReference ref : object.eClass().getEAllReferences()) {
            Object o;
            if (ref.isDerived() || (o = object.eGet((EStructuralFeature)ref)) == null) continue;
            HashSet<EObject> targetedObjects = new HashSet<EObject>();
            if (o instanceof List) {
                for (Object item : (List)o) {
                    if (!(item instanceof EObject)) continue;
                    targetedObjects.add((EObject)item);
                }
            } else if (o instanceof EObject) {
                targetedObjects.add((EObject)o);
            }
            for (EObject target : targetedObjects) {
                if (!this.checkLink(object, target, ref)) {
                    return false;
                }
                if (!ref.isContainment() || this.checkAllLinks(target)) continue;
                return false;
            }
        }
        for (EObject source : EObjectExt.getReferencers((EObject)object, null, (SemanticEditingDomainFactory.SemanticEditingDomain)this.domain, (boolean)true)) {
            if (this.checkLink(source, object, null)) continue;
            return false;
        }
        return true;
    }

    protected void declareLinkAsCorrect(EObject source, EObject target) {
        Set list = this.correctLinks.computeIfAbsent(source, f -> new HashSet());
        list.add(target);
    }

    protected boolean doesLinkHasBeenDeclaredAsCorrect(EObject source, EObject target) {
        Set<EObject> list = this.correctLinks.get(source);
        return list != null && list.contains(target);
    }
}

