/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyChecker;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelCycle;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.InterModelInconsistency;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.LinkHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.TarjanAlgorithm;

public class InterModelInconsistencyDetector {
    protected Map<Integer, EObject> ident2Object = new HashMap<Integer, EObject>();
    protected Map<EObject, Integer> object2Ident = new HashMap<EObject, Integer>();
    protected List<InterModelInconsistency> errors = new ArrayList<InterModelInconsistency>();
    protected int identifierCounter = 0;
    protected DependencyChecker linkChecker;

    public List<InterModelInconsistency> getInterModelInconsistencies(SystemEngineering systemEngineering) {
        this.linkChecker = this.createDependencyChecker(systemEngineering);
        Set<EObject> allObjects = this.getAllContents(systemEngineering);
        HashMap<Integer, Set<Integer>> g = new HashMap<Integer, Set<Integer>>();
        Set<EObject> objectsToTreat = allObjects;
        while (!(objectsToTreat = this.treatObjects(objectsToTreat, allObjects, g)).isEmpty()) {
            allObjects.addAll(objectsToTreat);
        }
        HashSet[] graph = new HashSet[this.identifierCounter];
        int i = 0;
        while (i < this.identifierCounter) {
            HashSet x = (HashSet)g.get(i);
            if (x == null) {
                x = new HashSet();
            }
            graph[i] = x;
            ++i;
        }
        TarjanAlgorithm t = new TarjanAlgorithm();
        List<List<Integer>> scComponents = t.getSCComponents(graph);
        ArrayList cfcs = new ArrayList();
        for (List<Integer> list : scComponents) {
            if (list.size() <= 1) continue;
            ArrayList<EObject> cfc = new ArrayList<EObject>();
            for (Integer n : list) {
                cfc.add(this.ident2Object.get(n));
            }
            cfcs.add(cfc);
        }
        for (List<Integer> list : cfcs) {
            HashSet<Resource> res = new HashSet<Resource>();
            for (EObject eObject : list) {
                Resource objRes = CapellaResourceHelper.getMainModelResource((EObject)eObject);
                if (objRes == null) continue;
                res.add(objRes);
            }
            if (res.size() <= 1) continue;
            this.errors.add(new InterModelCycle(list));
        }
        this.errors.addAll(this.linkChecker.getDependencyViolations());
        return this.errors;
    }

    private Set<EObject> getAllContents(SystemEngineering systemEngineering) {
        TreeIterator treeIterator = systemEngineering.eAllContents();
        HashSet<EObject> allObjects = new HashSet<EObject>();
        while (treeIterator.hasNext()) {
            allObjects.add((EObject)treeIterator.next());
        }
        return allObjects;
    }

    private DependencyChecker createDependencyChecker(SystemEngineering systemEngineering) {
        return new DependencyChecker((SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)systemEngineering));
    }

    protected Integer getObjectIdentifier(EObject object) {
        return this.object2Ident.computeIfAbsent(object, f -> {
            Integer res = this.identifierCounter;
            ++this.identifierCounter;
            this.ident2Object.put(res, object);
            return res;
        });
    }

    protected Set<EObject> treatObjects(Set<EObject> objects, Set<EObject> allObjects, Map<Integer, Set<Integer>> g) {
        HashSet<EObject> newObjects = new HashSet<EObject>();
        for (EObject currentNode : objects) {
            HashSet<Integer> targetedNodeIdent = new HashSet<Integer>();
            g.put(this.getObjectIdentifier(currentNode), targetedNodeIdent);
            HashSet<EObject> targetedObjects = LinkHelper.getTargetedObjects(currentNode);
            for (EObject targetedObject : targetedObjects) {
                if (!allObjects.contains(targetedObject)) {
                    newObjects.add(targetedObject);
                }
                targetedNodeIdent.add(this.getObjectIdentifier(targetedObject));
                this.linkChecker.checkLink(currentNode, targetedObject, null);
            }
        }
        return newObjects;
    }
}

