/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.listeners;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class CapellaModelDataListenerForDatas
extends CapellaModelDataListener {
    private Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    private static String DELETION_MSG = "Setting \"{0}\" class to primitive implies the deletion of element: \"{1}\" ({2})";

    public void notifyChanged(Notification notification) {
        if (this.filterNotification(notification)) {
            return;
        }
        if (notification.getEventType() != 1) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (feature != null) {
            Object value;
            Object notifier;
            if (feature.equals(ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
                EObject value2;
                final Object notifier2 = notification.getNotifier();
                if (notifier2 instanceof Property && (value2 = (EObject)notification.getNewValue()) instanceof DataType && !((Property)notifier2).getAggregationKind().equals((Object)AggregationKind.COMPOSITION)) {
                    this.executeCommand((EObject)((Property)notifier2), (ICommand)new AbstractReadWriteCommand(){

                        public void run() {
                            ((Property)notifier2).setAggregationKind(AggregationKind.COMPOSITION);
                        }
                    });
                }
            } else if (feature.equals(InformationPackage.Literals.CLASS__IS_PRIMITIVE) && (notifier = notification.getNotifier()) instanceof Class && (value = notification.getNewValue()) instanceof Boolean && Boolean.TRUE.equals(value) && CapellaModelPreferencesPlugin.getDefault().isPrimitiveSynchroAllowed()) {
                final ArrayList<Association> assocToBeRemoved = new ArrayList<Association>();
                for (EObject ref : EObjectExt.getReferencers((EObject)((Class)notifier), (EReference)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE)) {
                    if (!(ref instanceof Property)) continue;
                    for (EObject assoc : EObjectExt.getReferencers((EObject)ref, (EReference)InformationPackage.Literals.ASSOCIATION__NAVIGABLE_MEMBERS)) {
                        if (!(assoc instanceof Association) || assocToBeRemoved.contains(assoc)) continue;
                        assocToBeRemoved.add((Association)assoc);
                    }
                }
                this.executeCommand((EObject)((Class)notifier), (ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        CapellaModelDataListenerForDatas.this.removeAssociations((Class)notifier, assocToBeRemoved);
                    }
                });
            }
        }
    }

    protected void removeAssociations(Class cls, List<Association> associations) {
        for (Association association : associations) {
            for (Property property : association.getNavigableMembers()) {
                property.setAggregationKind(AggregationKind.COMPOSITION);
            }
            this.removeProperties(cls, new ArrayList<Property>((Collection<Property>)association.getOwnedMembers()));
            this.traceDeletion((NamedElement)cls, (NamedElement)association);
            association.destroy();
        }
    }

    protected void removeProperties(Class cls, List<Property> properties) {
        for (Property property : properties) {
            this.traceDeletion((NamedElement)cls, (NamedElement)property);
            property.destroy();
        }
    }

    private void traceDeletion(NamedElement element1, NamedElement element2) {
        String loggedMsg = MessageFormat.format(DELETION_MSG, element1.getName(), element2.getName(), element2.eClass().getName());
        this._logger.info((Object)new EmbeddedMessage(loggedMsg, "Model Management", (Object)element1));
    }
}

