/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CapellaResourceHelper {
    public static List<IFile> getFiles(IProject project) {
        return CapellaResourceHelper.getFiles(project, "*");
    }

    public static List<IFile> getFiles(IProject project, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(CapellaResourceHelper.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<IFile> getFiles(IFolder folder) {
        return CapellaResourceHelper.getFiles(folder, "*");
    }

    public static List<IFile> getFiles(IFolder folder, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(CapellaResourceHelper.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        try {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEditorPart editorPart = activeWorkbenchWindow != null ? activeWorkbenchWindow.getActivePage().getActiveEditor() : null;
            IFile editedFile = editorPart != null ? ((FileEditorInput)editorPart.getEditorInput()).getFile() : null;
            return editedFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

