/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.SourceLocation;
import org.eclipse.pde.internal.core.SourceLocationKey;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleManifestSourceLocationManager {
    private Map<SourceLocationKey, IPluginModelBase> fPluginToSourceBundle = Map.of();
    private Map<SourceLocationKey, TargetBundle> fPluginToTargetBundle = Map.of();

    public SourceLocation getSourceLocation(String pluginName, Version pluginVersion) {
        return this.locationOf(new SourceLocationKey(pluginName, pluginVersion)).orElse(null);
    }

    private Optional<SourceLocation> locationOf(SourceLocationKey key) {
        return this.pluginModel(key).or(() -> this.targetBundle(key));
    }

    private Optional<SourceLocation> targetBundle(SourceLocationKey key) {
        URI location;
        BundleInfo bundleInfo;
        TargetBundle targetBundle = this.fPluginToTargetBundle.get(key);
        if (targetBundle != null && (bundleInfo = targetBundle.getBundleInfo()) != null && (location = bundleInfo.getLocation()) != null) {
            try {
                File file = new File(location);
                SourceLocation sourceLocation = new SourceLocation((IPath)new Path(file.getAbsolutePath()));
                sourceLocation.setUserDefined(false);
                return Optional.of(sourceLocation);
            }
            catch (RuntimeException runtimeException) {}
        }
        return Optional.empty();
    }

    private Optional<SourceLocation> pluginModel(SourceLocationKey key) {
        String path;
        IPluginModelBase plugin = this.fPluginToSourceBundle.get(key);
        if (plugin != null && (path = plugin.getInstallLocation()) != null) {
            SourceLocation location = new SourceLocation((IPath)new Path(path));
            location.setUserDefined(false);
            return Optional.of(location);
        }
        return Optional.empty();
    }

    public Collection<SourceLocation> getSourceLocations() {
        return Stream.concat(this.fPluginToSourceBundle.keySet().stream(), this.fPluginToTargetBundle.keySet().stream()).distinct().flatMap(key -> this.locationOf((SourceLocationKey)key).stream()).collect(Collectors.toList());
    }

    public boolean hasValidSourceLocation(String pluginName, Version pluginVersion) {
        return this.getSourceLocation(pluginName, pluginVersion) != null;
    }

    public Set<String> getSourceRoots(String pluginName, Version pluginVersion) {
        HashSet<String> pluginSourceRoots = new HashSet<String>();
        ManifestElement[] manifestElements = this.getSourceEntries(pluginName, pluginVersion);
        if (manifestElements != null) {
            ManifestElement[] manifestElementArray = manifestElements;
            int n = manifestElements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement currentElement = manifestElementArray[n2];
                String binaryPluginName = currentElement.getValue();
                String versionEntry = currentElement.getAttribute("version");
                if (binaryPluginName != null && binaryPluginName.equals(pluginName) && versionEntry != null && versionEntry.length() > 0) {
                    Version version = null;
                    try {
                        version = new Version(versionEntry);
                    }
                    catch (IllegalArgumentException e) {
                        PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.SourceLocationManager_problemProcessingBundleManifestSourceHeader, (Object)pluginName, (Object)pluginVersion), (Throwable)e));
                    }
                    if (pluginVersion.equals((Object)version)) {
                        this.addSourceRoots(currentElement.getDirective("roots"), pluginSourceRoots);
                        return pluginSourceRoots;
                    }
                }
                ++n2;
            }
        }
        return pluginSourceRoots;
    }

    public Set<String> getAllSourceRoots(String pluginName, Version pluginVersion) {
        HashSet<String> pluginSourceRoots = new HashSet<String>();
        ManifestElement[] manifestElements = this.getSourceEntries(pluginName, pluginVersion);
        if (manifestElements != null) {
            ManifestElement[] manifestElementArray = manifestElements;
            int n = manifestElements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement currentElement = manifestElementArray[n2];
                this.addSourceRoots(currentElement.getDirective("roots"), pluginSourceRoots);
                ++n2;
            }
        }
        return pluginSourceRoots;
    }

    private ManifestElement[] getSourceEntries(String pluginName, Version pluginVersion) {
        String bundleSourceEntry;
        IPluginModelBase sourceBundle = this.fPluginToSourceBundle.get(new SourceLocationKey(pluginName, pluginVersion));
        if (sourceBundle != null && sourceBundle.getPluginBase() instanceof PluginBase && (bundleSourceEntry = ((PluginBase)sourceBundle.getPluginBase()).getBundleSourceEntry()) != null) {
            try {
                return ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)bundleSourceEntry);
            }
            catch (BundleException e) {
                PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.SourceLocationManager_problemProcessingBundleManifestSourceHeader, (Object)pluginName, (Object)pluginVersion), (Throwable)e));
            }
        }
        return null;
    }

    private void addSourceRoots(String rootEntryDirective, Set<String> pluginSourceRoots) {
        if (rootEntryDirective != null) {
            String[] roots = rootEntryDirective.split(",");
            Collections.addAll(pluginSourceRoots, roots);
        } else {
            pluginSourceRoots.add(".");
        }
    }

    public void setPlugins(IPluginModelBase[] externalModels) {
        this.fPluginToSourceBundle = new LinkedHashMap<SourceLocationKey, IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = externalModels;
        int n = externalModels.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleSourceEntry;
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IPluginBase currentPlugin = model.getPluginBase();
            if (currentPlugin instanceof PluginBase && (bundleSourceEntry = ((PluginBase)currentPlugin).getBundleSourceEntry()) != null) {
                Path path;
                ManifestElement[] manifestElements = null;
                try {
                    manifestElements = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)bundleSourceEntry);
                }
                catch (BundleException e) {
                    PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.SourceLocationManager_problemProcessingBundleManifestSourceHeader, (Object)currentPlugin.getId(), (Object)currentPlugin.getVersion()), (Throwable)e));
                }
                if (manifestElements != null && (path = new Path(model.getInstallLocation())).toFile().exists()) {
                    ManifestElement[] manifestElementArray = manifestElements;
                    int n3 = manifestElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ManifestElement element = manifestElementArray[n4];
                        String binaryPluginName = element.getValue();
                        String versionEntry = element.getAttribute("version");
                        if (binaryPluginName != null && binaryPluginName.length() > 0 && versionEntry != null && versionEntry.length() > 0) {
                            Version version = null;
                            try {
                                version = new Version(versionEntry);
                            }
                            catch (IllegalArgumentException e) {
                                PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.SourceLocationManager_problemProcessingBundleManifestSourceHeader, (Object[])new Object[]{currentPlugin.getName(), versionEntry, path.toString()}), (Throwable)e));
                            }
                            this.fPluginToSourceBundle.put(new SourceLocationKey(binaryPluginName, version), model);
                        } else {
                            PDECore.log(Status.warning((String)NLS.bind((String)PDECoreMessages.BundleManifestSourceLocationManager_problemProcessBundleManifestHeaderAttributeMissing, (Object)currentPlugin.getName())));
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public void setTargetBundles(TargetBundle[] bundles) {
        this.fPluginToTargetBundle = new LinkedHashMap<SourceLocationKey, TargetBundle>();
        TargetBundle[] targetBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo sourceTarget;
            TargetBundle bundle = targetBundleArray[n2];
            if (bundle.isSourceBundle() && (sourceTarget = bundle.getSourceTarget()) != null) {
                try {
                    Version version = Version.parseVersion((String)sourceTarget.getVersion());
                    this.fPluginToTargetBundle.put(new SourceLocationKey(sourceTarget.getSymbolicName(), version), bundle);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
    }
}

