/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.operations;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyObjects;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverrideCopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ResourceInfoProcessor;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SavingEMFResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;
import org.polarsys.capella.core.platform.sirius.clipboard.operations.CapellaSavingEMFResource;

public class CapellaOverrideCopyOperation
extends OverrideCopyOperation {
    private static final int KILOBYTE = 1024;
    private static final int BUFFER_SIZE = 131072;
    private static final URI COPY_URI = URI.createFileURI((String)"");

    public CapellaOverrideCopyOperation(CopyOperation overriddenCopyOperation) {
        super(overriddenCopyOperation);
    }

    public String copy() throws Exception {
        return this.doCopy();
    }

    protected String doCopy() throws Exception {
        CopyObjects copyObjects = this.getAuxiliaryObjects();
        if (this.isCancelled()) {
            this.throwCancelEx();
        }
        return this.saveCopyObjects(copyObjects, COPY_URI, "UTF-8", SerializationEMFResource.SAVE_OPTIONS, this.getEObjectsHintMap());
    }

    private String saveCopyObjects(CopyObjects copyObjects, URI uri, String encoding, Map saveOptions, Map hints) throws Exception {
        CapellaSavingEMFResource res = null;
        try {
            try {
                res = new CapellaSavingEMFResource(uri, encoding, saveOptions, this.getCopyParentsCopier().getCopy2ObjectMap(), copyObjects, this.getClipboardOperationHelper());
            }
            catch (Exception ex) {
                this.throwUncopyableEx();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(131072);
            if (res != null) {
                res.save(out, null);
            }
            String dataStr = out.toString(encoding);
            String infoStr = ResourceInfoProcessor.getResourceInfo((int)dataStr.length(), (String)encoding, (SavingEMFResource)res, (Map)hints, (CopyObjects)copyObjects);
            String string = dataStr + infoStr;
            return string;
        }
        finally {
            if (res != null) {
                res.unload();
            }
        }
    }

    private void throwCancelEx() {
        this.throwCancelException("copy");
    }

    private void throwUncopyableEx() {
        this.throwException("copy", new IllegalArgumentException("Uncopyable Object"));
    }
}

