/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.commandline.doc.Activator;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.Messages;
import org.polarsys.capella.core.commandline.core.WorkbenchHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultCommandLine
extends AbstractCommandLine {
    public static String ALL_ARGUMENT = "/all";

    public DefaultCommandLine() {
        this.argHelper = CommandLineArgumentHelper.getInstance();
        this.logger = ReportManagerRegistry.getInstance().subscribe("Default");
    }

    @Override
    public void prepare(IApplicationContext context) throws CommandLineException {
        this.importProjects();
        this.getOrCreateOutputFolder();
    }

    protected void importProjects() throws CommandLineException {
        String projectsToImport = this.argHelper.getImportProjects();
        if (projectsToImport != null) {
            try {
                this.importProjects(this.toList(projectsToImport));
            }
            catch (CoreException exception) {
                throw new CommandLineException(exception.getMessage());
            }
        }
    }

    @Override
    public void postExecute(IApplicationContext context) throws CommandLineException {
        this.exportZips();
    }

    protected void exportZips() throws CommandLineException {
        String projectsToExportZip = this.argHelper.getExportZips();
        if (projectsToExportZip != null) {
            if (projectsToExportZip.equals(ALL_ARGUMENT)) {
                this.exportProjectZips(Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(CapellaResourceHelper::isCapellaProject).map(iProject -> iProject.getName()).collect(Collectors.toList()));
            } else {
                this.exportProjectZips(this.toList(projectsToExportZip));
            }
        }
    }

    protected void exportProjectZips(List<String> projectsToExportZip) throws CommandLineException {
        IFolder outputFolder = this.getOrCreateOutputFolder();
        if (outputFolder == null) {
            this.logger.error((Object)Messages.export_zip_no_ouputfolder);
        } else {
            IProject[] iProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            for (String project : projectsToExportZip) {
                Optional<IProject> anyIProject = Arrays.stream(iProjects).filter(iProject -> iProject.getName().equals(project)).findAny();
                if (!anyIProject.isPresent()) {
                    this.logger.error((Object)(Messages.export_zip_not_found + project));
                    continue;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile file = outputFolder.getFile(project + ".zip");
                IProject newProject = workspace.getRoot().getProject(project);
                WorkbenchHelper.exportZipFile((IResource)newProject, file);
            }
        }
    }

    protected void checkProject(IProject project) throws CommandLineException {
        if (!project.exists()) {
            this.logError(Messages.project + project.getName() + Messages.not_exist);
        } else {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                this.logError(Messages.unable_open_project + project.getName());
            }
            List<IFile> capellaResources = this.getCapellaResourceFiles(project);
            for (IFile capellaResource : capellaResources) {
                this.compliancyCheck(capellaResource);
            }
        }
    }

    protected void checkInputs() throws CommandLineException {
        if (this.argHelper.getInputs() == null) {
            this.logger.error((Object)Messages.inputs_mandatory);
        } else if (this.argHelper.getInputs().equals(ALL_ARGUMENT)) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.checkProject(project);
                ++n2;
            }
        } else {
            List<String> inputs = this.toList(this.argHelper.getInputs());
            for (String input : inputs) {
                if (input.endsWith("aird")) {
                    this.checkInputAirdFile(input);
                    continue;
                }
                this.checkInputProject(input);
            }
        }
    }

    protected void checkInputProject(String projectPath) throws CommandLineException {
        String projectName = this.getProjectNameFromPath(projectPath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.checkProject(project);
    }

    protected void checkInputAirdFile(String airdPath) throws CommandLineException {
        String projectName = this.getProjectNameFromPath(airdPath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.checkProject(project);
        IFile file = project.getFile(DefaultCommandLine.getRelativeFilePath(airdPath));
        if (!file.exists()) {
            String message = Messages.aird + airdPath + Messages.not_exist;
            this.logError(message);
            throw new CommandLineException(message);
        }
    }

    protected IFolder getOrCreateOutputFolder() throws CommandLineException {
        String outputFolder = this.argHelper.getOutputFolder();
        IFolder folder = null;
        if (outputFolder != null) {
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(outputFolder));
            try {
                IProject project = folder.getProject();
                if (!project.exists()) {
                    project.create((IProgressMonitor)new NullProgressMonitor());
                }
                if (!project.isOpen()) {
                    project.open((IProgressMonitor)new NullProgressMonitor());
                }
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException exception) {
                StringBuilder message = new StringBuilder(Messages.cannot_create_folder);
                this.logger.error((Object)message.toString(), (Throwable)exception);
                throw new CommandLineException(message.toString());
            }
        }
        return folder;
    }

    @Override
    public void printHelp() {
        this.printHelp(Collections.emptyList());
    }

    protected void printHelp(List<String> hiddenArguments) {
        System.out.println("*** Applicable arguments for command line***");
        this.printArgumentsFromTable("commonParameters", true, hiddenArguments);
    }

    protected void printArgumentsFromTable(String tableId, boolean printTitle, List<String> hiddenArguments) {
        Bundle bundle = FrameworkUtil.getBundle(Activator.class);
        URL fileURL = bundle.getEntry("html/19. Command Line Support/19.1. Core Mechanism and Applications.html");
        try {
            URL resolvedUrl = FileLocator.toFileURL((URL)fileURL);
            java.net.URI resolvedUri = new java.net.URI(resolvedUrl.getProtocol(), resolvedUrl.getPath(), null);
            File docFile = new File(resolvedUri);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            FileInputStream fis = new FileInputStream(docFile);
            Document doc = docBuilder.parse(fis);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression commonParametersTableExpr = xpath.compile("/html/body/table[@id='" + tableId + "']");
            Node tableNode = (Node)commonParametersTableExpr.evaluate(doc, XPathConstants.NODE);
            XPathExpression rowExpr = xpath.compile("tr");
            NodeList rowNodeList = (NodeList)rowExpr.evaluate(tableNode, XPathConstants.NODESET);
            if (printTitle) {
                Node titleNode = rowNodeList.item(0);
                XPathExpression thExpr = xpath.compile("th");
                NodeList thNodeList = (NodeList)thExpr.evaluate(titleNode, XPathConstants.NODESET);
                System.out.printf("%-30s%-15s%s", thNodeList.item(0).getTextContent(), thNodeList.item(1).getTextContent(), thNodeList.item(2).getTextContent());
                System.out.println();
            }
            int i = 1;
            while (i < rowNodeList.getLength()) {
                Node trNode = rowNodeList.item(i);
                XPathExpression tdExpr = xpath.compile("td");
                NodeList tdNodeList = (NodeList)tdExpr.evaluate(trNode, XPathConstants.NODESET);
                ArrayList<String> tds = new ArrayList<String>();
                int j = 0;
                while (j < tdNodeList.getLength()) {
                    Node tdNode = tdNodeList.item(j);
                    tds.add(tdNode.getTextContent());
                    ++j;
                }
                if (!tds.isEmpty() && !hiddenArguments.contains(tds.get(0))) {
                    System.out.printf("%-30s%-15s%s", tds.get(0), tds.get(1), tds.get(2));
                    System.out.println();
                }
                ++i;
            }
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            this.logger.error((Object)e.toString());
        }
    }

    protected String getProjectNameFromPath(String path) {
        URI fileURI = URI.createFileURI((String)path);
        return URI.decode((String)fileURI.segment(0));
    }

    protected List<IFile> getAirdFiles(String path) {
        if (path.endsWith("aird")) {
            return Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)));
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFromPath(path));
        if (project.exists()) {
            try {
                return Arrays.stream(project.members()).filter(IFile.class::isInstance).map(IFile.class::cast).filter(file -> file.getFileExtension().equals("aird")).collect(Collectors.toList());
            }
            catch (CoreException e) {
                this.logError(Messages.aird_not_found + project.getName());
            }
        }
        return Collections.emptyList();
    }

    protected List<IFile> getAirdFilesFromInput() {
        String inputs = this.argHelper.getInputs();
        ArrayList<IFile> airdFiles = new ArrayList<IFile>();
        if (inputs == null) {
            return Collections.emptyList();
        }
        if (inputs.equals(ALL_ARGUMENT)) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                airdFiles.addAll(this.getAirdFiles(p.getName()));
                ++n2;
            }
        } else {
            for (String inputPath : this.toList(inputs)) {
                airdFiles.addAll(this.getAirdFiles(inputPath));
            }
        }
        return airdFiles;
    }

    protected Set<IProject> getProjectsFromInput() {
        String inputs = this.argHelper.getInputs();
        if (inputs == null) {
            return Collections.emptySet();
        }
        if (inputs.equals(ALL_ARGUMENT)) {
            return new HashSet<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        for (String inputPath : this.toList(inputs)) {
            projects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFromPath(inputPath)));
        }
        return projects;
    }

    @Override
    public void checkArgs(IApplicationContext context) throws CommandLineException {
        this.checkInputs();
    }

    protected IFolder getOrCreateOutputFolderForAird(URI airdURI) {
        IFolder airdFolder = null;
        String airdName = URI.decode((String)airdURI.lastSegment());
        String projectName = URI.decode((String)airdURI.segment(airdURI.segmentCount() - 2));
        try {
            IFolder outputFolder = this.getOrCreateOutputFolder();
            if (outputFolder.exists()) {
                IFolder projectFolder = outputFolder.getFolder(projectName);
                if (!projectFolder.exists()) {
                    projectFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!(airdFolder = projectFolder.getFolder(airdName)).exists()) {
                    airdFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException | CommandLineException e) {
            this.logger.error((Object)Messages.cannot_create_folder);
        }
        return airdFolder;
    }
}

