/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datatype.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.properties.Messages;
import org.polarsys.capella.core.data.information.datatype.properties.controllers.EnumerationController;
import org.polarsys.capella.core.data.information.datatype.properties.sections.DataTypeSection;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleEditableSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.SimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleEditableSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleSemanticField;

public class EnumerationSection
extends DataTypeSection {
    private SimpleSemanticField domainTypeWidget;
    private SimpleEditableSemanticField minValueWidget;
    private SimpleEditableSemanticField maxValueWidget;
    private SimpleEditableSemanticField defaultValueWidget;
    private SimpleEditableSemanticField nullValueWidget;

    @Override
    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.domainTypeWidget = new SimpleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("Enumeration.DomainTypeLabel"), this.getWidgetFactory(), (ISimpleSemanticFieldController)new SimpleSemanticFieldController());
        this.domainTypeWidget.setDisplayedInWizard(displayedInWizard);
        this.minValueWidget = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataType.MinValueLabel"), this.getWidgetFactory(), Messages.getString("DataType.MinValueDefaultName"), (ISimpleEditableSemanticFieldController)new EnumerationController()){

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                EnumerationSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                EnumerationSection.this.refresh();
            }
        };
        this.minValueWidget.setDisplayedInWizard(displayedInWizard);
        this.maxValueWidget = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataType.MaxValueLabel"), this.getWidgetFactory(), Messages.getString("DataType.MaxValueDefaultName"), (ISimpleEditableSemanticFieldController)new EnumerationController()){

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                EnumerationSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                EnumerationSection.this.refresh();
            }
        };
        this.maxValueWidget.setDisplayedInWizard(displayedInWizard);
        this.defaultValueWidget = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataType.DefaultValueLabel"), this.getWidgetFactory(), Messages.getString("DataType.DefaultValueDefaultName"), (ISimpleEditableSemanticFieldController)new EnumerationController()){

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                EnumerationSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                EnumerationSection.this.refresh();
            }
        };
        this.defaultValueWidget.setDisplayedInWizard(displayedInWizard);
        this.nullValueWidget = new SimpleEditableSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataType.NullValueLabel"), this.getWidgetFactory(), Messages.getString("DataType.NullValueDefaultName"), (ISimpleEditableSemanticFieldController)new EnumerationController()){

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                EnumerationSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                EnumerationSection.this.refresh();
            }
        };
        this.nullValueWidget.setDisplayedInWizard(displayedInWizard);
    }

    @Override
    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.domainTypeWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getEnumeration_DomainType());
        this.minValueWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getEnumeration_OwnedMinValue());
        this.maxValueWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getEnumeration_OwnedMaxValue());
        this.defaultValueWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getEnumeration_OwnedDefaultValue());
        this.nullValueWidget.loadData(capellaElement, (EStructuralFeature)DatatypePackage.eINSTANCE.getEnumeration_OwnedNullValue());
        this.evaluateButtonStatus((Enumeration)capellaElement);
    }

    protected void evaluateButtonStatus(Enumeration enumeration) {
        if (enumeration != null) {
            DataValue value = enumeration.getDefaultValue();
            if (value == null) {
                this.defaultValueWidget.enableEditButton(false);
            } else {
                this.defaultValueWidget.enableEditButton(true);
            }
            value = enumeration.getNullValue();
            if (value == null) {
                this.nullValueWidget.enableEditButton(false);
            } else {
                this.nullValueWidget.enableEditButton(true);
            }
            value = enumeration.getOwnedMinValue();
            if (value == null) {
                this.minValueWidget.enableEditButton(false);
            } else {
                this.minValueWidget.enableEditButton(true);
            }
            value = enumeration.getOwnedMaxValue();
            if (value == null) {
                this.maxValueWidget.enableEditButton(false);
            } else {
                this.maxValueWidget.enableEditButton(true);
            }
        }
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == DatatypePackage.eINSTANCE.getEnumeration();
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.domainTypeWidget);
        fields.add((AbstractSemanticField)this.minValueWidget);
        fields.add((AbstractSemanticField)this.maxValueWidget);
        fields.add((AbstractSemanticField)this.defaultValueWidget);
        fields.add((AbstractSemanticField)this.nullValueWidget);
        return fields;
    }
}

