/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;

public class QuickFiltersMenu
extends MenuManager {
    CapellaCommonNavigator navigator;
    INavigatorFilterService capellaNavigatorFilterService;
    Action selectAllAction;
    Action deselectAllAction;
    Action selectDefaultAction;

    public QuickFiltersMenu(CapellaCommonNavigator navigator) {
        super(Messages.QuickFiltersMenu_Title);
        this.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("QuickFiltersMenu.png"));
        this.navigator = navigator;
        INavigatorContentService capellaNavigatorContentService = navigator.getNavigatorContentService();
        this.capellaNavigatorFilterService = capellaNavigatorContentService.getFilterService();
        this.addActions();
    }

    private void addActions() {
        this.selectAllAction = new Action(Messages.QuickFiltersMenu_SelectAll_Title){

            public void run() {
                ICommonFilterDescriptor[] visibleFilterDescriptors = QuickFiltersMenu.this.capellaNavigatorFilterService.getVisibleFilterDescriptors();
                String[] filterIDsToActivate = new String[visibleFilterDescriptors.length];
                int i = 0;
                while (i < visibleFilterDescriptors.length) {
                    filterIDsToActivate[i] = visibleFilterDescriptors[i].getId();
                    ++i;
                }
                QuickFiltersMenu.this.capellaNavigatorFilterService.activateFilterIdsAndUpdateViewer(filterIDsToActivate);
            }
        };
        this.add((IAction)this.selectAllAction);
        this.deselectAllAction = new Action(Messages.QuickFiltersMenu_DeselectAll_Title){

            public void run() {
                QuickFiltersMenu.this.capellaNavigatorFilterService.activateFilterIdsAndUpdateViewer(new String[0]);
            }
        };
        this.add((IAction)this.deselectAllAction);
        this.selectDefaultAction = new Action(Messages.QuickFiltersMenu_SelectDefault_Title){

            public void run() {
                ICommonFilterDescriptor[] visibleFilterDescriptors = QuickFiltersMenu.this.capellaNavigatorFilterService.getVisibleFilterDescriptors();
                ArrayList<String> defaultFilterIds = new ArrayList<String>();
                int i = 0;
                while (i < visibleFilterDescriptors.length) {
                    if (visibleFilterDescriptors[i].isActiveByDefault()) {
                        defaultFilterIds.add(visibleFilterDescriptors[i].getId());
                    }
                    ++i;
                }
                QuickFiltersMenu.this.capellaNavigatorFilterService.activateFilterIdsAndUpdateViewer(defaultFilterIds.toArray(new String[0]));
            }
        };
        this.add((IAction)this.selectDefaultAction);
    }
}

