/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.platform.sirius.ted.DataNotifier;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.datavalue.ValuePart;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;

public class NavigatorModelDataListener
extends CapellaModelDataListener {
    private static List<EStructuralFeature> __monitoredReferencesForAdditionalNotifications;
    private INotifyChangedListener _callback;

    public NavigatorModelDataListener(INotifyChangedListener callback) {
        this._callback = callback;
        this.initializeMonitoredReferences();
    }

    public void notifyChanged(Notification notification) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (__monitoredReferencesForAdditionalNotifications.contains(feature)) {
            this._callback.notifyChanged(notification);
        }
    }

    private void initializeMonitoredReferences() {
        if (__monitoredReferencesForAdditionalNotifications == null) {
            __monitoredReferencesForAdditionalNotifications = new ArrayList<EStructuralFeature>(11);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.NUMERIC_REFERENCE__REFERENCED_VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.NUMERIC_REFERENCE__REFERENCED_PROPERTY);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.BOOLEAN_REFERENCE__REFERENCED_VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.BOOLEAN_REFERENCE__REFERENCED_PROPERTY);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.STRING_REFERENCE__REFERENCED_VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.STRING_REFERENCE__REFERENCED_PROPERTY);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.ENUMERATION_REFERENCE__REFERENCED_VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.ENUMERATION_REFERENCE__REFERENCED_PROPERTY);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.VALUE_PART__REFERENCED_PROPERTY);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.LITERAL_BOOLEAN_VALUE__VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.LITERAL_NUMERIC_VALUE__VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)DatavaluePackage.Literals.LITERAL_STRING_VALUE__VALUE);
            __monitoredReferencesForAdditionalNotifications.add((EStructuralFeature)ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET);
        }
    }

    protected void registerToDataNotifier(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        DataNotifier dataNotifier;
        if (editingDomain != null && (dataNotifier = editingDomain.getDataNotifier()) != null) {
            dataNotifier.addAdapter(AbstractNamedElement.class, (Adapter)this);
            dataNotifier.addAdapter(AbstractTypedElement.class, (Adapter)this);
            dataNotifier.addAdapter(NumericReference.class, (Adapter)this);
            dataNotifier.addAdapter(BooleanReference.class, (Adapter)this);
            dataNotifier.addAdapter(StringReference.class, (Adapter)this);
            dataNotifier.addAdapter(EnumerationReference.class, (Adapter)this);
            dataNotifier.addAdapter(ValuePart.class, (Adapter)this);
            dataNotifier.addAdapter(LiteralBooleanValue.class, (Adapter)this);
            dataNotifier.addAdapter(LiteralNumericValue.class, (Adapter)this);
            dataNotifier.addAdapter(LiteralStringValue.class, (Adapter)this);
            dataNotifier.addAdapter(DRepresentationDescriptor.class, (Adapter)this);
        }
    }

    protected void unregisterFromDataNotifier(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        DataNotifier dataNotifier;
        if (editingDomain != null && (dataNotifier = editingDomain.getDataNotifier()) != null) {
            dataNotifier.remove((Adapter)this);
        }
    }
}

