/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.mdsofa.common.helper;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ProjectHelper {
    private static final Logger __logger = Logger.getLogger((String)ProjectHelper.class.getPackage().getName());
    protected static final String CLASS_PATH_ENTRY_REQUIRED_PLUGINS_PATH_ID = "requiredPlugins";

    public static IProject getProject(String projectName_p) {
        IProject result = null;
        if (projectName_p == null) {
            return result;
        }
        IPluginModelBase modelBase = PluginRegistry.findModel((String)projectName_p);
        if (modelBase == null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName_p);
        }
        result = ProjectHelper.getProject(modelBase);
        return result;
    }

    public static IProject getProject(IPluginModelBase pluginModelBase_p) {
        IResource underlyingResource;
        IProject result = null;
        if (pluginModelBase_p != null && (underlyingResource = pluginModelBase_p.getUnderlyingResource()) != null) {
            result = underlyingResource.getProject();
        }
        return result;
    }

    public static boolean canBeConvertedToFC(String elementId_p) {
        boolean result = false;
        IProject project = ProjectHelper.getProject(elementId_p);
        if (project == null) {
            StringBuilder loggerMessage = new StringBuilder("ProjectHelper.canBeConvertedToFC(..) _ ");
            loggerMessage.append("Unable to locate a project with element id ").append(elementId_p);
            __logger.error((Object)loggerMessage.toString());
        } else {
            IPluginModelBase model = PluginRegistry.findModel((IProject)project);
            if (model != null) {
                String modelId = model.getPluginBase().getId();
                result = project.getName().equals(modelId);
                if (!result) {
                    StringBuilder loggerMessage = new StringBuilder("ProjectHelper.canBeConvertedToFC(..) _ ");
                    loggerMessage.append("To convert an exisiting plug-in into a FC, its related project name must be equal to the plug-in id.");
                    __logger.error((Object)loggerMessage.toString());
                }
            } else {
                StringBuilder loggerMessage = new StringBuilder("ProjectHelper.canBeConvertedToFC(..) _ ");
                loggerMessage.append("Element ").append(elementId_p).append(" is not a valid plug-in project.");
                loggerMessage.append("Only plug-in projects can be converted to FCs.");
                __logger.error((Object)loggerMessage.toString());
            }
        }
        return result;
    }

    public static IJavaProject getJavaProject(String projectName_p) {
        return ProjectHelper.getJavaProject(ProjectHelper.getProject(projectName_p));
    }

    public static IJavaProject getJavaProject(IProject project_p) {
        IJavaProject result = null;
        if (project_p == null) {
            return result;
        }
        IJavaElement javaElement = (IJavaElement)project_p.getAdapter(IJavaElement.class);
        if (javaElement == null) {
            javaElement = JavaCore.create((IProject)project_p);
        }
        result = javaElement.getJavaProject();
        return result;
    }

    public static ClassLoader getClassLoaderFor(IJavaProject javaProject_p, ClassLoader parentClassLoader_p) throws Exception {
        URLClassLoader result = null;
        if (javaProject_p == null || parentClassLoader_p == null) {
            return result;
        }
        URL[] classPathEntries = ProjectHelper.getProjectDependencies(javaProject_p);
        if (classPathEntries.length == 0) {
            return result;
        }
        result = new URLClassLoader(classPathEntries, parentClassLoader_p);
        return result;
    }

    protected static URL[] getProjectDependencies(IJavaProject javaProject_p) throws Exception {
        IClasspathEntry[] classpathEntries = javaProject_p.getResolvedClasspath(true);
        ArrayList<URL> classpathUrls = new ArrayList<URL>(classpathEntries.length);
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            IPath urlPath = classpathEntry.getPath();
            switch (classpathEntry.getEntryKind()) {
                case 2: 
                case 3: {
                    IJavaProject localProject = ProjectHelper.getJavaProject(urlPath.segment(0));
                    urlPath = localProject.getProject().getLocation().append(localProject.getOutputLocation().removeFirstSegments(1));
                    break;
                }
            }
            classpathUrls.add(urlPath.toFile().toURI().toURL());
            ++n2;
        }
        return classpathUrls.toArray(new URL[classpathUrls.size()]);
    }

    public static void refreshProject(IProject project_p, IProgressMonitor monitor_p) {
        ProjectHelper.refreshProject(project_p, 2, monitor_p);
    }

    public static void refreshProject(IProject projectToRefresh_p, int depth_p, IProgressMonitor monitor_p) {
        try {
            projectToRefresh_p.refreshLocal(depth_p, monitor_p);
        }
        catch (CoreException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("ProjectHelper.refreshProject(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    public static boolean createSourceFolder(String sourceFolderName_p, IProject project_p, IProgressMonitor monitor_p) {
        boolean successful = false;
        if (sourceFolderName_p == null || project_p == null || monitor_p == null) {
            return successful;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project_p);
            IClasspathEntry[] sourceEntries = javaProject.getRawClasspath();
            IPath generatedSourceFolderPath = project_p.getFullPath().append(sourceFolderName_p);
            ProjectHelper.createFolder(sourceFolderName_p, project_p, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
            IClasspathEntry generatedSourceEntry = JavaCore.newSourceEntry((IPath)generatedSourceFolderPath);
            IClasspathEntry[] newEntries = new IClasspathEntry[sourceEntries.length + 1];
            newEntries[0] = sourceEntries[0];
            newEntries[1] = generatedSourceEntry;
            System.arraycopy(sourceEntries, 1, newEntries, 2, sourceEntries.length - 1);
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
            successful = true;
        }
        catch (Exception exception_p) {
            successful = false;
            StringBuilder loggerMessage = new StringBuilder("ProjectHelper.createSourceFolder(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return successful;
    }

    public static IFolder createFolder(String folderName_p, IProject project_p, IProgressMonitor monitor_p) {
        IFolder folder = project_p.getFolder(folderName_p);
        if (!folder.exists()) {
            Path parentPath = new Path(folderName_p);
            if (parentPath.segmentCount() > 1) {
                parentPath = parentPath.removeLastSegments(1);
                ProjectHelper.createFolder(parentPath.toString(), project_p, monitor_p);
            }
            try {
                folder.create(true, true, monitor_p);
            }
            catch (CoreException exception_p) {
                folder = null;
                StringBuilder loggerMessage = new StringBuilder("ProjectHelper.createFolder(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return folder;
    }

    public static enum ProjectExistenceStatus {
        ALREADY_EXISTS,
        CREATED,
        CREATION_FAILED;

    }
}

