/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.rules;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.rules.AbstractRule;
import org.polarsys.capella.core.transition.common.rules.IRuleUpdateAttribute;
import org.polarsys.capella.core.transition.common.rules.IRuleUpdateReference;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class AbstractUpdateRule
extends AbstractRule
implements IRuleUpdateAttribute,
IRuleUpdateReference {
    private List<EAttribute> updatedAttributes = new ArrayList<EAttribute>();
    private List<EReference> updatedReferences = new ArrayList<EReference>();

    @Override
    public boolean isUpdatedAttribute(EAttribute attribute) {
        return this.updatedAttributes.contains(attribute);
    }

    public List<EAttribute> getUpdatedAttributes() {
        return this.updatedAttributes;
    }

    protected void registerUpdatedAttribute(EAttribute attribute) {
        this.updatedAttributes.add(attribute);
    }

    protected void unregisterUpdatedAttribute(EAttribute attribute) {
        this.updatedAttributes.remove(attribute);
    }

    @Override
    public boolean isUpdatedReference(EReference reference) {
        return this.updatedReferences.contains(reference);
    }

    public List<EReference> getUpdatedReferences() {
        return this.updatedReferences;
    }

    protected void registerUpdatedReference(EReference reference) {
        this.updatedReferences.add(reference);
    }

    protected void unregisterUpdatedAttribute(EReference reference) {
        this.updatedReferences.remove(reference);
    }

    @Override
    protected void updateElement(EObject element, EObject result, IContext context) {
        super.updateElement(element, result, context);
        for (EObject target : this.retrieveTracedElements(element, context)) {
            for (EAttribute attribute : this.getUpdatedAttributes()) {
                AttachmentHelper.getInstance(context).updateElementAttribute(element, target, attribute, context);
            }
        }
    }
}

