/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_ComponentCycle
extends AbstractValidationRule {
    private List<Component> processedElements;

    public IStatus validate(IValidationContext ctx) {
        this.processedElements = new ArrayList<Component>();
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Component) {
            Component partitionableElement = (Component)eObj;
            IStatus status = this.processPartitions(ctx, partitionableElement, (EList<Part>)partitionableElement.getContainedParts());
            this.processedElements = null;
            return status;
        }
        return ctx.createSuccessStatus();
    }

    private IStatus processPartitions(IValidationContext ctx, Component component, EList<Part> ownedParts) {
        this.processedElements.add(component);
        for (Part part : ownedParts) {
            Type type = part.getType();
            if (!(type instanceof Component)) continue;
            Component inner = (Component)type;
            String partitionName = inner.getName();
            EList innerParts = inner.getContainedParts();
            for (Part innerPart : innerParts) {
                Type innerType = innerPart.getType();
                String innerPartitionInnerPartitionName = innerPart.getName();
                for (Component alreadySawElem : this.processedElements) {
                    if (innerType != alreadySawElem) continue;
                    String alreadySawElemName = alreadySawElem.getName();
                    return ctx.createFailureStatus(new Object[]{alreadySawElemName, partitionName, innerPartitionInnerPartitionName, NamingHelper.getTitleLabel((EObject)alreadySawElem), NamingHelper.getTitleLabel((EObject)inner), NamingHelper.getTitleLabel((EObject)innerPart)});
                }
            }
            return this.processPartitions(ctx, inner, (EList<Part>)innerParts);
        }
        return ctx.createSuccessStatus();
    }
}

