/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.component;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_ComponentHumanCheckNoSubComponents
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            Component component = null;
            String message = null;
            if (eObj instanceof Entity) {
                component = (Component)eObj;
                if (component.isActor()) {
                    message = "cannot be decomposed";
                }
            } else if (eObj instanceof Component && (component = (Component)eObj).isHuman()) {
                message = "is HUMAN and cannot be decomposed";
            }
            if (message != null && this.isDecomposed(component)) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)component), message});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isDecomposed(Component component) {
        List ownedComponents = ComponentExt.getSubDefinedComponents((Component)component);
        EList parts = component.getContainedParts();
        List packages = ComponentExt.getContainedComponentPkgs((Component)component);
        return !ownedComponents.isEmpty() || !parts.isEmpty() || !packages.isEmpty();
    }
}

