/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.validation.interface_.Messages;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ExchangeItemAllocationProtocol
extends AbstractValidationRule {
    public static boolean isSenderAllocation(IStatus status) {
        return status.getMessage().contains(Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Sender);
    }

    public static boolean isReceiverAllocation(IStatus status) {
        return status.getMessage().contains(Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Receiver);
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ExchangeItemAllocation && ((ExchangeItemAllocation)eObj).getAllocatedItem() != null) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ExchangeMechanism mechanism = ((ExchangeItemAllocation)eObj).getAllocatedItem().getExchangeMechanism();
            CommunicationLinkProtocol sendProtocol = ((ExchangeItemAllocation)eObj).getSendProtocol();
            Collection expectedSendProtocols = LinkCompatibilityDefinition.INSTANCE.getCompatibleSendProtocols((ExchangeItemAllocation)eObj);
            if (!expectedSendProtocols.contains(sendProtocol)) {
                String expected = ListExt.toString((Collection)expectedSendProtocols, (String)" || ");
                IStatus status = ctx.createFailureStatus(new Object[]{eObj, mechanism, expected, Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Sender});
                statuses.add(status);
            }
            CommunicationLinkProtocol receiveProtocol = ((ExchangeItemAllocation)eObj).getReceiveProtocol();
            Collection expectedReceiveProtocols = LinkCompatibilityDefinition.INSTANCE.getCompatibleReceiveProtocols((ExchangeItemAllocation)eObj);
            if (!expectedReceiveProtocols.contains(receiveProtocol)) {
                String expected = ListExt.toString((Collection)expectedReceiveProtocols, (String)" || ");
                IStatus status = ctx.createFailureStatus(new Object[]{eObj, mechanism, expected, Messages.ExchangeItemAllocationProtocol_CommunicationLinkProtocol_Receiver});
                statuses.add(status);
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

