/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.interface_;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class TechnicalInterfacesAreNotProvidedOrRequired
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Interface interfaze;
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Interface && !(interfaze = (Interface)eObj).isStructural()) {
            boolean errorsFound = false;
            StringBuilder b = new StringBuilder();
            EList components = interfaze.getProvidingComponents();
            if (components.size() > 0 && components.size() > 0) {
                b.append("providing components : [");
                errorsFound = true;
                b.append(this.getComponentNamesList((List<Component>)components) + "]");
            }
            if ((components = interfaze.getRequiringComponents()).size() > 0 && components.size() > 0) {
                if (errorsFound) {
                    b.append(", ");
                }
                b.append("requiring components : [");
                errorsFound = true;
                b.append(this.getComponentNamesList((List<Component>)components) + "]");
            }
            if (errorsFound) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getCapellaExplorerLabel((EObject)interfaze), b.toString()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private String getComponentNamesList(List<Component> components) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < components.size()) {
            Component component = components.get(i);
            b.append(CapellaElementExt.getCapellaExplorerLabel((EObject)component));
            if (i < components.size() - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }
}

