/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.tracemodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.capra.core.adapters.AbstractTraceabilityInformationModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.ConnectionQuery;
import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.listeners.ITraceCreationListener;
import org.eclipse.capra.generic.tracemodel.GenericTraceModel;
import org.eclipse.capra.generic.tracemodel.RelatedTo;
import org.eclipse.capra.generic.tracemodel.TracemodelFactory;
import org.eclipse.capra.generic.tracemodel.TracemodelPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class GenericTraceabilityInformationModelAdapter
extends AbstractTraceabilityInformationModelAdapter
implements ITraceabilityInformationModelAdapter {
    private static final int DEFAULT_INITIAL_TRANSITIVITY_DEPTH = 1;

    public EObject createModel() {
        return TracemodelFactory.eINSTANCE.createGenericTraceModel();
    }

    public Collection<EClass> getAvailableTraceTypes(List<EObject> selection) {
        ArrayList<EClass> traceTypes = new ArrayList<EClass>();
        if (selection.size() > 1) {
            traceTypes.add(TracemodelPackage.eINSTANCE.getRelatedTo());
        }
        return traceTypes;
    }

    public EObject createTrace(EClass traceType, EObject traceModel, List<EObject> origins, List<EObject> targets) {
        final GenericTraceModel tm = (GenericTraceModel)traceModel;
        EObject trace = TracemodelFactory.eINSTANCE.create(traceType);
        final RelatedTo relatedToTrace = (RelatedTo)trace;
        relatedToTrace.setOrigin(origins.get(0));
        relatedToTrace.getTargets().addAll(targets);
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        StringBuilder name = new StringBuilder();
        name.append(((IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)origins.get(0))).orElseThrow()).withCastedHandler(artifactHelper.unwrapWrapper((Object)origins.get(0)), (h, e) -> h.getDisplayName(e)).orElseGet(origins.get(0)::toString));
        name.append(" -->");
        for (EObject obj : targets) {
            name.append(" ").append(((IArtifactHandler)artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)obj)).orElseThrow()).withCastedHandler(artifactHelper.unwrapWrapper((Object)obj), (h, e) -> h.getDisplayName(e)).orElseGet(obj::toString)).append(";");
        }
        relatedToTrace.setName(name.toString().substring(0, name.toString().length() - 1));
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Add trace"){

            protected void doExecute() {
                tm.getTraces().add((Object)relatedToTrace);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e2) {
            throw new IllegalStateException("Adding a trace link was rolled back.", e2);
        }
        catch (InterruptedException e3) {
            throw new IllegalStateException("Adding a trace link was interrupted.", e3);
        }
        Connection conn = new Connection(origins, targets, (EObject)relatedToTrace);
        Collection listeners = ExtensionPointHelper.getTraceCreationListeners();
        for (ITraceCreationListener creationListener : listeners) {
            creationListener.onTraceCreation(conn);
        }
        return relatedToTrace;
    }

    public boolean isThereATraceBetween(EObject firstElement, EObject secondElement, EObject traceModel) {
        return this.isThereATraceBetween(firstElement, secondElement, traceModel, false);
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel) {
        return this.getConnectedElements(element, tracemodel, new ArrayList<String>());
    }

    private List<Connection> getConnectedElements(EObject element, EObject traceModel, List<String> selectedRelationshipTypes, boolean reverseDirection) {
        GenericTraceModel root = (GenericTraceModel)traceModel;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        EList<RelatedTo> traces = root.getTraces();
        if (selectedRelationshipTypes.isEmpty() || selectedRelationshipTypes.contains(TracemodelPackage.eINSTANCE.getRelatedTo().getName())) {
            if (element instanceof RelatedTo) {
                RelatedTo trace = (RelatedTo)element;
                connections.add(new Connection(Arrays.asList(element), trace.getTargets(), (EObject)trace));
            } else {
                for (RelatedTo trace : traces) {
                    if (!reverseDirection && EcoreUtil.equals((EObject)element, (EObject)trace.getOrigin())) {
                        connections.add(new Connection(Arrays.asList(element), trace.getTargets(), (EObject)trace));
                        continue;
                    }
                    if (!reverseDirection || !EMFHelper.isElementInList(trace.getTargets(), (EObject)element)) continue;
                    connections.add(new Connection(Arrays.asList(trace.getOrigin()), Arrays.asList(element), (EObject)trace));
                }
            }
        }
        return connections;
    }

    public List<Connection> getConnectedElements(EObject element, EObject tracemodel, List<String> selectedRelationshipTypes) {
        return this.getConnectedElements(element, tracemodel, selectedRelationshipTypes, false);
    }

    public List<Connection> getAllTraceLinks(EObject traceModel) {
        GenericTraceModel model = (GenericTraceModel)traceModel;
        ArrayList<Connection> allLinks = new ArrayList<Connection>();
        for (RelatedTo trace : model.getTraces()) {
            allLinks.add(new Connection(Arrays.asList(trace.getOrigin()), trace.getTargets(), (EObject)trace));
        }
        return allLinks;
    }

    public void deleteTrace(List<Connection> toDelete, EObject traceModel) {
        final ArrayList<RelatedTo> toRemove = new ArrayList<RelatedTo>();
        final IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        final IMetadataAdapter metadataAdapter = (IMetadataAdapter)ExtensionPointHelper.getTraceMetadataAdapter().orElseThrow();
        if (traceModel instanceof GenericTraceModel) {
            final GenericTraceModel tModel = (GenericTraceModel)traceModel;
            for (Connection c : toDelete) {
                for (RelatedTo trace : tModel.getTraces()) {
                    if (!EcoreUtil.equals((EObject)trace, (EObject)c.getTlink())) continue;
                    toRemove.add(trace);
                }
            }
            TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain, "Remove traces"){

                protected void doExecute() {
                    for (Object trace : toRemove) {
                        if (trace instanceof EObject) {
                            metadataAdapter.removeMetadata((EObject)trace, persistenceAdapter.getMetadataContainer(EditingDomainHelper.getResourceSet()));
                        }
                        tModel.getTraces().remove(trace);
                    }
                }
            };
            try {
                ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Removing trace links was rolled back.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Removing trace links was interrupted.", e);
            }
            persistenceAdapter.saveModels((EObject)tModel, persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet()), persistenceAdapter.getMetadataContainer(EditingDomainHelper.getResourceSet()));
        }
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<String> traceLinkTypes, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, traceLinkTypes, 1, maximumDepth, false);
    }

    public List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getTransitivelyConnectedElements(element, traceModel, accumulator, new ArrayList<String>(), 1, maximumDepth, false);
    }

    private List<Connection> getTransitivelyConnectedElements(EObject element, EObject traceModel, List<Object> accumulator, List<String> traceLinkTypes, int currentDepth, int maximumDepth, boolean reverseDirection) {
        List<Connection> directElements = this.getConnectedElements(element, traceModel, traceLinkTypes, reverseDirection);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            List relevantElements = reverseDirection ? connection.getOrigins() : connection.getTargets();
            for (EObject e : relevantElements) {
                if (maximumDepth != 0 && currDepth > maximumDepth) continue;
                allElements.addAll(this.getTransitivelyConnectedElements(e, traceModel, accumulator, traceLinkTypes, currDepth, maximumDepth, reverseDirection));
            }
        }
        return allElements;
    }

    public boolean isThereATraceBetween(EObject origin, EObject target, EObject traceModel, boolean reverseDirection) {
        EObject secondElement;
        EObject firstElement;
        if (traceModel == null || origin == null || target == null) {
            return false;
        }
        if (!reverseDirection) {
            firstElement = origin;
            secondElement = target;
        } else {
            firstElement = target;
            secondElement = origin;
        }
        GenericTraceModel root = (GenericTraceModel)traceModel;
        ArrayList<RelatedTo> relevantLinks = new ArrayList<RelatedTo>();
        EList<RelatedTo> allTraces = root.getTraces();
        for (RelatedTo trace : allTraces) {
            if (firstElement.equals(secondElement) || !EMFHelper.hasSameUriOrIdentifier((EObject)firstElement, (EObject)trace.getOrigin()) || !EMFHelper.isElementInList(trace.getTargets(), (EObject)secondElement)) continue;
            relevantLinks.add(trace);
        }
        return !relevantLinks.isEmpty();
    }

    public List<Connection> getConnections(ConnectionQuery query) {
        if (query.isTraverseTransitiveLinks() && query.isIncludeInternalLinks()) {
            ArrayList<Object> accumulator = new ArrayList<Object>();
            return this.getInternalElementsTransitive(query.getElement(), query.getTraceModel(), accumulator, query.getSelectedRelationshipTypes(), 1, query.getTransitivityDepth(), query.isReverseDirection());
        }
        if (query.isTraverseTransitiveLinks()) {
            ArrayList<Object> accumulator = new ArrayList<Object>();
            return this.getTransitivelyConnectedElements(query.getElement(), query.getTraceModel(), accumulator, query.getSelectedRelationshipTypes(), 1, query.getTransitivityDepth(), query.isReverseDirection());
        }
        if (query.isIncludeInternalLinks()) {
            return this.getInternalElements(query.getElement(), query.getTraceModel(), query.getSelectedRelationshipTypes(), query.isTraverseTransitiveLinks(), query.getTransitivityDepth(), query.isReverseDirection());
        }
        return this.getConnectedElements(query.getElement(), query.getTraceModel(), query.getSelectedRelationshipTypes(), query.isReverseDirection());
    }

    private List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<Object> accumulator, List<String> selectedRelationshipTypes, int currentDepth, int maximumDepth, boolean reverseDirection) {
        List<Connection> directElements = this.getInternalElements(element, traceModel, selectedRelationshipTypes, true, maximumDepth, reverseDirection);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth >= maximumDepth + 2) continue;
                allElements.addAll(this.getInternalElementsTransitive(e, traceModel, accumulator, selectedRelationshipTypes, currDepth, maximumDepth, reverseDirection));
            }
        }
        return allElements;
    }

    public List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<String> traceLinkTypes, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getInternalElementsTransitive(element, traceModel, accumulator, traceLinkTypes, 0, maximumDepth, false);
    }

    public List<Connection> getInternalElements(EObject element, EObject traceModel, List<String> traceLinkTypes) {
        return this.getInternalElements(element, traceModel, traceLinkTypes, false, 0, false);
    }

    private List<Connection> getInternalElements(EObject element, EObject traceModel, List<String> traceLinkTypes, boolean traceLinksTransitive, int transitivityDepth, boolean reverseDirection) {
        Object originalObject;
        IArtifactHandler handler;
        List<Connection> relevantConnections;
        ConnectionQuery query;
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        if (traceLinksTransitive) {
            query = ConnectionQuery.of((EObject)traceModel, (EObject)element).setTraverseTransitiveLinks(true).setTransitivityDepth(transitivityDepth).setSelectedRelationshipTypes(traceLinkTypes).setReverseDirection(reverseDirection).build();
            relevantConnections = this.getConnections(query);
        } else {
            query = ConnectionQuery.of((EObject)traceModel, (EObject)element).setSelectedRelationshipTypes(traceLinkTypes).setReverseDirection(reverseDirection).build();
            relevantConnections = this.getConnections(query);
        }
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        for (Connection conn : relevantConnections) {
            allElements.add(conn);
            for (EObject o : conn.getOrigins()) {
                Object origin = artifactHelper.unwrapWrapper((Object)o);
                IArtifactHandler originHandler = (IArtifactHandler)artifactHelper.getHandler(origin).get();
                if (originHandler == null) continue;
                allElements.addAll(originHandler.getInternalLinks(o, traceLinkTypes, reverseDirection));
            }
            for (EObject o : conn.getTargets()) {
                Object originalObject2 = artifactHelper.unwrapWrapper((Object)o);
                IArtifactHandler handler2 = (IArtifactHandler)artifactHelper.getHandler(originalObject2).orElseThrow();
                if (handler2 == null) continue;
                allElements.addAll(handler2.getInternalLinks(o, traceLinkTypes, reverseDirection));
            }
        }
        if (relevantConnections.isEmpty() && (handler = (IArtifactHandler)artifactHelper.getHandler(originalObject = artifactHelper.unwrapWrapper((Object)element)).orElseThrow()) != null) {
            allElements.addAll(handler.getInternalLinks(element, traceLinkTypes, reverseDirection));
        }
        return allElements;
    }
}

