/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix.selection;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.ui.adapters.ArtifactAdapter;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixDataProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;

public class TraceabilityMatrixSelectionProvider
implements ISelectionProvider,
ILayerListener {
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private SelectionLayer selectionLayer;
    private TraceabilityMatrixDataProvider dataProvider;
    private ISelection previousSelection;

    public TraceabilityMatrixSelectionProvider(SelectionLayer selectionLayer, TraceabilityMatrixDataProvider dataProvider) {
        this.updateProvider(selectionLayer, dataProvider);
    }

    public void handleLayerEvent(ILayerEvent event) {
        ISelection selection;
        if ((event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) && (selection = this.doGetSelection(SelectionType.valueOf(event))) != null && !selection.equals(this.previousSelection)) {
            try {
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                }
            }
            finally {
                this.previousSelection = selection;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.selectionLayer.getSelectedCellPositions().length > 0) {
            return this.doGetSelection(SelectionType.CELL);
        }
        if (this.selectionLayer.getFullySelectedRowPositions().length > 0) {
            return this.doGetSelection(SelectionType.ROW);
        }
        if (this.selectionLayer.getFullySelectedColumnPositions().length > 0) {
            return this.doGetSelection(SelectionType.COLUMN);
        }
        return null;
    }

    private ISelection doGetSelection(SelectionType type) {
        switch (type) {
            case ROW: {
                EObject selectedRow = this.dataProvider.getRow(this.selectionLayer.getFullySelectedRowPositions()[0]).getArtifact();
                if (selectedRow == null) break;
                return new StructuredSelection((Object)new ArtifactAdapter(selectedRow));
            }
            case COLUMN: {
                EObject selectedColumn = this.dataProvider.getColumn(this.selectionLayer.getFullySelectedColumnPositions()[0]).getArtifact();
                if (selectedColumn == null) break;
                return new StructuredSelection((Object)new ArtifactAdapter(selectedColumn));
            }
            case CELL: {
                PositionCoordinate selectedCoordinate = this.selectionLayer.getSelectedCellPositions()[0];
                Connection selectedObject = this.dataProvider.getCellConnection(selectedCoordinate.columnPosition, selectedCoordinate.rowPosition);
                if (selectedObject == null) break;
                return new StructuredSelection((Object)selectedObject);
            }
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public PositionCoordinate getSelectedCellPosition() {
        if (this.selectionLayer.getSelectedCellPositions() != null && this.selectionLayer.getSelectedCellPositions().length > 0) {
            return this.selectionLayer.getSelectedCellPositions()[0];
        }
        return null;
    }

    public void updateProvider(SelectionLayer selectionLayer, TraceabilityMatrixDataProvider dataProvider) {
        this.selectionLayer = selectionLayer;
        this.dataProvider = dataProvider;
        this.selectionLayer.addLayerListener((ILayerListener)this);
    }

    private static enum SelectionType {
        CELL,
        ROW,
        COLUMN;


        public static SelectionType valueOf(String string) {
            return Enum.valueOf(SelectionType.class, string);
        }
    }
}

