/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.Environment;
import org.eclipse.cbi.targetplatform.model.GeneratedFeature;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.IncludeDeclaration;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.MavenDependency;
import org.eclipse.cbi.targetplatform.model.MavenLocation;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.model.Options;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformFactory;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;
import org.eclipse.cbi.targetplatform.ui.contentassist.AbstractTargetPlatformProposalProvider;
import org.eclipse.cbi.targetplatform.ui.contentassist.ReadAndDispatchProgressMonitorWrapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TargetPlatformProposalProvider
extends AbstractTargetPlatformProposalProvider {
    private static final String PROP_TYPE_CATEGORY = "org.eclipse.equinox.p2.type.category";
    private static final String PROP_TYPE_PRODUCT = "org.eclipse.equinox.p2.type.product";
    private static final String TARGET_PLATFORM__NAME_PLACEHOLDER = "Target Platform Name";
    private static final String INCLUDE_DECLARATION__URI_PLACEHOLDER = "includedFile.tpd";
    private static final String LOCATION__URI_PLACEHOLDER = "http://p2.repository.url/";
    private static final String LOCATION__ID_PLACEHOLDER = "locationID";
    private static final TargetPlatform TARGET_PLATFORM = TargetPlatformFactory.eINSTANCE.createTargetPlatform();
    private static final IncludeDeclaration INCLUDE_DECLARATION = TargetPlatformFactory.eINSTANCE.createIncludeDeclaration();
    private static final Options OPTIONS = TargetPlatformFactory.eINSTANCE.createOptions();
    private static final Environment ENVIRONMENT = TargetPlatformFactory.eINSTANCE.createEnvironment();
    private static final Location LOCATION = TargetPlatformFactory.eINSTANCE.createLocation();
    private static final IU IU = TargetPlatformFactory.eINSTANCE.createIU();
    @Inject
    private TargetPlatformGrammarAccess grammarAccess;
    @Inject
    private IExecutionEnvironmentsManager eeManager;
    @Inject
    private IProvisioningAgent provisioningAgent;
    private IQuery<IInstallableUnit> iuAssistQuery;

    @Override
    public void complete_TargetPlatform(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Keyword _targetKeyword_0;
        boolean _notEquals;
        EObject _grammarElement = context.getCurrentNode().getGrammarElement();
        boolean bl = _notEquals = !Objects.equal((Object)_grammarElement, (Object)(_targetKeyword_0 = this.grammarAccess.getTargetPlatformAccess().getTargetKeyword_0()));
        if (_notEquals) {
            String _value = this.grammarAccess.getTargetPlatformAccess().getTargetKeyword_0().getValue();
            String proposalPrefix = String.valueOf(_value) + " \"";
            String proposalText = String.valueOf(proposalPrefix) + TARGET_PLATFORM__NAME_PLACEHOLDER + "\"";
            String _lineDelimiter = context.getViewer().getTextWidget().getLineDelimiter();
            String _plus = String.valueOf(proposalText) + _lineDelimiter;
            ICompletionProposal p = this.createCompletionProposal(_plus, new StyledString(proposalText).append(" - create a new target platform", StyledString.QUALIFIER_STYLER), this.getImage((EObject)TARGET_PLATFORM), context);
            if (p instanceof ConfigurableCompletionProposal) {
                int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
                int _length = proposalPrefix.length();
                int _plus_1 = _replacementOffset + _length;
                ((ConfigurableCompletionProposal)p).setSelectionStart(_plus_1);
                ((ConfigurableCompletionProposal)p).setSelectionLength(TARGET_PLATFORM__NAME_PLACEHOLDER.length());
                ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
            }
            acceptor.accept(p);
        }
    }

    private IQuery<IInstallableUnit> getIUAssistQuery() {
        if (this.iuAssistQuery == null) {
            this.iuAssistQuery = QueryUtil.createQuery((String)"latest(x | x.properties[$0] != true && x.properties[$1] != true)", (Object[])new Object[]{PROP_TYPE_CATEGORY, PROP_TYPE_PRODUCT});
        }
        return this.iuAssistQuery;
    }

    @Override
    public void completeTargetPlatform_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Keyword _targetKeyword_0;
        String textProposal = null;
        int offset = 0;
        EObject _grammarElement = context.getCurrentNode().getGrammarElement();
        boolean _equals = Objects.equal((Object)_grammarElement, (Object)(_targetKeyword_0 = this.grammarAccess.getTargetPlatformAccess().getTargetKeyword_0()));
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("\"");
            _builder.append(TARGET_PLATFORM__NAME_PLACEHOLDER, " ");
            _builder.append("\"");
            String _lineDelimiter = context.getViewer().getTextWidget().getLineDelimiter();
            _builder.append(_lineDelimiter, " ");
            textProposal = _builder.toString();
            offset = 2;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            _builder_1.append(TARGET_PLATFORM__NAME_PLACEHOLDER);
            _builder_1.append("\"");
            String _lineDelimiter_1 = context.getViewer().getTextWidget().getLineDelimiter();
            _builder_1.append(_lineDelimiter_1);
            textProposal = _builder_1.toString();
            offset = 1;
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("\"");
        _builder_2.append(TARGET_PLATFORM__NAME_PLACEHOLDER);
        _builder_2.append("\"");
        ICompletionProposal p = this.createCompletionProposal(textProposal, new StyledString(_builder_2.toString()).append(" - name of the target", StyledString.QUALIFIER_STYLER), this.getImage((EObject)TARGET_PLATFORM), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _plus = _replacementOffset + offset;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus);
            ((ConfigurableCompletionProposal)p).setSelectionLength(TARGET_PLATFORM__NAME_PLACEHOLDER.length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    @Override
    public void completeTargetPlatform_Contents(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        int _offset = context.getOffset();
        int _endOffset = context.getLastCompleteNode().getEndOffset();
        int currentNodeSizeToCursor = _offset - _endOffset;
        String _xifexpression = null;
        int _length = context.getCurrentNode().getText().length();
        boolean _greaterEqualsThan = _length >= currentNodeSizeToCursor;
        _xifexpression = _greaterEqualsThan ? context.getCurrentNode().getText().substring(0, currentNodeSizeToCursor) : "";
        String text = _xifexpression;
        if (text.contains("\n") || context.getCurrentNode().getText().length() < currentNodeSizeToCursor) {
            Environment _environment;
            boolean _tripleEquals;
            TargetPlatform tp = (TargetPlatform)model;
            boolean _isEmpty = tp.getOptions().isEmpty();
            if (_isEmpty) {
                acceptor.accept(this.createCompletionProposal("with", "describe how the set of elements to add to this target is determined", (EObject)OPTIONS, 520, context));
            }
            boolean bl = _tripleEquals = (_environment = tp.getEnvironment()) == null;
            if (_tripleEquals) {
                acceptor.accept(this.createCompletionProposal("environment", "describe the system that this target is built for", (EObject)ENVIRONMENT, 510, context));
            }
            this.templateLocation(context, acceptor);
            this.templateMavenLocation(context, acceptor);
            this.templateMavenLocationWithFeature(context, acceptor);
            this.templateIncludeDeclaration(context, acceptor);
        }
    }

    private void templateLocation(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String _value = this.grammarAccess.getLocationAccess().getLocationKeyword_0().getValue();
        String proposalPrefix = String.valueOf(_value) + " \"";
        String proposalText = String.valueOf(proposalPrefix) + LOCATION__URI_PLACEHOLDER + "\"";
        String _lineDelimiter = context.getViewer().getTextWidget().getLineDelimiter();
        String _plus = " {" + _lineDelimiter;
        String middleText = String.valueOf(_plus) + "\t";
        String _lineDelimiter_1 = context.getViewer().getTextWidget().getLineDelimiter();
        String _plus_1 = String.valueOf(proposalText) + middleText + _lineDelimiter_1;
        String _plus_2 = String.valueOf(_plus_1) + "}";
        ICompletionProposal p = this.createCompletionProposal(_plus_2, new StyledString(proposalText).append(" - add a new location to this target platform", StyledString.QUALIFIER_STYLER), this.getImage((EObject)LOCATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus_3 = _defaultPriority + 540;
            ((ConfigurableCompletionProposal)p).setPriority(_plus_3);
            int _length = proposalText.length();
            int _length_1 = middleText.length();
            int _plus_4 = _length + _length_1;
            ((ConfigurableCompletionProposal)p).setCursorPosition(_plus_4);
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _length_2 = proposalPrefix.length();
            int _plus_5 = _replacementOffset + _length_2;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus_5);
            ((ConfigurableCompletionProposal)p).setSelectionLength(LOCATION__URI_PLACEHOLDER.length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    private void templateMavenLocationWithFeature(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("maven MavenDependencies scope=compile,test dependencyDepth=infinite missingManifest=generate includeSources {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("feature {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("id=\"my.feature.com\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("name=\"My little feature\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("version=\"1.0.0.qualifier\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("dependency {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("groupId=\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("artifactId=\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("version=\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposalText = _builder.toString();
        StyledString _styledString = new StyledString("Maven Location with Feature - add a new maven location with feature to this target platform", StyledString.QUALIFIER_STYLER);
        ICompletionProposal p = this.createCompletionProposal(proposalText, _styledString, this.getImage((EObject)LOCATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus = _defaultPriority + 540;
            ((ConfigurableCompletionProposal)p).setPriority(_plus);
            ((ConfigurableCompletionProposal)p).setCursorPosition(6);
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _plus_1 = _replacementOffset + 6;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus_1);
            ((ConfigurableCompletionProposal)p).setSelectionLength("MavenDependencies".length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    private void templateMavenLocation(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("maven MavenDependencies scope=compile,test dependencyDepth=infinite missingManifest=generate includeSources {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("dependency {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("groupId=\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("artifactId=\"\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("version=\"\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposalText = _builder.toString();
        StyledString _styledString = new StyledString("Maven location - add a new maven location to this target platform", StyledString.QUALIFIER_STYLER);
        ICompletionProposal p = this.createCompletionProposal(proposalText, _styledString, this.getImage((EObject)LOCATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus = _defaultPriority + 540;
            ((ConfigurableCompletionProposal)p).setPriority(_plus);
            ((ConfigurableCompletionProposal)p).setCursorPosition(6);
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _plus_1 = _replacementOffset + 6;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus_1);
            ((ConfigurableCompletionProposal)p).setSelectionLength("MavenDependencies".length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    private void templateIncludeDeclaration(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String _value = this.grammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0().getValue();
        String proposalPrefix = String.valueOf(_value) + " \"";
        String proposalText = String.valueOf(proposalPrefix) + INCLUDE_DECLARATION__URI_PLACEHOLDER + "\"";
        String _lineDelimiter = context.getViewer().getTextWidget().getLineDelimiter();
        String _plus = String.valueOf(proposalText) + _lineDelimiter;
        ICompletionProposal p = this.createCompletionProposal(_plus, new StyledString(proposalText).append(" - include another target platform to this file", StyledString.QUALIFIER_STYLER), this.getImage((EObject)INCLUDE_DECLARATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus_1 = _defaultPriority + 530;
            ((ConfigurableCompletionProposal)p).setPriority(_plus_1);
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _length = proposalPrefix.length();
            int _plus_2 = _replacementOffset + _length;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus_2);
            ((ConfigurableCompletionProposal)p).setSelectionLength(INCLUDE_DECLARATION__URI_PLACEHOLDER.length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    @Override
    public void completeOptions_Options(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        int _offset = context.getOffset();
        int _endOffset = context.getLastCompleteNode().getEndOffset();
        int currentNodeSizeToCursor = _offset - _endOffset;
        String _xifexpression = null;
        int _length = context.getCurrentNode().getText().length();
        boolean _greaterEqualsThan = _length >= currentNodeSizeToCursor;
        _xifexpression = _greaterEqualsThan ? context.getCurrentNode().getText().substring(0, currentNodeSizeToCursor) : "";
        String text = _xifexpression;
        if (!text.contains("\n") || context.getCurrentNode().getText().length() < currentNodeSizeToCursor) {
            boolean _contains_3;
            boolean _not_3;
            boolean _contains_2;
            boolean _not_2;
            boolean _contains_1;
            boolean _not_1;
            boolean _not;
            Options options = (Options)model;
            boolean _contains = options.getOptions().contains((Object)Option.INCLUDE_REQUIRED);
            boolean bl = _not = !_contains;
            if (_not) {
                acceptor.accept(this.createCompletionProposal(Option.INCLUDE_REQUIRED.getLiteral(), "all required software will be added to the target platform", (EObject)options, 440, context));
            }
            boolean bl2 = _not_1 = !(_contains_1 = options.getOptions().contains((Object)Option.INCLUDE_SOURCE));
            if (_not_1) {
                acceptor.accept(this.createCompletionProposal(Option.INCLUDE_SOURCE.getLiteral(), "sources (if available) of the content will be added to the target platform", (EObject)options, 430, context));
            }
            boolean bl3 = _not_2 = !(_contains_2 = options.getOptions().contains((Object)Option.INCLUDE_ALL_ENVIRONMENTS));
            if (_not_2) {
                acceptor.accept(this.createCompletionProposal(Option.INCLUDE_ALL_ENVIRONMENTS.getLiteral(), "all available environment specific plug-ins will be added to the target platform", (EObject)options, 420, context));
            }
            boolean bl4 = _not_3 = !(_contains_3 = options.getOptions().contains((Object)Option.INCLUDE_CONFIGURE_PHASE));
            if (_not_3) {
                acceptor.accept(this.createCompletionProposal(Option.INCLUDE_CONFIGURE_PHASE.getLiteral(), "the configure phase will be run during the download operation of the target platform", (EObject)options, 410, context));
            }
        }
    }

    private ICompletionProposal createCompletionProposal(String proposal, String desc, EObject imageFor, int priority, ContentAssistContext context) {
        StyledString _styledString = new StyledString(proposal);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(" ");
        _builder.append("- ");
        _builder.append(desc, " ");
        ICompletionProposal p = this.createCompletionProposal(proposal, _styledString.append(_builder.toString(), StyledString.QUALIFIER_STYLER), this.getImage(imageFor), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _defaultPriority = this.getPriorityHelper().getDefaultPriority();
            int _plus = _defaultPriority + priority;
            ((ConfigurableCompletionProposal)p).setPriority(_plus);
        }
        return p;
    }

    @Override
    public void completeEnvironment_Env(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        int _offset = context.getOffset();
        int _endOffset = context.getLastCompleteNode().getEndOffset();
        int currentNodeSizeToCursor = _offset - _endOffset;
        String _xifexpression = null;
        int _length = context.getCurrentNode().getText().length();
        boolean _greaterEqualsThan = _length >= currentNodeSizeToCursor;
        _xifexpression = _greaterEqualsThan ? context.getCurrentNode().getText().substring(0, currentNodeSizeToCursor) : "";
        String text = _xifexpression;
        if (!text.contains("\n") || context.getCurrentNode().getText().length() < currentNodeSizeToCursor) {
            Locale _localization;
            boolean _tripleEquals_4;
            IExecutionEnvironment _executionEnvironment;
            boolean _tripleEquals_3;
            String _architecture;
            boolean _tripleEquals_2;
            String _windowingSystem;
            boolean _tripleEquals_1;
            boolean _tripleEquals;
            Environment env = (Environment)model;
            String _operatingSystem = env.getOperatingSystem();
            boolean bl = _tripleEquals = _operatingSystem == null;
            if (_tripleEquals) {
                Consumer<String> _function = it -> acceptor.accept(this.createCompletionProposal((String)it, "operating system", (EObject)env, 340, context));
                ((List)Conversions.doWrapArray((Object)Platform.knownOSValues())).forEach(_function);
            }
            boolean bl2 = _tripleEquals_1 = (_windowingSystem = env.getWindowingSystem()) == null;
            if (_tripleEquals_1) {
                Consumer<String> _function_1 = it -> acceptor.accept(this.createCompletionProposal((String)it, "windowing system", (EObject)env, 330, context));
                ((List)Conversions.doWrapArray((Object)Platform.knownWSValues())).forEach(_function_1);
            }
            boolean bl3 = _tripleEquals_2 = (_architecture = env.getArchitecture()) == null;
            if (_tripleEquals_2) {
                Consumer<String> _function_2 = it -> acceptor.accept(this.createCompletionProposal((String)it, "architecture", (EObject)env, 320, context));
                ((List)Conversions.doWrapArray((Object)Platform.knownOSArchValues())).forEach(_function_2);
            }
            boolean bl4 = _tripleEquals_3 = (_executionEnvironment = env.getExecutionEnvironment()) == null;
            if (_tripleEquals_3) {
                Consumer<IExecutionEnvironment> _function_3 = it -> acceptor.accept(this.createCompletionProposal(it.getId(), it.getDescription(), (EObject)env, 310, context));
                ((List)Conversions.doWrapArray((Object)this.eeManager.getExecutionEnvironments())).forEach(_function_3);
            }
            boolean bl5 = _tripleEquals_4 = (_localization = env.getLocalization()) == null;
            if (_tripleEquals_4) {
                Consumer<Locale> _function_4 = it -> acceptor.accept(this.createCompletionProposal(it.toString(), it.getDisplayName(), (EObject)env, 300, context));
                ((List)Conversions.doWrapArray((Object)Locale.getAvailableLocales())).forEach(_function_4);
            }
        }
    }

    @Override
    public void completeIU_ID(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            int _offset = context.getOffset();
            int _endOffset = context.getLastCompleteNode().getEndOffset();
            int currentNodeSizeToCursor = _offset - _endOffset;
            String _xifexpression = null;
            int _length = context.getCurrentNode().getText().length();
            boolean _greaterEqualsThan = _length >= currentNodeSizeToCursor;
            _xifexpression = _greaterEqualsThan ? context.getCurrentNode().getText().substring(0, currentNodeSizeToCursor) : "";
            String text = _xifexpression;
            if (model instanceof Location && text.contains("\n") || context.getCurrentNode().getText().length() < currentNodeSizeToCursor) {
                IRunnableWithProgress _function;
                Location location = (Location)model;
                String uri = location.getUri();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IRunnableWithProgress op = _function = monitor -> {
                    block2: {
                        Display _display = window.getShell().getDisplay();
                        ReadAndDispatchProgressMonitorWrapper _readAndDispatchProgressMonitorWrapper = new ReadAndDispatchProgressMonitorWrapper(monitor, _display);
                        SubMonitor wpm = SubMonitor.convert((IProgressMonitor)_readAndDispatchProgressMonitorWrapper, (String)("Creating content assist for " + uri), (int)100);
                        try {
                            Object _service = this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                            IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)_service;
                            URI _uRI = new URI(uri);
                            IMetadataRepository metadataRepository = repositoryManager.loadRepository(_uRI, (IProgressMonitor)wpm.newChild(90));
                            Set results = metadataRepository.query(this.getIUAssistQuery(), (IProgressMonitor)wpm.newChild(5)).toUnmodifiableSet();
                            Functions.Function1 _function_1 = it -> {
                                Functions.Function1 _function_2 = it_1 -> it_1.getID();
                                boolean _contains = ListExtensions.map((List)location.getIus(), (Functions.Function1)_function_2).contains(it.getId());
                                return !_contains;
                            };
                            Consumer<IInstallableUnit> _function_2 = it -> {
                                IQueryResult allVersions = metadataRepository.query(QueryUtil.createIUQuery((String)it.getId()), (IProgressMonitor)wpm.newChild(5));
                                Functions.Function1 _function_3 = it_1 -> it_1.getVersion().toString();
                                acceptor.accept(this.createCompletionProposal(it.getId(), IteratorExtensions.join((Iterator)IteratorExtensions.map((Iterator)allVersions.iterator(), (Functions.Function1)_function_3), (CharSequence)", "), (EObject)IU, 0, context));
                            };
                            IterableExtensions.filter((Iterable)results, (Functions.Function1)_function_1).forEach(_function_2);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) break block2;
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                };
                window.run(false, true, op);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void completeIU_Version(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        try {
            String docText = context.getViewer().getDocument().get();
            int offset = context.getOffset();
            String _xifexpression = null;
            int _length = docText.length();
            boolean _greaterEqualsThan = _length >= 1;
            _xifexpression = _greaterEqualsThan ? docText.substring(offset - 1, offset) : "";
            String charBefore = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = !charBefore.equals(" ") && !charBefore.equals("\n") ? " " : "";
            String prefix = _xifexpression_1;
            int _offset = context.getOffset();
            int _endOffset = context.getLastCompleteNode().getEndOffset();
            int currentNodeSizeToCursor = _offset - _endOffset;
            String _xifexpression_2 = null;
            int _length_1 = context.getCurrentNode().getText().length();
            boolean _greaterEqualsThan_1 = _length_1 >= currentNodeSizeToCursor;
            _xifexpression_2 = _greaterEqualsThan_1 ? context.getCurrentNode().getText().substring(0, currentNodeSizeToCursor) : "";
            String text = _xifexpression_2;
            if (!text.contains("\n") || context.getCurrentNode().getText().length() < currentNodeSizeToCursor) {
                IU iu = (IU)model;
                String uri = iu.getLocation().getUri();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IRunnableWithProgress op = this.versionProposalRunnable(uri, iu, prefix, window.getShell().getDisplay(), context, acceptor);
                window.run(false, true, op);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void completeLocation_ID(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String docText = context.getViewer().getDocument().get();
        int offset = context.getOffset();
        String _xifexpression = null;
        int _length = docText.length();
        boolean _greaterEqualsThan = _length >= 1;
        _xifexpression = _greaterEqualsThan ? docText.substring(offset - 1, offset) : "";
        String charBefore = _xifexpression;
        String _xifexpression_1 = null;
        int _length_1 = docText.length();
        boolean _greaterThan = _length_1 > offset;
        _xifexpression_1 = _greaterThan ? docText.substring(offset, offset + 1) : "";
        String charAfter = _xifexpression_1;
        String _xifexpression_2 = null;
        _xifexpression_2 = !charBefore.equals(" ") && !charBefore.equals("\n") ? " " : "";
        String prefix = _xifexpression_2;
        String _xifexpression_3 = null;
        boolean _equals = charAfter.equals(" ");
        boolean _not = !_equals;
        _xifexpression_3 = _not ? " " : "";
        String suffix = _xifexpression_3;
        String proposal = String.valueOf(prefix) + LOCATION__ID_PLACEHOLDER + suffix;
        ICompletionProposal p = this.createCompletionProposal(proposal, new StyledString(LOCATION__ID_PLACEHOLDER).append(" - ID of this location ", StyledString.QUALIFIER_STYLER), this.getImage((EObject)LOCATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _length_2 = prefix.length();
            int _plus = _replacementOffset + _length_2;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus);
            ((ConfigurableCompletionProposal)p).setSelectionLength(LOCATION__ID_PLACEHOLDER.length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    @Override
    public void completeLocation_Uri(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String docText = context.getViewer().getDocument().get();
        int offset = context.getOffset();
        String _xifexpression = null;
        int _length = docText.length();
        boolean _greaterEqualsThan = _length >= 1;
        _xifexpression = _greaterEqualsThan ? docText.substring(offset - 1, offset) : "";
        String charBefore = _xifexpression;
        String _xifexpression_1 = null;
        int _length_1 = docText.length();
        boolean _greaterThan = _length_1 > offset;
        _xifexpression_1 = _greaterThan ? docText.substring(offset, offset + 1) : "";
        String charAfter = _xifexpression_1;
        String _xifexpression_2 = null;
        _xifexpression_2 = !charBefore.equals(" ") && !charBefore.equals("\n") ? " \"" : "\"";
        String prefix = _xifexpression_2;
        String _xifexpression_3 = null;
        boolean _equals = charAfter.equals(" ");
        boolean _not = !_equals;
        _xifexpression_3 = _not ? "\" " : "\"";
        String suffix = _xifexpression_3;
        String proposal = String.valueOf(prefix) + LOCATION__URI_PLACEHOLDER + suffix;
        ICompletionProposal p = this.createCompletionProposal(proposal, new StyledString(LOCATION__URI_PLACEHOLDER).append(" - URI of the location", StyledString.QUALIFIER_STYLER), this.getImage((EObject)LOCATION), context);
        if (p instanceof ConfigurableCompletionProposal) {
            int _replacementOffset = ((ConfigurableCompletionProposal)p).getReplacementOffset();
            int _length_2 = prefix.length();
            int _plus = _replacementOffset + _length_2;
            ((ConfigurableCompletionProposal)p).setSelectionStart(_plus);
            ((ConfigurableCompletionProposal)p).setSelectionLength(LOCATION__URI_PLACEHOLDER.length());
            ((ConfigurableCompletionProposal)p).setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
        }
        acceptor.accept(p);
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _currentModel = context.getCurrentModel();
        boolean _matched = false;
        if (_currentModel instanceof MavenLocation) {
            _matched = true;
        }
        if (!_matched && _currentModel instanceof MavenDependency) {
            _matched = true;
        }
        if (!_matched && _currentModel instanceof GeneratedFeature) {
            _matched = true;
        }
        if (_matched) {
            super.completeKeyword(keyword, context, acceptor);
        }
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    private IRunnableWithProgress versionProposalRunnable(String uri, IU iu, String prefix, Display display, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IRunnableWithProgress _function = monitor -> {
            try {
                ReadAndDispatchProgressMonitorWrapper _readAndDispatchProgressMonitorWrapper = new ReadAndDispatchProgressMonitorWrapper(monitor, display);
                SubMonitor wpm = SubMonitor.convert((IProgressMonitor)_readAndDispatchProgressMonitorWrapper, (String)("Creating content assist for " + uri), (int)100);
                try {
                    boolean _not;
                    Object _service = this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                    IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)_service;
                    URI _uRI = new URI(uri);
                    IMetadataRepository metadataRepository = repositoryManager.loadRepository(_uRI, (IProgressMonitor)wpm.newChild(95));
                    Set results = metadataRepository.query(QueryUtil.createIUQuery((String)iu.getID()), (IProgressMonitor)wpm.newChild(5)).toUnmodifiableSet();
                    Consumer<IInstallableUnit> _function_1 = it -> {
                        Comparable _segment = it.getVersion().getSegment(0);
                        Integer major = (Integer)_segment;
                        Comparable _segment_1 = it.getVersion().getSegment(1);
                        Integer minor = (Integer)_segment_1;
                        Comparable _segment_2 = it.getVersion().getSegment(2);
                        Integer micro = (Integer)_segment_2;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append(prefix);
                        _builder.append("[");
                        _builder.append((Object)major);
                        _builder.append(".");
                        _builder.append((Object)minor);
                        _builder.append(".");
                        _builder.append((Object)micro);
                        _builder.append(",");
                        _builder.append((Object)(major + 1));
                        _builder.append(".0.0)");
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("[");
                        _builder_1.append((Object)major);
                        _builder_1.append(".");
                        _builder_1.append((Object)minor);
                        _builder_1.append(".");
                        _builder_1.append((Object)micro);
                        _builder_1.append(",");
                        _builder_1.append((Object)(major + 1));
                        _builder_1.append(".0.0)");
                        acceptor.accept(this.createCompletionProposal(_builder.toString(), _builder_1.toString(), this.getImage((EObject)IU), context));
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append(prefix);
                        _builder_2.append("[");
                        _builder_2.append((Object)major);
                        _builder_2.append(".");
                        _builder_2.append((Object)minor);
                        _builder_2.append(".");
                        _builder_2.append((Object)micro);
                        _builder_2.append(",");
                        _builder_2.append((Object)major);
                        _builder_2.append(".");
                        _builder_2.append((Object)(minor + 1));
                        _builder_2.append(".0)");
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append("[");
                        _builder_3.append((Object)major);
                        _builder_3.append(".");
                        _builder_3.append((Object)minor);
                        _builder_3.append(".");
                        _builder_3.append((Object)micro);
                        _builder_3.append(",");
                        _builder_3.append((Object)major);
                        _builder_3.append(".");
                        _builder_3.append((Object)(minor + 1));
                        _builder_3.append(".0)");
                        acceptor.accept(this.createCompletionProposal(_builder_2.toString(), _builder_3.toString(), this.getImage((EObject)IU), context));
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append(prefix);
                        _builder_4.append("[");
                        _builder_4.append((Object)major);
                        _builder_4.append(".");
                        _builder_4.append((Object)minor);
                        _builder_4.append(".");
                        _builder_4.append((Object)micro);
                        _builder_4.append(",");
                        _builder_4.append((Object)major);
                        _builder_4.append(".");
                        _builder_4.append((Object)minor);
                        _builder_4.append(".");
                        _builder_4.append((Object)(micro + 1));
                        _builder_4.append(")");
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append("[");
                        _builder_5.append((Object)major);
                        _builder_5.append(".");
                        _builder_5.append((Object)minor);
                        _builder_5.append(".");
                        _builder_5.append((Object)micro);
                        _builder_5.append(",");
                        _builder_5.append((Object)major);
                        _builder_5.append(".");
                        _builder_5.append((Object)minor);
                        _builder_5.append(".");
                        _builder_5.append((Object)(micro + 1));
                        _builder_5.append(")");
                        acceptor.accept(this.createCompletionProposal(_builder_4.toString(), _builder_5.toString(), this.getImage((EObject)IU), context));
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append(prefix);
                        _builder_6.append("[");
                        Version _version = it.getVersion();
                        _builder_6.append((Object)_version);
                        _builder_6.append(",");
                        Version _version_1 = it.getVersion();
                        _builder_6.append((Object)_version_1);
                        _builder_6.append("]");
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append("[");
                        Version _version_2 = it.getVersion();
                        _builder_7.append((Object)_version_2);
                        _builder_7.append(",");
                        Version _version_3 = it.getVersion();
                        _builder_7.append((Object)_version_3);
                        _builder_7.append("]");
                        acceptor.accept(this.createCompletionProposal(_builder_6.toString(), _builder_7.toString(), this.getImage((EObject)IU), context));
                    };
                    results.forEach(_function_1);
                    boolean _isEmpty = results.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append(prefix);
                        _builder.append("lazy");
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("lazy");
                        acceptor.accept(this.createCompletionProposal(_builder.toString(), _builder_1.toString(), this.getImage((EObject)IU), context));
                    }
                }
                catch (Throwable _t) {
                    if (!(_t instanceof IllegalStateException || _t instanceof ProvisionException || _t instanceof OperationCanceledException)) {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        return _function;
    }
}

