/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.pde;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.targetplatform.model.GeneratedFeature;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.resolved.ResolvedLocation;
import org.eclipse.cbi.targetplatform.resolved.ResolvedMavenArtifact;
import org.eclipse.cbi.targetplatform.resolved.ResolvedMavenLocation;
import org.eclipse.cbi.targetplatform.resolved.ResolvedTargetPlatform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TargetDefinitionGenerator {
    public String generate(ResolvedTargetPlatform targetPlatform, int sequenceNumber) {
        String _xblockexpression = null;
        Preconditions.checkNotNull((Object)targetPlatform);
        int _size = targetPlatform.getLocations().size();
        int _size_1 = targetPlatform.getMavenLocations().size();
        int numLocations = _size + _size_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append("<?pde?>");
        _builder.newLine();
        _builder.append("<!-- generated with https://github.com/eclipse-cbi/targetplatform-dsl -->");
        _builder.newLine();
        _builder.append("<target name=\"");
        String _name = targetPlatform.getName();
        _builder.append(_name);
        _builder.append("\" sequenceNumber=\"");
        _builder.append((Object)sequenceNumber);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        if (numLocations > 0) {
            _builder.append("  ");
            _builder.append("<locations>");
            _builder.newLine();
            List<ResolvedLocation> _locations = targetPlatform.getLocations();
            for (ResolvedLocation location : _locations) {
                _builder.append("  ");
                _builder.append("  ");
                String _generateLocation = this.generateLocation(targetPlatform, location);
                _builder.append(_generateLocation, "    ");
                _builder.newLineIfNotEmpty();
            }
            List<ResolvedMavenLocation> _mavenLocations = targetPlatform.getMavenLocations();
            for (ResolvedMavenLocation mvnLocation : _mavenLocations) {
                _builder.append("  ");
                _builder.append("  ");
                CharSequence _generateMavenLocation = this.generateMavenLocation(targetPlatform, mvnLocation);
                _builder.append((Object)_generateMavenLocation, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("</locations>");
            _builder.newLine();
        }
        if (!(targetPlatform.getEnvironment() == null || StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getOs()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getWs()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getArch()) && StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getNl()))) {
            boolean _isNullOrEmpty_3;
            boolean _not_3;
            boolean _isNullOrEmpty_2;
            boolean _not_2;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _not;
            _builder.append("  ");
            _builder.append("<environment>");
            _builder.newLine();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getOs());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<os>");
                String _os = targetPlatform.getEnvironment().getOs();
                _builder.append(_os, "    ");
                _builder.append("</os>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _not_1 = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getWs()));
            if (_not_1) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<ws>");
                String _ws = targetPlatform.getEnvironment().getWs();
                _builder.append(_ws, "    ");
                _builder.append("</ws>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_2 = !(_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getArch()));
            if (_not_2) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<arch>");
                String _arch = targetPlatform.getEnvironment().getArch();
                _builder.append(_arch, "    ");
                _builder.append("</arch>");
                _builder.newLineIfNotEmpty();
            }
            boolean bl4 = _not_3 = !(_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getNl()));
            if (_not_3) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<nl>");
                String _nl = targetPlatform.getEnvironment().getNl();
                _builder.append(_nl, "    ");
                _builder.append("</nl>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("</environment>");
            _builder.newLine();
        }
        if (targetPlatform.getEnvironment() != null && !StringExtensions.isNullOrEmpty((String)targetPlatform.getEnvironment().getTargetJRE())) {
            _builder.append("  ");
            _builder.append("<targetJRE path=\"");
            String _targetJRE = targetPlatform.getEnvironment().getTargetJRE();
            _builder.append(_targetJRE, "  ");
            _builder.append("\"/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</target>");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public CharSequence generateMavenLocation(ResolvedTargetPlatform platform, ResolvedMavenLocation mavenLocation) {
        StringConcatenation _xblockexpression = null;
        String scopeValue = mavenLocation.getScope();
        String inclSource = mavenLocation.getIncludeSources();
        String missingManifest = mavenLocation.getMissingManifest();
        String depDepth = mavenLocation.getDependencyDepth();
        String label = mavenLocation.getLabel();
        GeneratedFeature genFeature = mavenLocation.getGeneratedFeature();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<location includeDependencyDepth=\"");
        _builder.append(depDepth);
        _builder.append("\" includeDependencyScopes=\"");
        _builder.append(scopeValue);
        _builder.append("\" includeSource=\"");
        _builder.append(inclSource);
        _builder.append("\" missingManifest=\"");
        _builder.append(missingManifest);
        _builder.append("\" type=\"Maven\" label=\"");
        _builder.append(label);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        if (genFeature != null) {
            _builder.append("  ");
            _builder.append("<feature id=\"");
            String _id = genFeature.getId();
            _builder.append(_id, "  ");
            _builder.append("\" label=\"");
            String _name = genFeature.getName();
            _builder.append(_name, "  ");
            _builder.append("\" provider-name=\"");
            String _vendor = genFeature.getVendor();
            _builder.append(_vendor, "  ");
            _builder.append("\" version=\"");
            String _version = genFeature.getVersion();
            _builder.append(_version, "  ");
            _builder.append("\">");
            _builder.newLineIfNotEmpty();
            EList _additionalBundles = genFeature.getAdditionalBundles();
            for (IU iu : _additionalBundles) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<plugin download-size=\"0\" id=\"");
                String _iD = iu.getID();
                _builder.append(_iD, "    ");
                _builder.append("\" install-size=\"0\" unpack=\"false\" version=\"0.0.0\"/>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("</feature>");
            _builder.newLine();
        }
        _builder.append("  ");
        _builder.append("<dependencies>");
        _builder.newLine();
        List<ResolvedMavenArtifact> _mavenDependencies = mavenLocation.getMavenDependencies();
        for (ResolvedMavenArtifact dep : _mavenDependencies) {
            _builder.append("    ");
            _builder.append("<dependency>");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("<groupId>");
            String _groupId = dep.getGroupId();
            _builder.append(_groupId, "      ");
            _builder.append("</groupId>");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("<artifactId>");
            String _artifactId = dep.getArtifactId();
            _builder.append(_artifactId, "      ");
            _builder.append("</artifactId>");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("<version>");
            String _version_1 = dep.getVersion();
            _builder.append(_version_1, "      ");
            _builder.append("</version>");
            _builder.newLineIfNotEmpty();
            boolean _hasClassifier = dep.hasClassifier();
            if (_hasClassifier) {
                _builder.append("    ");
                _builder.append("  ");
                _builder.append("<classifier>");
                String _classifier = dep.getClassifier();
                _builder.append(_classifier, "      ");
                _builder.append("</classifier>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("  ");
            _builder.append("<type>");
            String _type = dep.getType();
            _builder.append(_type, "      ");
            _builder.append("</type>");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("</dependency>");
            _builder.newLine();
        }
        _builder.append("  ");
        _builder.append("</dependencies>");
        _builder.newLine();
        boolean _hasAdditionalRepositories = mavenLocation.hasAdditionalRepositories();
        if (_hasAdditionalRepositories) {
            _builder.append("  ");
            _builder.append("<repositories>");
            _builder.newLine();
            Set<Map.Entry<String, String>> _entrySet = mavenLocation.getRepositoryMap().entrySet();
            for (Map.Entry<String, String> repEntry : _entrySet) {
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<repository>");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<id>");
                String _key = repEntry.getKey();
                _builder.append(_key, "      ");
                _builder.append("</id>");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("<url>");
                String _value = repEntry.getValue();
                _builder.append(_value, "      ");
                _builder.append("</url>");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("</repository>");
                _builder.newLine();
            }
            _builder.append("  ");
            _builder.append("</repositories>");
            _builder.newLine();
        }
        _builder.append("</location>");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String generateLocation(ResolvedTargetPlatform targetPlatform, ResolvedLocation location) {
        boolean _not_1;
        String _xblockexpression = null;
        EnumSet<Option> _xifexpression = null;
        boolean _isEmpty = targetPlatform.getOptions().isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? targetPlatform.getOptions() : location.getOptions();
        EnumSet<Option> options = _xifexpression;
        String _xifexpression_1 = null;
        boolean _contains = options.contains(Option.INCLUDE_REQUIRED);
        _xifexpression_1 = _contains ? "planner" : "slicer";
        String _plus = "includeMode=\"" + _xifexpression_1;
        String includeMode = String.valueOf(_plus) + "\"";
        boolean _contains_1 = options.contains(Option.INCLUDE_ALL_ENVIRONMENTS);
        String _plus_1 = "includeAllPlatforms=\"" + Boolean.valueOf(_contains_1);
        String includeAllPlatforms = String.valueOf(_plus_1) + "\"";
        boolean _contains_2 = options.contains(Option.INCLUDE_SOURCE);
        String _plus_2 = "includeSource=\"" + Boolean.valueOf(_contains_2);
        String includeSource = String.valueOf(_plus_2) + "\"";
        boolean _contains_3 = options.contains(Option.INCLUDE_CONFIGURE_PHASE);
        String _plus_3 = "includeConfigurePhase=\"" + Boolean.valueOf(_contains_3);
        String includeConfigurePhase = String.valueOf(_plus_3) + "\"";
        String locationAttributes = String.valueOf(includeMode) + " " + includeAllPlatforms + " " + includeSource + " " + includeConfigurePhase;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)location.getID());
        boolean bl = _not_1 = !_isNullOrEmpty;
        if (_not_1) {
            _builder.append("id=\"");
            String _iD = location.getID();
            _builder.append(_iD);
            _builder.append("\" ");
        }
        _builder.append("location=\"");
        URI _uRI = location.getURI();
        _builder.append((Object)_uRI);
        _builder.append("\"");
        String repositoryAttributes = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("<location ");
        _builder_1.append(locationAttributes);
        _builder_1.append(" type=\"InstallableUnit\">");
        _builder_1.newLineIfNotEmpty();
        List<IInstallableUnit> _resolvedIUs = location.getResolvedIUs();
        for (IInstallableUnit iu : _resolvedIUs) {
            _builder_1.append("  ");
            _builder_1.append("<unit id=\"");
            String _id = iu.getId();
            _builder_1.append(_id, "  ");
            _builder_1.append("\" version=\"");
            Version _version = iu.getVersion();
            _builder_1.append((Object)_version, "  ");
            _builder_1.append("\"/>");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("  ");
        _builder_1.append("<repository ");
        _builder_1.append(repositoryAttributes, "  ");
        _builder_1.append("/>");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("</location>");
        _builder_1.newLine();
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }
}

