/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.resolved;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cbi.targetplatform.model.GeneratedFeature;
import org.eclipse.cbi.targetplatform.model.MavenDependency;
import org.eclipse.cbi.targetplatform.model.MavenLocation;
import org.eclipse.cbi.targetplatform.model.MavenRepository;
import org.eclipse.cbi.targetplatform.model.MavenScope;
import org.eclipse.cbi.targetplatform.resolved.ResolvedMavenArtifact;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;

public class ResolvedMavenLocation {
    private final MavenLocation dslLocation;
    private List<MavenDependency> unresolvedMavenDependencies;
    private List<ResolvedMavenArtifact> resolvedMavenDependencies;

    public ResolvedMavenLocation(MavenLocation dslLocation) {
        this.dslLocation = dslLocation;
        this.unresolvedMavenDependencies = new ArrayList<MavenDependency>((Collection<MavenDependency>)dslLocation.getDependencies());
        this.resolvedMavenDependencies = new ArrayList<ResolvedMavenArtifact>();
    }

    public String getLabel() {
        return this.dslLocation.getLabel();
    }

    public GeneratedFeature getGeneratedFeature() {
        return this.dslLocation.getGeneratedFeature();
    }

    public String getScope() {
        return this.dslLocation.getScopes().stream().map(MavenScope::getLiteral).collect(Collectors.joining(","));
    }

    public String getIncludeSources() {
        return Boolean.toString(this.dslLocation.isIncludeSources());
    }

    public String getMissingManifest() {
        return this.dslLocation.getMissingManifest().getLiteral();
    }

    public String getDependencyDepth() {
        return this.dslLocation.getDependencyDepth().getLiteral();
    }

    public boolean hasAdditionalRepositories() {
        return !this.dslLocation.getRepositories().isEmpty();
    }

    public Map<String, String> getRepositoryMap() {
        return this.dslLocation.getRepositories().stream().collect(Collectors.toMap(MavenRepository::getId, MavenRepository::getUrl));
    }

    public List<ResolvedMavenArtifact> getMavenDependencies() {
        return this.resolvedMavenDependencies;
    }

    public List<MavenDependency> getUnresolvedMavenDependencies() {
        return this.unresolvedMavenDependencies;
    }

    public Diagnostic resolve(IProgressMonitor monitor) {
        BasicDiagnostic ret = new BasicDiagnostic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.unresolvedMavenDependencies.size());
        Iterator<MavenDependency> it = this.unresolvedMavenDependencies.iterator();
        while (it.hasNext()) {
            ResolvedMavenArtifact resolvedArtifact = new ResolvedMavenArtifact(it.next());
            Diagnostic diagnostic = resolvedArtifact.resolve(subMonitor);
            if (diagnostic.getSeverity() >= 2) {
                ret.merge(diagnostic);
            }
            this.resolvedMavenDependencies.add(resolvedArtifact);
            it.remove();
        }
        return ret;
    }
}

