/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.validation;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.Environment;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.IncludeDeclaration;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.model.Options;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformPackage;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;
import org.eclipse.cbi.targetplatform.util.LocationIndexBuilder;
import org.eclipse.cbi.targetplatform.validation.AbstractTargetPlatformValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TargetPlatformValidator
extends AbstractTargetPlatformValidator {
    @Inject
    private LocationIndexBuilder indexBuilder;
    @Inject
    private IProvisioningAgent provisioningAgent;
    @Inject
    private IExecutionEnvironmentsManager eeManager;
    @Inject
    private TargetPlatformGrammarAccess grammarAccess;
    public static final String CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED = "CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED";
    public static final String CHECK__OPTIONS_EQUALS_ALL_LOCATIONS = "CHECK__OPTIONS_EQUALS_ALL_LOCATIONS";
    public static final String CHECK__NO_OPTIONS_ON_LOCATIONS_IF_GLOBAL_OPTIONS = "CHECK__NO_OPTIONS_ON_LOCATIONS_IF_GLOBAL_OPTIONS";
    public static final String DEPRECATE__OPTIONS_ON_LOCATIONS = "DEPRECATE__OPTIONS_ON_LOCATIONS";
    public static final String DEPRECATE__STRINGS_ON_IU_VERSION = "DEPRECATE__STRINGS_ON_IU_VERSION";
    public static final String CHECK__LOCATION_CONFLICTUAL_ID = "CHECK__LOCATION_CONFLICTUAL_ID";
    public static final String CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID = "CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID";
    public static final String CHECK__CONFLICTUAL_ID__BETWEEN_INCLUDED_LOCATION = "CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID";
    public static final String CHECK__LOCATION_ID_UNIQNESS = "CHECK__LOCATION_ID_UNIQNESS";
    public static final String CHECK__INCLUDE_CYCLE = "CHECK__INCLUDE_CYCLE";
    public static final String CHECK__IU_IN_LOCATION = "CHECK__IU_IN_LOCATION";
    public static final String CHECK__LOCATION_URI = "CHECK__LOCATION_URI";
    public static final String CHECK__ENVIRONMENT_VALIDITY = "CHECK__ENVIRONMENT_VALIDITY";
    public static final String CHECK__ENVIRONMENT_UNICITY = "CHECK__ENVIRONMENT_UNICITY";
    public static final String CHECK__NO_DUPLICATE_ENVIRONMENT_OPTIONS = "CHECK__ENVIRONMENT_COHESION";
    public static final String CHECK__ESCAPE_CHAR_IU_ID = " CHECK__ESCAPE_CHAR_IU_ID";
    public static final String CHECK__VERSION_KEYWORDS = "CHECK__VERSION_KEYWORDS";
    public static final String CHECK__OPTIONS_UNICITY = "CHECK__OPTIONS_UNICITY";
    public static final String CHECK__NO_DUPLICATE_OPTIONS_OPTIONS = "CHECK__NO_DUPLICATE_OPTIONS_OPTIONS";
    public static final String CHECK__NO_DUPLICATED_IU = "CHECK__NO_DUPLICATED_IU";

    @Check
    public void checkAllEnvAndRequiredAreSelfExluding(TargetPlatform targetPlatform) {
        Functions.Function1 _function = it -> it.getOptions();
        Set allOptions = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)targetPlatform.getContents(), Options.class), (Functions.Function1)_function)));
        if (allOptions.contains(Option.INCLUDE_ALL_ENVIRONMENTS) && allOptions.contains(Option.INCLUDE_REQUIRED)) {
            Consumer<Options> _function_1 = it -> this.doReportAllEnvAndRequiredAreSelfExluding((EObject)it, (List<Option>)it.getOptions(), (EStructuralFeature)TargetPlatformPackage.Literals.OPTIONS__OPTIONS);
            Iterables.filter((Iterable)targetPlatform.getContents(), Options.class).forEach(_function_1);
        }
    }

    @Check
    public void checkAllEnvAndRequiredAreSelfExluding(Location location) {
        EList options = location.getOptions();
        if (options.contains((Object)Option.INCLUDE_ALL_ENVIRONMENTS) && options.contains((Object)Option.INCLUDE_REQUIRED)) {
            this.doReportAllEnvAndRequiredAreSelfExluding((EObject)location, (List<Option>)options, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__OPTIONS);
        }
    }

    private void doReportAllEnvAndRequiredAreSelfExluding(EObject optionOwner, List<Option> options, EStructuralFeature feature) {
        boolean _contains_1;
        boolean _contains = options.contains(Option.INCLUDE_REQUIRED);
        if (_contains) {
            this.error("All environments cannot be included along with required artifacts, you must choose one of the two options.", optionOwner, feature, options.indexOf(Option.INCLUDE_REQUIRED), CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED, new String[0]);
        }
        if (_contains_1 = options.contains(Option.INCLUDE_ALL_ENVIRONMENTS)) {
            this.error("All environments cannot be included along with required artifacts, you must choose one of the two options.", optionOwner, feature, options.indexOf(Option.INCLUDE_ALL_ENVIRONMENTS), CHECK__OPTIONS_SELF_EXCLUDING_ALL_ENV_REQUIRED, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicateOptions(TargetPlatform targetPlatform) {
        Functions.Function1 _function = it -> it.getOptions();
        HashMultiset allOptions = HashMultiset.create((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)targetPlatform.getContents(), Options.class), (Functions.Function1)_function)));
        Consumer<Multiset.Entry> _function_1 = e -> {
            boolean _greaterThan;
            int _count = e.getCount();
            boolean bl = _greaterThan = _count > 1;
            if (_greaterThan) {
                Consumer<Options> _function_2 = o -> {
                    int i = 0;
                    while (i < o.getOptions().size()) {
                        Option it = (Option)o.getOptions().get(i);
                        Option _element = (Option)e.getElement();
                        boolean _equals = Objects.equal((Object)_element, (Object)it);
                        if (_equals) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Cannot define multiple option '");
                            _builder.append((Object)it);
                            _builder.append("'.");
                            this.error(_builder.toString(), (EObject)o, (EStructuralFeature)TargetPlatformPackage.Literals.OPTIONS__OPTIONS, i, CHECK__NO_DUPLICATE_OPTIONS_OPTIONS, new String[0]);
                        }
                        ++i;
                    }
                };
                Iterables.filter((Iterable)targetPlatform.getContents(), Options.class).forEach(_function_2);
            }
        };
        allOptions.entrySet().forEach(_function_1);
    }

    @Check
    public void checkNoLocationOptionIfGlobalOptions(Location location) {
        if (!location.getOptions().isEmpty() && !location.getTargetPlatform().getOptions().isEmpty()) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)location, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__OPTIONS);
            INode _head = (INode)IterableExtensions.head((Iterable)nodes);
            INode withKeyword = ((CompositeNode)_head).getPreviousSibling();
            INode _last = (INode)IterableExtensions.last((Iterable)nodes);
            CompositeNode lastOption = (CompositeNode)_last;
            int _offset = withKeyword.getOffset();
            int _endOffset = lastOption.getEndOffset();
            int _offset_1 = withKeyword.getOffset();
            int _minus = _endOffset - _offset_1;
            this.acceptError("You cannot define options on location and on target platform.", (EObject)location, _offset, _minus, CHECK__NO_OPTIONS_ON_LOCATIONS_IF_GLOBAL_OPTIONS, new String[0]);
        }
    }

    @Check
    public void checkOptionsOnLocationAreIdentical(TargetPlatform targetPlatform) {
        boolean _isEmpty = targetPlatform.getOptions().isEmpty();
        if (_isEmpty) {
            boolean _not;
            EList listOptions = targetPlatform.getLocations();
            Location first = (Location)IterableExtensions.head((Iterable)listOptions);
            Functions.Function1 _function = l -> {
                boolean _isEmpty_1 = Sets.symmetricDifference((Set)IterableExtensions.toSet((Iterable)l.getOptions()), (Set)IterableExtensions.toSet((Iterable)first.getOptions())).isEmpty();
                return !_isEmpty_1;
            };
            Iterable conflicts = IterableExtensions.filter((Iterable)IterableExtensions.tail((Iterable)listOptions), (Functions.Function1)_function);
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)conflicts);
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                Consumer<Location> _function_1 = l -> {
                    boolean _not_1;
                    List nodes = NodeModelUtils.findNodesForFeature((EObject)l, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__OPTIONS);
                    boolean _isEmpty_2 = nodes.isEmpty();
                    boolean bl = _not_1 = !_isEmpty_2;
                    if (_not_1) {
                        INode _head = (INode)IterableExtensions.head((Iterable)nodes);
                        INode withKeyword = ((CompositeNode)_head).getPreviousSibling();
                        INode _last = (INode)IterableExtensions.last((Iterable)nodes);
                        CompositeNode lastOption = (CompositeNode)_last;
                        int _offset = withKeyword.getOffset();
                        int _endOffset = lastOption.getEndOffset();
                        int _offset_1 = withKeyword.getOffset();
                        int _minus = _endOffset - _offset_1;
                        this.acceptError("Options of every location must be the same", (EObject)l, _offset, _minus, CHECK__OPTIONS_EQUALS_ALL_LOCATIONS, new String[0]);
                    } else {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)l);
                        this.acceptError("Options of every location must be the same", (EObject)l, node.getOffset(), node.getLength(), CHECK__OPTIONS_EQUALS_ALL_LOCATIONS, new String[0]);
                    }
                };
                listOptions.forEach(_function_1);
            }
        }
    }

    @Check
    public void deprecateOptionsOnLocation(Location location) {
        TargetPlatform targetPlatform = location.getTargetPlatform();
        if (targetPlatform.getOptions().isEmpty() && !location.getOptions().isEmpty()) {
            List nodes = NodeModelUtils.findNodesForFeature((EObject)location, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__OPTIONS);
            INode _head = (INode)IterableExtensions.head((Iterable)nodes);
            INode withKeyword = ((CompositeNode)_head).getPreviousSibling();
            INode _last = (INode)IterableExtensions.last((Iterable)nodes);
            CompositeNode lastOption = (CompositeNode)_last;
            int _offset = withKeyword.getOffset();
            int _endOffset = lastOption.getEndOffset();
            int _offset_1 = withKeyword.getOffset();
            int _minus = _endOffset - _offset_1;
            this.acceptWarning("Options on location are deprecated. Define the option at the target level.", (EObject)location, _offset, _minus, DEPRECATE__OPTIONS_ON_LOCATIONS, new String[0]);
        }
    }

    @Check
    public void deprecateIUVersionRangeWihString(IU iu) {
        List nodes;
        EObject _grammarElement;
        boolean _equals;
        boolean _tripleNotEquals;
        String _version = iu.getVersion();
        boolean bl = _tripleNotEquals = _version != null;
        if (_tripleNotEquals && (_equals = "STRING".equals(((RuleCall)(_grammarElement = ((INode)IterableExtensions.head((Iterable)(nodes = NodeModelUtils.findNodesForFeature((EObject)iu, (EStructuralFeature)TargetPlatformPackage.Literals.IU__VERSION)))).getGrammarElement())).getRule().getName()))) {
            this.warning("Usage of strings is deprecated for version range. You should remove the quotes.", (EObject)iu, (EStructuralFeature)TargetPlatformPackage.Literals.IU__VERSION, DEPRECATE__STRINGS_ON_IU_VERSION, new String[0]);
        }
    }

    @Check
    public void checkIDUniqueOnAllLocations(TargetPlatform targetPlatform) {
        ListMultimap locationsByURI = this.indexBuilder.getLocationIndex(targetPlatform);
        Resource resource = targetPlatform.eResource();
        LinkedHashMultimap locationIDsByURI = LinkedHashMultimap.create();
        Consumer<String> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getID();
            locationIDsByURI.putAll(it, (Iterable)IterableExtensions.toSet((Iterable)ListExtensions.map((List)locationsByURI.get(it), (Functions.Function1)_function_1)));
        };
        locationsByURI.keySet().forEach(_function);
        Functions.Function2 _function_1 = (key, value) -> {
            int _size = value.size();
            return _size <= 1;
        };
        Set locationsURIWithoutConflictingID = MapExtensions.filter((Map)locationIDsByURI.asMap(), (Functions.Function2)_function_1).keySet();
        Functions.Function1 _function_2 = it -> locationsByURI.get(it);
        Iterable locationsWithoutConflictingID = Iterables.concat((Iterable)IterableExtensions.map(locationsURIWithoutConflictingID, (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> {
            String _iD = it.getID();
            return _iD != null;
        };
        Function _function_4 = it -> it.getID();
        ImmutableListMultimap locationsWithoutConflictingIDByID = Multimaps.index((Iterable)IterableExtensions.filter((Iterable)locationsWithoutConflictingID, (Functions.Function1)_function_3), (Function)_function_4);
        Functions.Function2 _function_5 = (key, value) -> {
            Functions.Function1 _function_6 = it -> it.getUri();
            int _size = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)value, (Functions.Function1)_function_6)).size();
            return _size > 1;
        };
        Iterable locationsWithDuplicateID = Iterables.concat(MapExtensions.filter((Map)locationsWithoutConflictingIDByID.asMap(), (Functions.Function2)_function_5).values());
        Consumer<Location> _function_6 = location -> {
            Resource _eResource = location.eResource();
            boolean _equals = Objects.equal((Object)_eResource, (Object)resource);
            if (_equals) {
                this.error("ID must be unique for each location", (EObject)location, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__ID, CHECK__LOCATION_ID_UNIQNESS, new String[0]);
            } else {
                Functions.Function1 _function_7 = it -> {
                    boolean _xblockexpression = false;
                    TargetPlatform direct = this.indexBuilder.getImportedTargetPlatform(resource, (IncludeDeclaration)it);
                    _xblockexpression = direct.getLocations().contains(location) || IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.indexBuilder.getImportedTargetPlatforms(direct), it_1 -> it_1.getLocations()))).contains(location);
                    return _xblockexpression;
                };
                Set conflictualInclude = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)targetPlatform.getIncludes(), (Functions.Function1)_function_7));
                Consumer<IncludeDeclaration> _function_8 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("ID '");
                    String _iD = location.getID();
                    _builder.append(_iD);
                    _builder.append("' is duplicated in the included target platform");
                    this.error(_builder.toString(), (EObject)it, (EStructuralFeature)TargetPlatformPackage.Literals.INCLUDE_DECLARATION__IMPORT_URI, CHECK__LOCATION_ID_UNIQNESS, new String[0]);
                };
                conflictualInclude.forEach(_function_8);
            }
        };
        locationsWithDuplicateID.forEach(_function_6);
    }

    @Check
    public void checkImportCycle(TargetPlatform targetPlatform) {
        boolean _not;
        List<TargetPlatform> cycle = this.indexBuilder.checkIncludeCycle(targetPlatform);
        boolean _isEmpty = cycle.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function = it -> ((TargetPlatform)cycle.get(1)).equals(this.indexBuilder.getImportedTargetPlatform(targetPlatform.eResource(), (IncludeDeclaration)it));
            IncludeDeclaration cyclingImport = (IncludeDeclaration)IterableExtensions.findFirst((Iterable)targetPlatform.getIncludes(), (Functions.Function1)_function);
            if (cyclingImport != null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cycle detected in the included target platforms. Cycle is '");
                Functions.Function1 _function_1 = it -> it.eResource().getURI();
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.drop(cycle, (int)1), (Functions.Function1)_function_1), (CharSequence)"'' -> '");
                _builder.append(_join);
                _builder.append("'.");
                this.error(_builder.toString(), (EObject)cyclingImport, (EStructuralFeature)TargetPlatformPackage.Literals.INCLUDE_DECLARATION__IMPORT_URI, CHECK__INCLUDE_CYCLE, new String[0]);
            }
        }
    }

    @Check
    public void checkSameIDForAllLocationWithSameURI(TargetPlatform targetPlatform) {
        ListMultimap locationsByURI = this.indexBuilder.getLocationIndex(targetPlatform);
        Resource resource = targetPlatform.eResource();
        Set _keySet = locationsByURI.keySet();
        for (String locationURI : _keySet) {
            int _size_1;
            boolean _equals;
            boolean _greaterThan;
            Functions.Function1 _function = it -> {
                Resource _eResource = it.eResource();
                return !Objects.equal((Object)_eResource, (Object)resource);
            };
            Iterable externalLocations = IterableExtensions.filter((Iterable)locationsByURI.get((Object)locationURI), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> Strings.nullToEmpty((String)it.getID());
            Set externalIDs = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)externalLocations, (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = it -> {
                Resource _eResource = it.eResource();
                return Objects.equal((Object)_eResource, (Object)resource);
            };
            Iterable internalLocations = IterableExtensions.filter((Iterable)locationsByURI.get((Object)locationURI), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> Strings.nullToEmpty((String)it.getID());
            Set internalIDs = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)internalLocations, (Functions.Function1)_function_3));
            int _size = externalIDs.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                Functions.Function1 _function_4 = it -> externalIDs.contains(it.getID());
                Iterable externalLocationsWithConflictualID = IterableExtensions.filter((Iterable)externalLocations, (Functions.Function1)_function_4);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The ID for location '");
                _builder.append(locationURI);
                _builder.append("' must be unique. Found '");
                String _join = IterableExtensions.join((Iterable)externalIDs, (CharSequence)"', '");
                _builder.append(_join);
                _builder.append("' in '");
                Functions.Function1 _function_5 = it -> it.eResource().getURI().toString();
                String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)externalLocationsWithConflictualID, (Functions.Function1)_function_5)), (CharSequence)"', '");
                _builder.append(_join_1);
                _builder.append("'.");
                String msg = _builder.toString();
                Functions.Function1 _function_6 = location -> {
                    Functions.Function1 _function_7 = it -> {
                        boolean _xblockexpression = false;
                        TargetPlatform direct = this.indexBuilder.getImportedTargetPlatform(resource, (IncludeDeclaration)it);
                        _xblockexpression = direct.getLocations().contains(location) || IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(this.indexBuilder.getImportedTargetPlatforms(direct), it_1 -> it_1.getLocations()))).contains(location);
                        return _xblockexpression;
                    };
                    return IterableExtensions.filter((Iterable)targetPlatform.getIncludes(), (Functions.Function1)_function_7);
                };
                Set conflictualInclude = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)externalLocationsWithConflictualID, (Functions.Function1)_function_6)));
                Consumer<IncludeDeclaration> _function_7 = it -> this.error(msg, (EObject)it, (EStructuralFeature)TargetPlatformPackage.Literals.INCLUDE_DECLARATION__IMPORT_URI, "CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID", new String[0]);
                conflictualInclude.forEach(_function_7);
            }
            boolean bl2 = _equals = (_size_1 = externalIDs.size()) == 1;
            if (_equals) {
                boolean _not;
                Sets.SetView diff = Sets.symmetricDifference((Set)externalIDs, (Set)internalIDs);
                boolean _isEmpty = diff.isEmpty();
                boolean bl3 = _not = !_isEmpty;
                if (_not) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("The ID for location '");
                    _builder_1.append(locationURI);
                    _builder_1.append("' must be unique across included target platforms and the current one. Found '");
                    String _head = (String)IterableExtensions.head((Iterable)externalIDs);
                    _builder_1.append(_head);
                    _builder_1.append("' in '");
                    Functions.Function1 _function_8 = it -> it.eResource().getURI().toString();
                    String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)externalLocations, (Functions.Function1)_function_8)), (CharSequence)"', '");
                    _builder_1.append(_join_2);
                    _builder_1.append("'.");
                    _builder_1.newLineIfNotEmpty();
                    String msg_1 = _builder_1.toString();
                    Functions.Function1 _function_9 = it -> {
                        boolean _contains = externalIDs.contains(Strings.nullToEmpty((String)it.getID()));
                        return !_contains;
                    };
                    Consumer<Location> _function_10 = it -> this.error(msg_1, (EObject)it, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__ID, "CHECK__INCLUDED_LOCATION_CONFLICTUAL_ID", new String[]{(String)IterableExtensions.head((Iterable)externalIDs), ((Location)IterableExtensions.head((Iterable)externalLocations)).getUri()});
                    IterableExtensions.filter((Iterable)internalLocations, (Functions.Function1)_function_9).forEach(_function_10);
                }
            }
            if (externalIDs.size() >= 1 || internalIDs.size() <= 1) continue;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("The ID for location '");
            _builder_2.append(locationURI);
            _builder_2.append("' must be unique. Found '");
            String _join_3 = IterableExtensions.join((Iterable)internalIDs, (CharSequence)"', '");
            _builder_2.append(_join_3);
            _builder_2.append("'.");
            String msg_2 = _builder_2.toString();
            Consumer<Location> _function_11 = it -> this.error(msg_2, (EObject)it, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__ID, CHECK__LOCATION_CONFLICTUAL_ID, new String[0]);
            internalLocations.forEach(_function_11);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public IMetadataRepository checkLocationURI(Location location) {
        boolean _not;
        IMetadataRepository _xblockexpression = null;
        NullProgressMonitor _xifexpression = null;
        if (this.getContext() != null && this.getContext().get(IProgressMonitor.class) != null) {
            Object _get = this.getContext().get(IProgressMonitor.class);
            _xifexpression = (IProgressMonitor)_get;
        } else {
            _xifexpression = new NullProgressMonitor();
        }
        NullProgressMonitor monitor = _xifexpression;
        IMetadataRepository _xifexpression_1 = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)location.getUri());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            IMetadataRepository _xblockexpression_1 = null;
            Object _service = this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)_service;
            IMetadataRepository _xtrycatchfinallyexpression = null;
            try {
                String _uri = location.getUri();
                URI _uRI = new URI(_uri);
                _xtrycatchfinallyexpression = repositoryManager.loadRepository(_uRI, (IProgressMonitor)monitor);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)e.getMessage());
                    if (_isNullOrEmpty_1) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Error occurred while loading p2 repository at '");
                        String _uri_1 = location.getUri();
                        _builder.append(_uri_1);
                        _builder.append("'.");
                        this.error(_builder.toString(), (EObject)location, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__URI, CHECK__LOCATION_URI, new String[0]);
                    } else {
                        this.error(e.getMessage(), (EObject)location, (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__URI, CHECK__LOCATION_URI, new String[0]);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression_1 = _xblockexpression_1 = _xtrycatchfinallyexpression;
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    @Check(value=CheckType.EXPENSIVE)
    public Object checkIUIDAndRangeInRepository(IU iu) {
        Object _xblockexpression = null;
        Object _service = this.provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)_service;
        Object _xtrycatchfinallyexpression = null;
        try {
            NullProgressMonitor _nullProgressMonitor_2;
            String _version;
            VersionRange _versionRange;
            String _iD_1;
            IQuery _createQuery;
            IQueryResult versionResult;
            boolean _isEmpty_1;
            String _uri = iu.getLocation().getUri();
            URI _uRI = new URI(_uri);
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            IMetadataRepository metadataRepository = repositoryManager.loadRepository(_uRI, (IProgressMonitor)_nullProgressMonitor);
            IQuery _createIUQuery = QueryUtil.createIUQuery((String)iu.getID());
            NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
            Set idResults = metadataRepository.query(_createIUQuery, (IProgressMonitor)_nullProgressMonitor_1).toUnmodifiableSet();
            boolean _isEmpty = idResults.isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("No installable unit with ID '");
                String _iD = iu.getID();
                _builder.append(_iD);
                _builder.append("' can be found in '");
                String _uri_1 = iu.getLocation().getUri();
                _builder.append(_uri_1);
                _builder.append("'.");
                this.error(_builder.toString(), (EObject)iu, (EStructuralFeature)TargetPlatformPackage.Literals.IU__ID, CHECK__IU_IN_LOCATION, new String[0]);
            } else if (!StringExtensions.isNullOrEmpty((String)iu.getVersion()) && !"lazy".equals(iu.getVersion()) && (_isEmpty_1 = (versionResult = metadataRepository.query(_createQuery = QueryUtil.createQuery((String)"latest(x | x.id == $0 && x.version ~= $1)", (Object[])new Object[]{_iD_1 = iu.getID(), _versionRange = new VersionRange(_version = iu.getVersion())}), (IProgressMonitor)(_nullProgressMonitor_2 = new NullProgressMonitor()))).isEmpty())) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("No installable unit with ID '");
                String _iD_2 = iu.getID();
                _builder_1.append(_iD_2);
                _builder_1.append("' can be found with range constraint '");
                String _version_1 = iu.getVersion();
                _builder_1.append(_version_1);
                _builder_1.append("'.");
                this.error(_builder_1.toString(), (EObject)iu, (EStructuralFeature)TargetPlatformPackage.Literals.IU__VERSION, CHECK__IU_IN_LOCATION, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                _xtrycatchfinallyexpression = null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    @Check
    public void checkEnvironment(Environment env) {
        ArrayList dupEnv = Lists.newArrayList((Iterable)env.getEnv());
        Iterator dupEnvIt = dupEnv.iterator();
        Functions.Function1 _function = it -> it.toUpperCase();
        List knownOSUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownOSValues())), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.toUpperCase();
        List knownWSUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownWSValues())), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.toUpperCase();
        List knownArchUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownOSArchValues())), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.toString();
        Functions.Function1 _function_4 = it -> it.toUpperCase();
        List knownLocale = ListExtensions.map((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Locale.getAvailableLocales())), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        Functions.Function1 _function_5 = it -> it.getId().toUpperCase();
        List knownEE = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.eeManager.getExecutionEnvironments())), (Functions.Function1)_function_5);
        while (dupEnvIt.hasNext()) {
            String envValue = ((String)dupEnvIt.next()).toUpperCase();
            if (!knownOSUpperValues.contains(envValue) && !knownWSUpperValues.contains(envValue) && !knownArchUpperValues.contains(envValue) && !knownLocale.contains(envValue) && !knownEE.contains(envValue)) continue;
            dupEnvIt.remove();
        }
        for (String errorEnv : dupEnv) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("'");
            _builder.append(errorEnv);
            _builder.append("' is not a valid environment specification value.");
            this.error(_builder.toString(), (EObject)env, (EStructuralFeature)TargetPlatformPackage.Literals.ENVIRONMENT__ENV, env.getEnv().indexOf((Object)errorEnv), CHECK__ENVIRONMENT_VALIDITY, new String[0]);
        }
    }

    @Check
    public void checkOneEnvironment(TargetPlatform tp) {
        boolean _greaterThan;
        List envList = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)tp.getContents(), Environment.class));
        int _size = envList.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Consumer<Environment> _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Environment definition should not be split across the file.");
                this.warning(_builder.toString(), (EObject)tp, (EStructuralFeature)TargetPlatformPackage.Literals.TARGET_PLATFORM__CONTENTS, tp.getContents().indexOf(it), CHECK__ENVIRONMENT_UNICITY, new String[0]);
            };
            IterableExtensions.tail((Iterable)envList).forEach(_function);
        }
    }

    @Check
    public void checkOneOptions(TargetPlatform tp) {
        boolean _greaterThan;
        List envList = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)tp.getContents(), Options.class));
        int _size = envList.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Consumer<Options> _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Options definition should not be split across the file.");
                this.warning(_builder.toString(), (EObject)tp, (EStructuralFeature)TargetPlatformPackage.Literals.TARGET_PLATFORM__CONTENTS, tp.getContents().indexOf(it), CHECK__OPTIONS_UNICITY, new String[0]);
            };
            IterableExtensions.tail((Iterable)envList).forEach(_function);
        }
    }

    @Check
    public void checkNoDuplicateEnvironmentOptions(TargetPlatform tp) {
        Environment tpEnv = tp.getEnvironment();
        Functions.Function1 _function = it -> it.toUpperCase();
        List knownOSUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownOSValues())), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.toUpperCase();
        List knownWSUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownWSValues())), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.toUpperCase();
        List knownArchUpperValues = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Platform.knownOSArchValues())), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> it.toString().toUpperCase();
        List knownLocale = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)Locale.getAvailableLocales())), (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = it -> it.getId().toUpperCase();
        List knownEE = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.eeManager.getExecutionEnvironments())), (Functions.Function1)_function_4);
        Functions.Function1 _function_5 = it -> it.getEnv();
        Functions.Function1 _function_6 = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
            return !_isNullOrEmpty;
        };
        List envList = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)tp.getContents(), Environment.class), (Functions.Function1)_function_5)), (Functions.Function1)_function_6));
        Functions.Function1 _function_7 = it -> {
            boolean _equals;
            String _upperCase = it.toUpperCase();
            String _windowingSystem = tpEnv.getWindowingSystem();
            String _upperCase_1 = null;
            if (_windowingSystem != null) {
                _upperCase_1 = _windowingSystem.toUpperCase();
            }
            return !(_equals = _upperCase.equals(_upperCase_1));
        };
        Functions.Function1 _function_8 = it -> knownOSUpperValues.contains(it.toUpperCase());
        LinkedHashMultiset allOS = LinkedHashMultiset.create((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)envList, (Functions.Function1)_function_7), (Functions.Function1)_function_8));
        Functions.Function1 _function_9 = it -> {
            boolean _equals;
            String _upperCase = it.toUpperCase();
            String _operatingSystem = tpEnv.getOperatingSystem();
            String _upperCase_1 = null;
            if (_operatingSystem != null) {
                _upperCase_1 = _operatingSystem.toUpperCase();
            }
            return !(_equals = _upperCase.equals(_upperCase_1));
        };
        Functions.Function1 _function_10 = it -> knownWSUpperValues.contains(it.toUpperCase());
        LinkedHashMultiset allWS = LinkedHashMultiset.create((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)envList, (Functions.Function1)_function_9), (Functions.Function1)_function_10));
        Functions.Function1 _function_11 = it -> knownArchUpperValues.contains(it.toUpperCase());
        LinkedHashMultiset allArch = LinkedHashMultiset.create((Iterable)IterableExtensions.filter((Iterable)envList, (Functions.Function1)_function_11));
        Functions.Function1 _function_12 = it -> knownLocale.contains(it.toUpperCase());
        LinkedHashMultiset allLocale = LinkedHashMultiset.create((Iterable)IterableExtensions.filter((Iterable)envList, (Functions.Function1)_function_12));
        Functions.Function1 _function_13 = it -> knownEE.contains(it.toUpperCase());
        LinkedHashMultiset allEE = LinkedHashMultiset.create((Iterable)IterableExtensions.filter((Iterable)envList, (Functions.Function1)_function_13));
        this.reportDuplicatedEnvironmentOptions(tp, (Multiset<String>)allOS, "Cannot define multiple operating systems.");
        this.reportDuplicatedEnvironmentOptions(tp, (Multiset<String>)allWS, "Cannot define multiple windowing systems.");
        this.reportDuplicatedEnvironmentOptions(tp, (Multiset<String>)allArch, "Cannot define multiple processor architectures.");
        this.reportDuplicatedEnvironmentOptions(tp, (Multiset<String>)allLocale, "Cannot define multiple localizations.");
        this.reportDuplicatedEnvironmentOptions(tp, (Multiset<String>)allEE, "Cannot define multiple execution environments.");
    }

    private void reportDuplicatedEnvironmentOptions(TargetPlatform targetPlatform, Multiset<String> valuesInFile, String msg) {
        if (valuesInFile.size() > 1 || IterableExtensions.exists((Iterable)valuesInFile.entrySet(), it -> {
            int _count = it.getCount();
            return _count > 1;
        })) {
            Consumer<String> _function = e -> {
                Consumer<Environment> _function_1 = env -> {
                    int i = 0;
                    while (i < env.getEnv().size()) {
                        String it = (String)env.getEnv().get(i);
                        boolean _equals = e.equals(it);
                        if (_equals) {
                            this.error(msg, (EObject)env, (EStructuralFeature)TargetPlatformPackage.Literals.ENVIRONMENT__ENV, i, CHECK__NO_DUPLICATE_ENVIRONMENT_OPTIONS, new String[0]);
                        }
                        ++i;
                    }
                };
                Iterables.filter((Iterable)targetPlatform.getContents(), Environment.class).forEach(_function_1);
            };
            valuesInFile.elementSet().forEach(_function);
        }
    }

    @Check
    public void checkNoEscapeCharacterInIUID(IU iu) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)iu);
        Functions.Function1 _function = it -> {
            EObject _grammarElement = it.getGrammarElement();
            RuleCall _iDIDTerminalRuleCall_0_0 = this.grammarAccess.getIUAccess().getIDIDTerminalRuleCall_0_0();
            return Objects.equal((Object)_grammarElement, (Object)_iDIDTerminalRuleCall_0_0);
        };
        INode idRule = (INode)IterableExtensions.findFirst((Iterable)node.getAsTreeIterable(), (Functions.Function1)_function);
        String _xifexpression = null;
        _xifexpression = idRule.getText().startsWith("^") && !idRule.getText().contains(".") ? idRule.getText().substring(1) : idRule.getText();
        String id = _xifexpression;
        boolean _contains = id.contains("^");
        if (_contains) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Usage of escape character '^' in the ID of IUs is not required anymore and has been deprecated.");
            this.warning(_builder.toString(), (EObject)iu, (EStructuralFeature)TargetPlatformPackage.Literals.IU__ID, CHECK__ESCAPE_CHAR_IU_ID, new String[0]);
        }
    }

    @Check
    public void checkVersionKeywords(IU iu) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)iu);
        Functions.Function1 _function = it -> {
            EObject _grammarElement = it.getGrammarElement();
            Keyword _semicolonKeyword_1_0_0 = this.grammarAccess.getIUAccess().getSemicolonKeyword_1_0_0();
            return Objects.equal((Object)_grammarElement, (Object)_semicolonKeyword_1_0_0);
        };
        INode semicolonKeywordRule = (INode)IterableExtensions.findFirst((Iterable)node.getAsTreeIterable(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            EObject _grammarElement = it.getGrammarElement();
            Keyword _equalsSignKeyword_1_0_2 = this.grammarAccess.getIUAccess().getEqualsSignKeyword_1_0_2();
            return Objects.equal((Object)_grammarElement, (Object)_equalsSignKeyword_1_0_2);
        };
        INode equalSignKeywordRule = (INode)IterableExtensions.findFirst((Iterable)node.getAsTreeIterable(), (Functions.Function1)_function_1);
        if (semicolonKeywordRule != null) {
            int _offset = semicolonKeywordRule.getOffset();
            int _endOffset = equalSignKeywordRule.getEndOffset();
            int _offset_1 = semicolonKeywordRule.getOffset();
            int _minus = _endOffset - _offset_1;
            this.acceptWarning("Usage of keyword ';version=' is not required anymore and has been deprecated.", (EObject)iu, _offset, _minus, CHECK__VERSION_KEYWORDS, new String[0]);
        }
    }

    @Check
    public void checkNoDuplicatedIU(TargetPlatform targetPlatform) {
        LinkedList<TargetPlatform> importedTPs = this.indexBuilder.getImportedTargetPlatforms(targetPlatform);
        Functions.Function1 _function = it -> it.getLocations();
        Functions.Function1 _function_1 = it -> it.getIus();
        Set importedIUs = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map(importedTPs, (Functions.Function1)_function)), (Functions.Function1)_function_1)));
        Functions.Function1 _function_2 = it -> it.getIus();
        List localIUs = IterableExtensions.toList((Iterable)HashMultiset.create((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)targetPlatform.getLocations(), (Functions.Function1)_function_2))));
        Functions.Function1 _function_3 = it -> it.getID();
        HashMultiset localIUsID = HashMultiset.create((Iterable)ListExtensions.map((List)localIUs, (Functions.Function1)_function_3));
        Functions.Function1 _function_4 = it -> it.getID();
        Set importedIUsID = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)importedIUs, (Functions.Function1)_function_4));
        Functions.Function1 _function_5 = it -> it.getIus();
        Functions.Function1 _function_6 = it -> importedIUsID.contains(it.getID()) || localIUsID.count((Object)it.getID()) > 1;
        Consumer<IU> _function_7 = entry -> {
            Functions.Function1 _function_8 = it -> it.getID().equals(entry.getID());
            Set localIUDuplicates = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)localIUs, (Functions.Function1)_function_8));
            Functions.Function1 _function_9 = it -> it.getLocation().getUri();
            Iterable localLocationsWithDup = IterableExtensions.map((Iterable)localIUDuplicates, (Functions.Function1)_function_9);
            Functions.Function1 _function_10 = it -> it.getID().equals(entry.getID());
            Functions.Function1 _function_11 = it -> it.eResource().getURI();
            Set importedTPsWithDup = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)importedIUs, (Functions.Function1)_function_10), (Functions.Function1)_function_11));
            if (this.iuVersionsIntersect((IU)entry, localIUDuplicates) || this.iuVersionsIntersect((IU)entry, importedIUs)) {
                String _xifexpression = null;
                boolean _contains = importedIUsID.contains(entry.getID());
                if (_contains) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Duplicated IU '");
                    String _iD = entry.getID();
                    _builder.append(_iD);
                    _builder.append("' for locations '");
                    String _join = IterableExtensions.join((Iterable)localLocationsWithDup, (CharSequence)"', '");
                    _builder.append(_join);
                    _builder.append("'. It is included from target platforms '");
                    String _join_1 = IterableExtensions.join((Iterable)importedTPsWithDup, (CharSequence)"', '");
                    _builder.append(_join_1);
                    _builder.append("'.");
                    _xifexpression = _builder.toString();
                } else {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Duplicated IU '");
                    String _iD_1 = entry.getID();
                    _builder_1.append(_iD_1);
                    _builder_1.append("' for locations '");
                    String _join_2 = IterableExtensions.join((Iterable)localLocationsWithDup, (CharSequence)"', '");
                    _builder_1.append(_join_2);
                    _builder_1.append("'.");
                    _xifexpression = _builder_1.toString();
                }
                String msg = _xifexpression;
                this.warning(msg, (EObject)entry.getLocation(), (EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__IUS, entry.getLocation().getIus().indexOf(entry), CHECK__NO_DUPLICATED_IU, new String[0]);
            }
        };
        IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)targetPlatform.getLocations(), (Functions.Function1)_function_5)), (Functions.Function1)_function_6).forEach(_function_7);
    }

    private boolean iuVersionsIntersect(IU entry, Set<IU> ius) {
        boolean _tripleEquals;
        String _version = entry.getVersion();
        boolean bl = _tripleEquals = _version == null;
        if (_tripleEquals) {
            return true;
        }
        for (IU iu : ius) {
            boolean _tripleNotEquals;
            VersionRange otherIuVersionRange;
            boolean _tripleEquals_1;
            if (entry == iu) continue;
            String _version_1 = iu.getVersion();
            boolean bl2 = _tripleEquals_1 = _version_1 == null;
            if (_tripleEquals_1) {
                return true;
            }
            VersionRange iuVersionRange = VersionRange.create((String)entry.getVersion());
            VersionRange _intersect = iuVersionRange.intersect(otherIuVersionRange = VersionRange.create((String)iu.getVersion()));
            boolean bl3 = _tripleNotEquals = _intersect != null;
            if (!_tripleNotEquals) continue;
            return true;
        }
        return false;
    }
}

