/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MavenScope implements Enumerator
{
    COMPILE(0, "COMPILE", "compile"),
    PROVIDED(1, "PROVIDED", "provided"),
    RUNTIME(2, "RUNTIME", "runtime"),
    TEST(3, "TEST", "test"),
    SYSTEM(4, "SYSTEM", "system"),
    IMPORT(5, "IMPORT", "import");

    public static final int COMPILE_VALUE = 0;
    public static final int PROVIDED_VALUE = 1;
    public static final int RUNTIME_VALUE = 2;
    public static final int TEST_VALUE = 3;
    public static final int SYSTEM_VALUE = 4;
    public static final int IMPORT_VALUE = 5;
    private static final MavenScope[] VALUES_ARRAY;
    public static final List<MavenScope> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MavenScope[]{COMPILE, PROVIDED, RUNTIME, TEST, SYSTEM, IMPORT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MavenScope get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MavenScope result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MavenScope getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MavenScope result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MavenScope get(int value) {
        switch (value) {
            case 0: {
                return COMPILE;
            }
            case 1: {
                return PROVIDED;
            }
            case 2: {
                return RUNTIME;
            }
            case 3: {
                return TEST;
            }
            case 4: {
                return SYSTEM;
            }
            case 5: {
                return IMPORT;
            }
        }
        return null;
    }

    private MavenScope(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

