/**
 * Copyright (c) 2012-2017 Obeo and others.
 * This program and the accompanying materials
are made available under the terms of the Eclipse Public License 2.0
which accompanies this distribution, and is available at
https://www.eclipse.org/legal/epl-2.0/

SPDX-License-Identifier: EPL-2.0

Contributors:
	Mikael Barbero - initial implementation
 */
grammar InternalTargetPlatform;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.cbi.targetplatform.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.cbi.targetplatform.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;

}

@parser::members {

 	private TargetPlatformGrammarAccess grammarAccess;

    public InternalTargetPlatformParser(TokenStream input, TargetPlatformGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "TargetPlatform";
   	}

   	@Override
   	protected TargetPlatformGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleTargetPlatform
entryRuleTargetPlatform returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTargetPlatformRule()); }
	iv_ruleTargetPlatform=ruleTargetPlatform
	{ $current=$iv_ruleTargetPlatform.current; }
	EOF;

// Rule TargetPlatform
ruleTargetPlatform returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='target'
		{
			newLeafNode(otherlv_0, grammarAccess.getTargetPlatformAccess().getTargetKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_STRING
				{
					newLeafNode(lv_name_1_0, grammarAccess.getTargetPlatformAccess().getNameSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTargetPlatformRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTargetPlatformAccess().getContentsTargetContentParserRuleCall_2_0());
				}
				lv_contents_2_0=ruleTargetContent
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTargetPlatformRule());
					}
					add(
						$current,
						"contents",
						lv_contents_2_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.TargetContent");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)?
;

// Entry rule entryRuleTargetContent
entryRuleTargetContent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTargetContentRule()); }
	iv_ruleTargetContent=ruleTargetContent
	{ $current=$iv_ruleTargetContent.current; }
	EOF;

// Rule TargetContent
ruleTargetContent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTargetContentAccess().getOptionsParserRuleCall_0());
		}
		this_Options_0=ruleOptions
		{
			$current = $this_Options_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTargetContentAccess().getEnvironmentParserRuleCall_1());
		}
		this_Environment_1=ruleEnvironment
		{
			$current = $this_Environment_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTargetContentAccess().getIncludeDeclarationParserRuleCall_2());
		}
		this_IncludeDeclaration_2=ruleIncludeDeclaration
		{
			$current = $this_IncludeDeclaration_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTargetContentAccess().getLocationParserRuleCall_3());
		}
		this_Location_3=ruleLocation
		{
			$current = $this_Location_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTargetContentAccess().getMavenLocationParserRuleCall_4());
		}
		this_MavenLocation_4=ruleMavenLocation
		{
			$current = $this_MavenLocation_4.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleOptions
entryRuleOptions returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getOptionsRule()); }
	iv_ruleOptions=ruleOptions
	{ $current=$iv_ruleOptions.current; }
	EOF;

// Rule Options
ruleOptions returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='with'
		{
			newLeafNode(otherlv_0, grammarAccess.getOptionsAccess().getWithKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_1_0());
				}
				lv_options_1_0=ruleOption
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getOptionsRule());
					}
					add(
						$current,
						"options",
						lv_options_1_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.Option");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				otherlv_2=','
				{
					newLeafNode(otherlv_2, grammarAccess.getOptionsAccess().getCommaKeyword_2_0());
				}
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_2_1_0());
					}
					lv_options_3_0=ruleOption
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getOptionsRule());
						}
						add(
							$current,
							"options",
							lv_options_3_0,
							"org.eclipse.cbi.targetplatform.TargetPlatform.Option");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleEnvironment
entryRuleEnvironment returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnvironmentRule()); }
	iv_ruleEnvironment=ruleEnvironment
	{ $current=$iv_ruleEnvironment.current; }
	EOF;

// Rule Environment
ruleEnvironment returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEnvironmentAccess().getEnvironmentAction_0(),
					$current);
			}
		)
		otherlv_1='environment'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnvironmentAccess().getEnvironmentKeyword_1());
		}
		(
			(
				lv_env_2_0=RULE_ID
				{
					newLeafNode(lv_env_2_0, grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnvironmentRule());
					}
					addWithLastConsumed(
						$current,
						"env",
						lv_env_2_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.ID");
				}
			)
		)
		(
			(
				otherlv_3=','
				{
					newLeafNode(otherlv_3, grammarAccess.getEnvironmentAccess().getCommaKeyword_3_0());
				}
			)?
			(
				(
					lv_env_4_0=RULE_ID
					{
						newLeafNode(lv_env_4_0, grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getEnvironmentRule());
						}
						addWithLastConsumed(
							$current,
							"env",
							lv_env_4_0,
							"org.eclipse.cbi.targetplatform.TargetPlatform.ID");
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleIncludeDeclaration
entryRuleIncludeDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIncludeDeclarationRule()); }
	iv_ruleIncludeDeclaration=ruleIncludeDeclaration
	{ $current=$iv_ruleIncludeDeclaration.current; }
	EOF;

// Rule IncludeDeclaration
ruleIncludeDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='include'
		{
			newLeafNode(otherlv_0, grammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getIncludeDeclarationAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIncludeDeclarationRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleLocation
entryRuleLocation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocationRule()); }
	iv_ruleLocation=ruleLocation
	{ $current=$iv_ruleLocation.current; }
	EOF;

// Rule Location
ruleLocation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='location'
		{
			newLeafNode(otherlv_0, grammarAccess.getLocationAccess().getLocationKeyword_0());
		}
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getLocationAccess().getUnorderedGroup_1());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 0);
					}
								({true}?=>((
									lv_ID_2_0=RULE_ID
									{
										newLeafNode(lv_ID_2_0, grammarAccess.getLocationAccess().getIDIDTerminalRuleCall_1_0_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getLocationRule());
										}
										setWithLastConsumed(
											$current,
											"ID",
											lv_ID_2_0,
											"org.eclipse.cbi.targetplatform.TargetPlatform.ID");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getLocationAccess().getUnorderedGroup_1());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 1);
					}
								({true}?=>((
									lv_uri_3_0=RULE_STRING
									{
										newLeafNode(lv_uri_3_0, grammarAccess.getLocationAccess().getUriSTRINGTerminalRuleCall_1_1_0());
									}
									{
										if ($current==null) {
											$current = createModelElement(grammarAccess.getLocationRule());
										}
										setWithLastConsumed(
											$current,
											"uri",
											lv_uri_3_0,
											"org.eclipse.xtext.common.Terminals.STRING");
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getLocationAccess().getUnorderedGroup_1());
					}
				)
			)
					)+
					{getUnorderedGroupHelper().canLeave(grammarAccess.getLocationAccess().getUnorderedGroup_1())}?
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getLocationAccess().getUnorderedGroup_1());
				}
		)
		(
			otherlv_4='{'
			{
				newLeafNode(otherlv_4, grammarAccess.getLocationAccess().getLeftCurlyBracketKeyword_2_0());
			}
			(
				otherlv_5='with'
				{
					newLeafNode(otherlv_5, grammarAccess.getLocationAccess().getWithKeyword_2_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_1_0());
						}
						lv_options_6_0=ruleOption
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLocationRule());
							}
							add(
								$current,
								"options",
								lv_options_6_0,
								"org.eclipse.cbi.targetplatform.TargetPlatform.Option");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						otherlv_7=','
						{
							newLeafNode(otherlv_7, grammarAccess.getLocationAccess().getCommaKeyword_2_1_2_0());
						}
					)?
					(
						(
							{
								newCompositeNode(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_2_1_0());
							}
							lv_options_8_0=ruleOption
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getLocationRule());
								}
								add(
									$current,
									"options",
									lv_options_8_0,
									"org.eclipse.cbi.targetplatform.TargetPlatform.Option");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getLocationAccess().getIusIUParserRuleCall_2_2_0());
					}
					lv_ius_9_0=ruleIU
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getLocationRule());
						}
						add(
							$current,
							"ius",
							lv_ius_9_0,
							"org.eclipse.cbi.targetplatform.TargetPlatform.IU");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_10='}'
			{
				newLeafNode(otherlv_10, grammarAccess.getLocationAccess().getRightCurlyBracketKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleMavenLocation
entryRuleMavenLocation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMavenLocationRule()); }
	iv_ruleMavenLocation=ruleMavenLocation
	{ $current=$iv_ruleMavenLocation.current; }
	EOF;

// Rule MavenLocation
ruleMavenLocation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='maven'
		{
			newLeafNode(otherlv_0, grammarAccess.getMavenLocationAccess().getMavenKeyword_0());
		}
		(
			(
				lv_label_1_0=RULE_ID
				{
					newLeafNode(lv_label_1_0, grammarAccess.getMavenLocationAccess().getLabelIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenLocationRule());
					}
					setWithLastConsumed(
						$current,
						"label",
						lv_label_1_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.ID");
				}
			)
		)
		otherlv_2='scope'
		{
			newLeafNode(otherlv_2, grammarAccess.getMavenLocationAccess().getScopeKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_4_0());
				}
				lv_scopes_4_0=ruleMavenScope
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					add(
						$current,
						"scopes",
						lv_scopes_4_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.MavenScope");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=','
			{
				newLeafNode(otherlv_5, grammarAccess.getMavenLocationAccess().getCommaKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_5_1_0());
					}
					lv_scopes_6_0=ruleMavenScope
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
						}
						add(
							$current,
							"scopes",
							lv_scopes_6_0,
							"org.eclipse.cbi.targetplatform.TargetPlatform.MavenScope");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_7='dependencyDepth'
		{
			newLeafNode(otherlv_7, grammarAccess.getMavenLocationAccess().getDependencyDepthKeyword_6());
		}
		otherlv_8='='
		{
			newLeafNode(otherlv_8, grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_7());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getDependencyDepthMavenDependencyDepthEnumRuleCall_8_0());
				}
				lv_dependencyDepth_9_0=ruleMavenDependencyDepth
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					set(
						$current,
						"dependencyDepth",
						lv_dependencyDepth_9_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.MavenDependencyDepth");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_10='missingManifest'
		{
			newLeafNode(otherlv_10, grammarAccess.getMavenLocationAccess().getMissingManifestKeyword_9());
		}
		otherlv_11='='
		{
			newLeafNode(otherlv_11, grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_10());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getMissingManifestMavenMissingManifestEnumRuleCall_11_0());
				}
				lv_missingManifest_12_0=ruleMavenMissingManifest
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					set(
						$current,
						"missingManifest",
						lv_missingManifest_12_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.MavenMissingManifest");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_includeSources_13_0='includeSources'
				{
					newLeafNode(lv_includeSources_13_0, grammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenLocationRule());
					}
					setWithLastConsumed($current, "includeSources", lv_includeSources_13_0 != null, "includeSources");
				}
			)
		)?
		otherlv_14='{'
		{
			newLeafNode(otherlv_14, grammarAccess.getMavenLocationAccess().getLeftCurlyBracketKeyword_13());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getGeneratedFeatureGeneratedFeatureParserRuleCall_14_0());
				}
				lv_generatedFeature_15_0=ruleGeneratedFeature
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					set(
						$current,
						"generatedFeature",
						lv_generatedFeature_15_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.GeneratedFeature");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getDependenciesMavenDependencyParserRuleCall_15_0());
				}
				lv_dependencies_16_0=ruleMavenDependency
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					add(
						$current,
						"dependencies",
						lv_dependencies_16_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.MavenDependency");
					afterParserOrEnumRuleCall();
				}
			)
		)+
		(
			(
				{
					newCompositeNode(grammarAccess.getMavenLocationAccess().getRepositoriesMavenRepositoryParserRuleCall_16_0());
				}
				lv_repositories_17_0=ruleMavenRepository
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMavenLocationRule());
					}
					add(
						$current,
						"repositories",
						lv_repositories_17_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.MavenRepository");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_18='}'
		{
			newLeafNode(otherlv_18, grammarAccess.getMavenLocationAccess().getRightCurlyBracketKeyword_17());
		}
	)
;

// Entry rule entryRuleGeneratedFeature
entryRuleGeneratedFeature returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getGeneratedFeatureRule()); }
	iv_ruleGeneratedFeature=ruleGeneratedFeature
	{ $current=$iv_ruleGeneratedFeature.current; }
	EOF;

// Rule GeneratedFeature
ruleGeneratedFeature returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='feature'
		{
			newLeafNode(otherlv_0, grammarAccess.getGeneratedFeatureAccess().getFeatureKeyword_0());
		}
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_1());
		}
		otherlv_2='id'
		{
			newLeafNode(otherlv_2, grammarAccess.getGeneratedFeatureAccess().getIdKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_3());
		}
		(
			(
				lv_id_4_0=RULE_STRING
				{
					newLeafNode(lv_id_4_0, grammarAccess.getGeneratedFeatureAccess().getIdSTRINGTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getGeneratedFeatureRule());
					}
					setWithLastConsumed(
						$current,
						"id",
						lv_id_4_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		otherlv_5='name'
		{
			newLeafNode(otherlv_5, grammarAccess.getGeneratedFeatureAccess().getNameKeyword_5());
		}
		otherlv_6='='
		{
			newLeafNode(otherlv_6, grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_6());
		}
		(
			(
				lv_name_7_0=RULE_STRING
				{
					newLeafNode(lv_name_7_0, grammarAccess.getGeneratedFeatureAccess().getNameSTRINGTerminalRuleCall_7_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getGeneratedFeatureRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_7_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		otherlv_8='version'
		{
			newLeafNode(otherlv_8, grammarAccess.getGeneratedFeatureAccess().getVersionKeyword_8());
		}
		otherlv_9='='
		{
			newLeafNode(otherlv_9, grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_9());
		}
		(
			(
				lv_version_10_0=RULE_STRING
				{
					newLeafNode(lv_version_10_0, grammarAccess.getGeneratedFeatureAccess().getVersionSTRINGTerminalRuleCall_10_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getGeneratedFeatureRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_10_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		(
			otherlv_11='vendor'
			{
				newLeafNode(otherlv_11, grammarAccess.getGeneratedFeatureAccess().getVendorKeyword_11_0());
			}
			otherlv_12='='
			{
				newLeafNode(otherlv_12, grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_11_1());
			}
			(
				(
					lv_vendor_13_0=RULE_STRING
					{
						newLeafNode(lv_vendor_13_0, grammarAccess.getGeneratedFeatureAccess().getVendorSTRINGTerminalRuleCall_11_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getGeneratedFeatureRule());
						}
						setWithLastConsumed(
							$current,
							"vendor",
							lv_vendor_13_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)?
		(
			otherlv_14='installLibrary'
			{
				newLeafNode(otherlv_14, grammarAccess.getGeneratedFeatureAccess().getInstallLibraryKeyword_12_0());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_12_1());
			}
			(
				(
					lv_instalLibrary_16_0=RULE_STRING
					{
						newLeafNode(lv_instalLibrary_16_0, grammarAccess.getGeneratedFeatureAccess().getInstalLibrarySTRINGTerminalRuleCall_12_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getGeneratedFeatureRule());
						}
						setWithLastConsumed(
							$current,
							"instalLibrary",
							lv_instalLibrary_16_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)?
		(
			otherlv_17='additionalBundles'
			{
				newLeafNode(otherlv_17, grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesKeyword_13_0());
			}
			otherlv_18='{'
			{
				newLeafNode(otherlv_18, grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_13_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesIUParserRuleCall_13_2_0());
					}
					lv_additionalBundles_19_0=ruleIU
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getGeneratedFeatureRule());
						}
						add(
							$current,
							"additionalBundles",
							lv_additionalBundles_19_0,
							"org.eclipse.cbi.targetplatform.TargetPlatform.IU");
						afterParserOrEnumRuleCall();
					}
				)
			)+
			otherlv_20='}'
			{
				newLeafNode(otherlv_20, grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_13_3());
			}
		)?
		otherlv_21='}'
		{
			newLeafNode(otherlv_21, grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_14());
		}
	)
;

// Entry rule entryRuleMavenDependency
entryRuleMavenDependency returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMavenDependencyRule()); }
	iv_ruleMavenDependency=ruleMavenDependency
	{ $current=$iv_ruleMavenDependency.current; }
	EOF;

// Rule MavenDependency
ruleMavenDependency returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='dependency'
		{
			newLeafNode(otherlv_0, grammarAccess.getMavenDependencyAccess().getDependencyKeyword_0());
		}
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getMavenDependencyAccess().getLeftCurlyBracketKeyword_1());
		}
		otherlv_2='groupId'
		{
			newLeafNode(otherlv_2, grammarAccess.getMavenDependencyAccess().getGroupIdKeyword_2());
		}
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_3());
		}
		(
			(
				lv_groupId_4_0=RULE_STRING
				{
					newLeafNode(lv_groupId_4_0, grammarAccess.getMavenDependencyAccess().getGroupIdSTRINGTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenDependencyRule());
					}
					setWithLastConsumed(
						$current,
						"groupId",
						lv_groupId_4_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		otherlv_5='artifactId'
		{
			newLeafNode(otherlv_5, grammarAccess.getMavenDependencyAccess().getArtifactIdKeyword_5());
		}
		otherlv_6='='
		{
			newLeafNode(otherlv_6, grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_6());
		}
		(
			(
				lv_artifactId_7_0=RULE_STRING
				{
					newLeafNode(lv_artifactId_7_0, grammarAccess.getMavenDependencyAccess().getArtifactIdSTRINGTerminalRuleCall_7_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenDependencyRule());
					}
					setWithLastConsumed(
						$current,
						"artifactId",
						lv_artifactId_7_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		otherlv_8='version'
		{
			newLeafNode(otherlv_8, grammarAccess.getMavenDependencyAccess().getVersionKeyword_8());
		}
		otherlv_9='='
		{
			newLeafNode(otherlv_9, grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_9());
		}
		(
			(
				lv_version_10_0=RULE_STRING
				{
					newLeafNode(lv_version_10_0, grammarAccess.getMavenDependencyAccess().getVersionSTRINGTerminalRuleCall_10_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenDependencyRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_10_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		(
			otherlv_11='classifier'
			{
				newLeafNode(otherlv_11, grammarAccess.getMavenDependencyAccess().getClassifierKeyword_11_0());
			}
			otherlv_12='='
			{
				newLeafNode(otherlv_12, grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_11_1());
			}
			(
				(
					lv_classifier_13_0=RULE_STRING
					{
						newLeafNode(lv_classifier_13_0, grammarAccess.getMavenDependencyAccess().getClassifierSTRINGTerminalRuleCall_11_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMavenDependencyRule());
						}
						setWithLastConsumed(
							$current,
							"classifier",
							lv_classifier_13_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)?
		(
			otherlv_14='type'
			{
				newLeafNode(otherlv_14, grammarAccess.getMavenDependencyAccess().getTypeKeyword_12_0());
			}
			otherlv_15='='
			{
				newLeafNode(otherlv_15, grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_12_1());
			}
			(
				(
					lv_type_16_0=RULE_STRING
					{
						newLeafNode(lv_type_16_0, grammarAccess.getMavenDependencyAccess().getTypeSTRINGTerminalRuleCall_12_2_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMavenDependencyRule());
						}
						setWithLastConsumed(
							$current,
							"type",
							lv_type_16_0,
							"org.eclipse.xtext.common.Terminals.STRING");
					}
				)
			)
		)?
		otherlv_17='}'
		{
			newLeafNode(otherlv_17, grammarAccess.getMavenDependencyAccess().getRightCurlyBracketKeyword_13());
		}
	)
;

// Entry rule entryRuleMavenRepository
entryRuleMavenRepository returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMavenRepositoryRule()); }
	iv_ruleMavenRepository=ruleMavenRepository
	{ $current=$iv_ruleMavenRepository.current; }
	EOF;

// Rule MavenRepository
ruleMavenRepository returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='repository'
		{
			newLeafNode(otherlv_0, grammarAccess.getMavenRepositoryAccess().getRepositoryKeyword_0());
		}
		otherlv_1='id'
		{
			newLeafNode(otherlv_1, grammarAccess.getMavenRepositoryAccess().getIdKeyword_1());
		}
		otherlv_2='='
		{
			newLeafNode(otherlv_2, grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_2());
		}
		(
			(
				lv_id_3_0=RULE_STRING
				{
					newLeafNode(lv_id_3_0, grammarAccess.getMavenRepositoryAccess().getIdSTRINGTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenRepositoryRule());
					}
					setWithLastConsumed(
						$current,
						"id",
						lv_id_3_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
		otherlv_4='url'
		{
			newLeafNode(otherlv_4, grammarAccess.getMavenRepositoryAccess().getUrlKeyword_4());
		}
		otherlv_5='='
		{
			newLeafNode(otherlv_5, grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_5());
		}
		(
			(
				lv_url_6_0=RULE_STRING
				{
					newLeafNode(lv_url_6_0, grammarAccess.getMavenRepositoryAccess().getUrlSTRINGTerminalRuleCall_6_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMavenRepositoryRule());
					}
					setWithLastConsumed(
						$current,
						"url",
						lv_url_6_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleIU
entryRuleIU returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIURule()); }
	iv_ruleIU=ruleIU
	{ $current=$iv_ruleIU.current; }
	EOF;

// Rule IU
ruleIU returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_ID_0_0=RULE_ID
				{
					newLeafNode(lv_ID_0_0, grammarAccess.getIUAccess().getIDIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIURule());
					}
					setWithLastConsumed(
						$current,
						"ID",
						lv_ID_0_0,
						"org.eclipse.cbi.targetplatform.TargetPlatform.ID");
				}
			)
		)
		(
			(
				otherlv_1=';'
				{
					newLeafNode(otherlv_1, grammarAccess.getIUAccess().getSemicolonKeyword_1_0_0());
				}
				otherlv_2='version'
				{
					newLeafNode(otherlv_2, grammarAccess.getIUAccess().getVersionKeyword_1_0_1());
				}
				otherlv_3='='
				{
					newLeafNode(otherlv_3, grammarAccess.getIUAccess().getEqualsSignKeyword_1_0_2());
				}
			)?
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getIUAccess().getVersionVersionRangeParserRuleCall_1_1_0_0());
						}
						lv_version_4_0=ruleVersionRange
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getIURule());
							}
							set(
								$current,
								"version",
								lv_version_4_0,
								"org.eclipse.cbi.targetplatform.TargetPlatform.VersionRange");
							afterParserOrEnumRuleCall();
						}
					)
				)
				    |
				(
					(
						lv_version_5_0=RULE_STRING
						{
							newLeafNode(lv_version_5_0, grammarAccess.getIUAccess().getVersionSTRINGTerminalRuleCall_1_1_1_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getIURule());
							}
							setWithLastConsumed(
								$current,
								"version",
								lv_version_5_0,
								"org.eclipse.xtext.common.Terminals.STRING");
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleVersion
entryRuleVersion returns [String current=null]@init {
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();
}:
	{ newCompositeNode(grammarAccess.getVersionRule()); }
	iv_ruleVersion=ruleVersion
	{ $current=$iv_ruleVersion.current.getText(); }
	EOF;
finally {
	myHiddenTokenState.restore();
}

// Rule Version
ruleVersion returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getVersionAccess().getINTTerminalRuleCall_0());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getVersionAccess().getFullStopKeyword_1_0());
			}
			this_INT_2=RULE_INT
			{
				$current.merge(this_INT_2);
			}
			{
				newLeafNode(this_INT_2, grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_1());
			}
			(
				kw='.'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getVersionAccess().getFullStopKeyword_1_2_0());
				}
				this_INT_4=RULE_INT
				{
					$current.merge(this_INT_4);
				}
				{
					newLeafNode(this_INT_4, grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_1());
				}
				(
					kw='.'
					{
						$current.merge(kw);
						newLeafNode(kw, grammarAccess.getVersionAccess().getFullStopKeyword_1_2_2_0());
					}
					(
						this_ID_6=RULE_ID
						{
							$current.merge(this_ID_6);
						}
						{
							newLeafNode(this_ID_6, grammarAccess.getVersionAccess().getIDTerminalRuleCall_1_2_2_1_0());
						}
						    |
						this_INT_7=RULE_INT
						{
							$current.merge(this_INT_7);
						}
						{
							newLeafNode(this_INT_7, grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_2_1_1());
						}
						    |
						this_QUALIFIER_8=RULE_QUALIFIER
						{
							$current.merge(this_QUALIFIER_8);
						}
						{
							newLeafNode(this_QUALIFIER_8, grammarAccess.getVersionAccess().getQUALIFIERTerminalRuleCall_1_2_2_1_2());
						}
					)
				)?
			)?
		)?
	)
;
finally {
	myHiddenTokenState.restore();
}

// Entry rule entryRuleVersionRange
entryRuleVersionRange returns [String current=null]@init {
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens("RULE_WS");
}:
	{ newCompositeNode(grammarAccess.getVersionRangeRule()); }
	iv_ruleVersionRange=ruleVersionRange
	{ $current=$iv_ruleVersionRange.current.getText(); }
	EOF;
finally {
	myHiddenTokenState.restore();
}

// Rule VersionRange
ruleVersionRange returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens("RULE_WS");
}
@after {
	leaveRule();
}:
	(
		(
			(
				kw='('
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getVersionRangeAccess().getLeftParenthesisKeyword_0_0_0());
				}
				    |
				kw='['
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getVersionRangeAccess().getLeftSquareBracketKeyword_0_0_1());
				}
			)
			{
				newCompositeNode(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_1());
			}
			this_Version_2=ruleVersion
			{
				$current.merge(this_Version_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
			kw=','
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getVersionRangeAccess().getCommaKeyword_0_2());
			}
			{
				newCompositeNode(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_3());
			}
			this_Version_4=ruleVersion
			{
				$current.merge(this_Version_4);
			}
			{
				afterParserOrEnumRuleCall();
			}
			(
				kw=')'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getVersionRangeAccess().getRightParenthesisKeyword_0_4_0());
				}
				    |
				kw=']'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getVersionRangeAccess().getRightSquareBracketKeyword_0_4_1());
				}
			)
		)
		    |
		{
			newCompositeNode(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_1());
		}
		this_Version_7=ruleVersion
		{
			$current.merge(this_Version_7);
		}
		{
			afterParserOrEnumRuleCall();
		}
		    |
		kw='lazy'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getVersionRangeAccess().getLazyKeyword_2());
		}
	)
;
finally {
	myHiddenTokenState.restore();
}

// Rule Option
ruleOption returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='requirements'
			{
				$current = grammarAccess.getOptionAccess().getINCLUDE_REQUIREDEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getOptionAccess().getINCLUDE_REQUIREDEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='allEnvironments'
			{
				$current = grammarAccess.getOptionAccess().getINCLUDE_ALL_ENVIRONMENTSEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getOptionAccess().getINCLUDE_ALL_ENVIRONMENTSEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='source'
			{
				$current = grammarAccess.getOptionAccess().getINCLUDE_SOURCEEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getOptionAccess().getINCLUDE_SOURCEEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='configurePhase'
			{
				$current = grammarAccess.getOptionAccess().getINCLUDE_CONFIGURE_PHASEEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getOptionAccess().getINCLUDE_CONFIGURE_PHASEEnumLiteralDeclaration_3());
			}
		)
	)
;

// Rule MavenScope
ruleMavenScope returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='compile'
			{
				$current = grammarAccess.getMavenScopeAccess().getCOMPILEEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMavenScopeAccess().getCOMPILEEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='provided'
			{
				$current = grammarAccess.getMavenScopeAccess().getPROVIDEDEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMavenScopeAccess().getPROVIDEDEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='runtime'
			{
				$current = grammarAccess.getMavenScopeAccess().getRUNTIMEEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMavenScopeAccess().getRUNTIMEEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='test'
			{
				$current = grammarAccess.getMavenScopeAccess().getTESTEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getMavenScopeAccess().getTESTEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='system'
			{
				$current = grammarAccess.getMavenScopeAccess().getSYSTEMEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getMavenScopeAccess().getSYSTEMEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='import'
			{
				$current = grammarAccess.getMavenScopeAccess().getIMPORTEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getMavenScopeAccess().getIMPORTEnumLiteralDeclaration_5());
			}
		)
	)
;

// Rule MavenMissingManifest
ruleMavenMissingManifest returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='generate'
			{
				$current = grammarAccess.getMavenMissingManifestAccess().getGENERATEEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMavenMissingManifestAccess().getGENERATEEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='error'
			{
				$current = grammarAccess.getMavenMissingManifestAccess().getERROREnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMavenMissingManifestAccess().getERROREnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='ignore'
			{
				$current = grammarAccess.getMavenMissingManifestAccess().getIGNOREEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMavenMissingManifestAccess().getIGNOREEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule MavenDependencyDepth
ruleMavenDependencyDepth returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='none'
			{
				$current = grammarAccess.getMavenDependencyDepthAccess().getNONEEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMavenDependencyDepthAccess().getNONEEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='direct'
			{
				$current = grammarAccess.getMavenDependencyDepthAccess().getDIRECTEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMavenDependencyDepthAccess().getDIRECTEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='infinite'
			{
				$current = grammarAccess.getMavenDependencyDepthAccess().getINFINITEEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMavenDependencyDepthAccess().getINFINITEEnumLiteralDeclaration_2());
			}
		)
	)
;

RULE_INT : ('0'..'9')+;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('.'? ('a'..'z'|'A'..'Z'|'^'|'_'|'-'|'0'..'9'))*;

RULE_QUALIFIER : ('a'..'z'|'A'..'Z'|'_'|'-'|'0'..'9')*;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
