/**
 * Copyright (c) 2012-2017 Obeo and others.
 * This program and the accompanying materials
are made available under the terms of the Eclipse Public License 2.0
which accompanies this distribution, and is available at
https://www.eclipse.org/legal/epl-2.0/

SPDX-License-Identifier: EPL-2.0

Contributors:
	Mikael Barbero - initial implementation
 */
grammar InternalTargetPlatform;

options {
	superClass=AbstractInternalContentAssistParser;
}

@lexer::header {
package org.eclipse.cbi.targetplatform.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.cbi.targetplatform.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;

}
@parser::members {
	private TargetPlatformGrammarAccess grammarAccess;

	public void setGrammarAccess(TargetPlatformGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleTargetPlatform
entryRuleTargetPlatform
:
{ before(grammarAccess.getTargetPlatformRule()); }
	 ruleTargetPlatform
{ after(grammarAccess.getTargetPlatformRule()); } 
	 EOF 
;

// Rule TargetPlatform
ruleTargetPlatform 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTargetPlatformAccess().getGroup()); }
		(rule__TargetPlatform__Group__0)?
		{ after(grammarAccess.getTargetPlatformAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTargetContent
entryRuleTargetContent
:
{ before(grammarAccess.getTargetContentRule()); }
	 ruleTargetContent
{ after(grammarAccess.getTargetContentRule()); } 
	 EOF 
;

// Rule TargetContent
ruleTargetContent 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTargetContentAccess().getAlternatives()); }
		(rule__TargetContent__Alternatives)
		{ after(grammarAccess.getTargetContentAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOptions
entryRuleOptions
:
{ before(grammarAccess.getOptionsRule()); }
	 ruleOptions
{ after(grammarAccess.getOptionsRule()); } 
	 EOF 
;

// Rule Options
ruleOptions 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOptionsAccess().getGroup()); }
		(rule__Options__Group__0)
		{ after(grammarAccess.getOptionsAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnvironment
entryRuleEnvironment
:
{ before(grammarAccess.getEnvironmentRule()); }
	 ruleEnvironment
{ after(grammarAccess.getEnvironmentRule()); } 
	 EOF 
;

// Rule Environment
ruleEnvironment 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnvironmentAccess().getGroup()); }
		(rule__Environment__Group__0)
		{ after(grammarAccess.getEnvironmentAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIncludeDeclaration
entryRuleIncludeDeclaration
:
{ before(grammarAccess.getIncludeDeclarationRule()); }
	 ruleIncludeDeclaration
{ after(grammarAccess.getIncludeDeclarationRule()); } 
	 EOF 
;

// Rule IncludeDeclaration
ruleIncludeDeclaration 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIncludeDeclarationAccess().getGroup()); }
		(rule__IncludeDeclaration__Group__0)
		{ after(grammarAccess.getIncludeDeclarationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLocation
entryRuleLocation
:
{ before(grammarAccess.getLocationRule()); }
	 ruleLocation
{ after(grammarAccess.getLocationRule()); } 
	 EOF 
;

// Rule Location
ruleLocation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLocationAccess().getGroup()); }
		(rule__Location__Group__0)
		{ after(grammarAccess.getLocationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMavenLocation
entryRuleMavenLocation
:
{ before(grammarAccess.getMavenLocationRule()); }
	 ruleMavenLocation
{ after(grammarAccess.getMavenLocationRule()); } 
	 EOF 
;

// Rule MavenLocation
ruleMavenLocation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMavenLocationAccess().getGroup()); }
		(rule__MavenLocation__Group__0)
		{ after(grammarAccess.getMavenLocationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleGeneratedFeature
entryRuleGeneratedFeature
:
{ before(grammarAccess.getGeneratedFeatureRule()); }
	 ruleGeneratedFeature
{ after(grammarAccess.getGeneratedFeatureRule()); } 
	 EOF 
;

// Rule GeneratedFeature
ruleGeneratedFeature 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getGroup()); }
		(rule__GeneratedFeature__Group__0)
		{ after(grammarAccess.getGeneratedFeatureAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMavenDependency
entryRuleMavenDependency
:
{ before(grammarAccess.getMavenDependencyRule()); }
	 ruleMavenDependency
{ after(grammarAccess.getMavenDependencyRule()); } 
	 EOF 
;

// Rule MavenDependency
ruleMavenDependency 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getGroup()); }
		(rule__MavenDependency__Group__0)
		{ after(grammarAccess.getMavenDependencyAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMavenRepository
entryRuleMavenRepository
:
{ before(grammarAccess.getMavenRepositoryRule()); }
	 ruleMavenRepository
{ after(grammarAccess.getMavenRepositoryRule()); } 
	 EOF 
;

// Rule MavenRepository
ruleMavenRepository 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMavenRepositoryAccess().getGroup()); }
		(rule__MavenRepository__Group__0)
		{ after(grammarAccess.getMavenRepositoryAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIU
entryRuleIU
:
{ before(grammarAccess.getIURule()); }
	 ruleIU
{ after(grammarAccess.getIURule()); } 
	 EOF 
;

// Rule IU
ruleIU 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIUAccess().getGroup()); }
		(rule__IU__Group__0)
		{ after(grammarAccess.getIUAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVersion
entryRuleVersion
@init { 
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();
}
:
{ before(grammarAccess.getVersionRule()); }
	 ruleVersion
{ after(grammarAccess.getVersionRule()); } 
	 EOF 
;
finally {
	myHiddenTokenState.restore();
}

// Rule Version
ruleVersion 
	@init {
		HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens();
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVersionAccess().getGroup()); }
		(rule__Version__Group__0)
		{ after(grammarAccess.getVersionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
	myHiddenTokenState.restore();
}

// Entry rule entryRuleVersionRange
entryRuleVersionRange
@init { 
	HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens("RULE_WS");
}
:
{ before(grammarAccess.getVersionRangeRule()); }
	 ruleVersionRange
{ after(grammarAccess.getVersionRangeRule()); } 
	 EOF 
;
finally {
	myHiddenTokenState.restore();
}

// Rule VersionRange
ruleVersionRange 
	@init {
		HiddenTokens myHiddenTokenState = ((XtextTokenStream)input).setHiddenTokens("RULE_WS");
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVersionRangeAccess().getAlternatives()); }
		(rule__VersionRange__Alternatives)
		{ after(grammarAccess.getVersionRangeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
	myHiddenTokenState.restore();
}

// Rule Option
ruleOption
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOptionAccess().getAlternatives()); }
		(rule__Option__Alternatives)
		{ after(grammarAccess.getOptionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MavenScope
ruleMavenScope
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenScopeAccess().getAlternatives()); }
		(rule__MavenScope__Alternatives)
		{ after(grammarAccess.getMavenScopeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MavenMissingManifest
ruleMavenMissingManifest
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenMissingManifestAccess().getAlternatives()); }
		(rule__MavenMissingManifest__Alternatives)
		{ after(grammarAccess.getMavenMissingManifestAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MavenDependencyDepth
ruleMavenDependencyDepth
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyDepthAccess().getAlternatives()); }
		(rule__MavenDependencyDepth__Alternatives)
		{ after(grammarAccess.getMavenDependencyDepthAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetContent__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTargetContentAccess().getOptionsParserRuleCall_0()); }
		ruleOptions
		{ after(grammarAccess.getTargetContentAccess().getOptionsParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTargetContentAccess().getEnvironmentParserRuleCall_1()); }
		ruleEnvironment
		{ after(grammarAccess.getTargetContentAccess().getEnvironmentParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTargetContentAccess().getIncludeDeclarationParserRuleCall_2()); }
		ruleIncludeDeclaration
		{ after(grammarAccess.getTargetContentAccess().getIncludeDeclarationParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTargetContentAccess().getLocationParserRuleCall_3()); }
		ruleLocation
		{ after(grammarAccess.getTargetContentAccess().getLocationParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTargetContentAccess().getMavenLocationParserRuleCall_4()); }
		ruleMavenLocation
		{ after(grammarAccess.getTargetContentAccess().getMavenLocationParserRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIUAccess().getVersionAssignment_1_1_0()); }
		(rule__IU__VersionAssignment_1_1_0)
		{ after(grammarAccess.getIUAccess().getVersionAssignment_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getIUAccess().getVersionAssignment_1_1_1()); }
		(rule__IU__VersionAssignment_1_1_1)
		{ after(grammarAccess.getIUAccess().getVersionAssignment_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Alternatives_1_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVersionAccess().getIDTerminalRuleCall_1_2_2_1_0()); }
		RULE_ID
		{ after(grammarAccess.getVersionAccess().getIDTerminalRuleCall_1_2_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_2_1_1()); }
		RULE_INT
		{ after(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getVersionAccess().getQUALIFIERTerminalRuleCall_1_2_2_1_2()); }
		RULE_QUALIFIER
		{ after(grammarAccess.getVersionAccess().getQUALIFIERTerminalRuleCall_1_2_2_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVersionRangeAccess().getGroup_0()); }
		(rule__VersionRange__Group_0__0)
		{ after(grammarAccess.getVersionRangeAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_1()); }
		ruleVersion
		{ after(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getVersionRangeAccess().getLazyKeyword_2()); }
		'lazy'
		{ after(grammarAccess.getVersionRangeAccess().getLazyKeyword_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Alternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVersionRangeAccess().getLeftParenthesisKeyword_0_0_0()); }
		'('
		{ after(grammarAccess.getVersionRangeAccess().getLeftParenthesisKeyword_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVersionRangeAccess().getLeftSquareBracketKeyword_0_0_1()); }
		'['
		{ after(grammarAccess.getVersionRangeAccess().getLeftSquareBracketKeyword_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Alternatives_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVersionRangeAccess().getRightParenthesisKeyword_0_4_0()); }
		')'
		{ after(grammarAccess.getVersionRangeAccess().getRightParenthesisKeyword_0_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getVersionRangeAccess().getRightSquareBracketKeyword_0_4_1()); }
		']'
		{ after(grammarAccess.getVersionRangeAccess().getRightSquareBracketKeyword_0_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Option__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOptionAccess().getINCLUDE_REQUIREDEnumLiteralDeclaration_0()); }
		('requirements')
		{ after(grammarAccess.getOptionAccess().getINCLUDE_REQUIREDEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getOptionAccess().getINCLUDE_ALL_ENVIRONMENTSEnumLiteralDeclaration_1()); }
		('allEnvironments')
		{ after(grammarAccess.getOptionAccess().getINCLUDE_ALL_ENVIRONMENTSEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getOptionAccess().getINCLUDE_SOURCEEnumLiteralDeclaration_2()); }
		('source')
		{ after(grammarAccess.getOptionAccess().getINCLUDE_SOURCEEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getOptionAccess().getINCLUDE_CONFIGURE_PHASEEnumLiteralDeclaration_3()); }
		('configurePhase')
		{ after(grammarAccess.getOptionAccess().getINCLUDE_CONFIGURE_PHASEEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenScope__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenScopeAccess().getCOMPILEEnumLiteralDeclaration_0()); }
		('compile')
		{ after(grammarAccess.getMavenScopeAccess().getCOMPILEEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMavenScopeAccess().getPROVIDEDEnumLiteralDeclaration_1()); }
		('provided')
		{ after(grammarAccess.getMavenScopeAccess().getPROVIDEDEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMavenScopeAccess().getRUNTIMEEnumLiteralDeclaration_2()); }
		('runtime')
		{ after(grammarAccess.getMavenScopeAccess().getRUNTIMEEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getMavenScopeAccess().getTESTEnumLiteralDeclaration_3()); }
		('test')
		{ after(grammarAccess.getMavenScopeAccess().getTESTEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getMavenScopeAccess().getSYSTEMEnumLiteralDeclaration_4()); }
		('system')
		{ after(grammarAccess.getMavenScopeAccess().getSYSTEMEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getMavenScopeAccess().getIMPORTEnumLiteralDeclaration_5()); }
		('import')
		{ after(grammarAccess.getMavenScopeAccess().getIMPORTEnumLiteralDeclaration_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenMissingManifest__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenMissingManifestAccess().getGENERATEEnumLiteralDeclaration_0()); }
		('generate')
		{ after(grammarAccess.getMavenMissingManifestAccess().getGENERATEEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMavenMissingManifestAccess().getERROREnumLiteralDeclaration_1()); }
		('error')
		{ after(grammarAccess.getMavenMissingManifestAccess().getERROREnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMavenMissingManifestAccess().getIGNOREEnumLiteralDeclaration_2()); }
		('ignore')
		{ after(grammarAccess.getMavenMissingManifestAccess().getIGNOREEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependencyDepth__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyDepthAccess().getNONEEnumLiteralDeclaration_0()); }
		('none')
		{ after(grammarAccess.getMavenDependencyDepthAccess().getNONEEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMavenDependencyDepthAccess().getDIRECTEnumLiteralDeclaration_1()); }
		('direct')
		{ after(grammarAccess.getMavenDependencyDepthAccess().getDIRECTEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMavenDependencyDepthAccess().getINFINITEEnumLiteralDeclaration_2()); }
		('infinite')
		{ after(grammarAccess.getMavenDependencyDepthAccess().getINFINITEEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TargetPlatform__Group__0__Impl
	rule__TargetPlatform__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTargetPlatformAccess().getTargetKeyword_0()); }
	'target'
	{ after(grammarAccess.getTargetPlatformAccess().getTargetKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TargetPlatform__Group__1__Impl
	rule__TargetPlatform__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTargetPlatformAccess().getNameAssignment_1()); }
	(rule__TargetPlatform__NameAssignment_1)
	{ after(grammarAccess.getTargetPlatformAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TargetPlatform__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTargetPlatformAccess().getContentsAssignment_2()); }
	(rule__TargetPlatform__ContentsAssignment_2)*
	{ after(grammarAccess.getTargetPlatformAccess().getContentsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Options__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Options__Group__0__Impl
	rule__Options__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOptionsAccess().getWithKeyword_0()); }
	'with'
	{ after(grammarAccess.getOptionsAccess().getWithKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Options__Group__1__Impl
	rule__Options__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOptionsAccess().getOptionsAssignment_1()); }
	(rule__Options__OptionsAssignment_1)
	{ after(grammarAccess.getOptionsAccess().getOptionsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Options__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOptionsAccess().getGroup_2()); }
	(rule__Options__Group_2__0)*
	{ after(grammarAccess.getOptionsAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Options__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Options__Group_2__0__Impl
	rule__Options__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOptionsAccess().getCommaKeyword_2_0()); }
	(',')?
	{ after(grammarAccess.getOptionsAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Options__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOptionsAccess().getOptionsAssignment_2_1()); }
	(rule__Options__OptionsAssignment_2_1)
	{ after(grammarAccess.getOptionsAccess().getOptionsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Environment__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group__0__Impl
	rule__Environment__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getEnvironmentAction_0()); }
	()
	{ after(grammarAccess.getEnvironmentAccess().getEnvironmentAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group__1__Impl
	rule__Environment__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getEnvironmentKeyword_1()); }
	'environment'
	{ after(grammarAccess.getEnvironmentAccess().getEnvironmentKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group__2__Impl
	rule__Environment__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getEnvAssignment_2()); }
	(rule__Environment__EnvAssignment_2)
	{ after(grammarAccess.getEnvironmentAccess().getEnvAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getGroup_3()); }
	(rule__Environment__Group_3__0)*
	{ after(grammarAccess.getEnvironmentAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Environment__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group_3__0__Impl
	rule__Environment__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getCommaKeyword_3_0()); }
	(',')?
	{ after(grammarAccess.getEnvironmentAccess().getCommaKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Environment__Group_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnvironmentAccess().getEnvAssignment_3_1()); }
	(rule__Environment__EnvAssignment_3_1)
	{ after(grammarAccess.getEnvironmentAccess().getEnvAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IncludeDeclaration__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IncludeDeclaration__Group__0__Impl
	rule__IncludeDeclaration__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IncludeDeclaration__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0()); }
	'include'
	{ after(grammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IncludeDeclaration__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IncludeDeclaration__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IncludeDeclaration__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIncludeDeclarationAccess().getImportURIAssignment_1()); }
	(rule__IncludeDeclaration__ImportURIAssignment_1)
	{ after(grammarAccess.getIncludeDeclarationAccess().getImportURIAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Location__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group__0__Impl
	rule__Location__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getLocationKeyword_0()); }
	'location'
	{ after(grammarAccess.getLocationAccess().getLocationKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group__1__Impl
	rule__Location__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getUnorderedGroup_1()); }
	(rule__Location__UnorderedGroup_1)
	{ after(grammarAccess.getLocationAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getGroup_2()); }
	(rule__Location__Group_2__0)?
	{ after(grammarAccess.getLocationAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Location__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2__0__Impl
	rule__Location__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getLeftCurlyBracketKeyword_2_0()); }
	'{'
	{ after(grammarAccess.getLocationAccess().getLeftCurlyBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2__1__Impl
	rule__Location__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getGroup_2_1()); }
	(rule__Location__Group_2_1__0)?
	{ after(grammarAccess.getLocationAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2__2__Impl
	rule__Location__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getIusAssignment_2_2()); }
	(rule__Location__IusAssignment_2_2)*
	{ after(grammarAccess.getLocationAccess().getIusAssignment_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getRightCurlyBracketKeyword_2_3()); }
	'}'
	{ after(grammarAccess.getLocationAccess().getRightCurlyBracketKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Location__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2_1__0__Impl
	rule__Location__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getWithKeyword_2_1_0()); }
	'with'
	{ after(grammarAccess.getLocationAccess().getWithKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2_1__1__Impl
	rule__Location__Group_2_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getOptionsAssignment_2_1_1()); }
	(rule__Location__OptionsAssignment_2_1_1)
	{ after(grammarAccess.getLocationAccess().getOptionsAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getGroup_2_1_2()); }
	(rule__Location__Group_2_1_2__0)*
	{ after(grammarAccess.getLocationAccess().getGroup_2_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Location__Group_2_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2_1_2__0__Impl
	rule__Location__Group_2_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getCommaKeyword_2_1_2_0()); }
	(',')?
	{ after(grammarAccess.getLocationAccess().getCommaKeyword_2_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__Group_2_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__Group_2_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLocationAccess().getOptionsAssignment_2_1_2_1()); }
	(rule__Location__OptionsAssignment_2_1_2_1)
	{ after(grammarAccess.getLocationAccess().getOptionsAssignment_2_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenLocation__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__0__Impl
	rule__MavenLocation__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getMavenKeyword_0()); }
	'maven'
	{ after(grammarAccess.getMavenLocationAccess().getMavenKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__1__Impl
	rule__MavenLocation__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getLabelAssignment_1()); }
	(rule__MavenLocation__LabelAssignment_1)
	{ after(grammarAccess.getMavenLocationAccess().getLabelAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__2__Impl
	rule__MavenLocation__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getScopeKeyword_2()); }
	'scope'
	{ after(grammarAccess.getMavenLocationAccess().getScopeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__3__Impl
	rule__MavenLocation__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_3()); }
	'='
	{ after(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__4__Impl
	rule__MavenLocation__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getScopesAssignment_4()); }
	(rule__MavenLocation__ScopesAssignment_4)
	{ after(grammarAccess.getMavenLocationAccess().getScopesAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__5__Impl
	rule__MavenLocation__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getGroup_5()); }
	(rule__MavenLocation__Group_5__0)*
	{ after(grammarAccess.getMavenLocationAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__6__Impl
	rule__MavenLocation__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getDependencyDepthKeyword_6()); }
	'dependencyDepth'
	{ after(grammarAccess.getMavenLocationAccess().getDependencyDepthKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__7__Impl
	rule__MavenLocation__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_7()); }
	'='
	{ after(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__8__Impl
	rule__MavenLocation__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getDependencyDepthAssignment_8()); }
	(rule__MavenLocation__DependencyDepthAssignment_8)
	{ after(grammarAccess.getMavenLocationAccess().getDependencyDepthAssignment_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__9__Impl
	rule__MavenLocation__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getMissingManifestKeyword_9()); }
	'missingManifest'
	{ after(grammarAccess.getMavenLocationAccess().getMissingManifestKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__10__Impl
	rule__MavenLocation__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_10()); }
	'='
	{ after(grammarAccess.getMavenLocationAccess().getEqualsSignKeyword_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__11__Impl
	rule__MavenLocation__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getMissingManifestAssignment_11()); }
	(rule__MavenLocation__MissingManifestAssignment_11)
	{ after(grammarAccess.getMavenLocationAccess().getMissingManifestAssignment_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__12__Impl
	rule__MavenLocation__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getIncludeSourcesAssignment_12()); }
	(rule__MavenLocation__IncludeSourcesAssignment_12)?
	{ after(grammarAccess.getMavenLocationAccess().getIncludeSourcesAssignment_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__13__Impl
	rule__MavenLocation__Group__14
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getLeftCurlyBracketKeyword_13()); }
	'{'
	{ after(grammarAccess.getMavenLocationAccess().getLeftCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__14
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__14__Impl
	rule__MavenLocation__Group__15
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__14__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getGeneratedFeatureAssignment_14()); }
	(rule__MavenLocation__GeneratedFeatureAssignment_14)?
	{ after(grammarAccess.getMavenLocationAccess().getGeneratedFeatureAssignment_14()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__15
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__15__Impl
	rule__MavenLocation__Group__16
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__15__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMavenLocationAccess().getDependenciesAssignment_15()); }
		(rule__MavenLocation__DependenciesAssignment_15)
		{ after(grammarAccess.getMavenLocationAccess().getDependenciesAssignment_15()); }
	)
	(
		{ before(grammarAccess.getMavenLocationAccess().getDependenciesAssignment_15()); }
		(rule__MavenLocation__DependenciesAssignment_15)*
		{ after(grammarAccess.getMavenLocationAccess().getDependenciesAssignment_15()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__16
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__16__Impl
	rule__MavenLocation__Group__17
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__16__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getRepositoriesAssignment_16()); }
	(rule__MavenLocation__RepositoriesAssignment_16)*
	{ after(grammarAccess.getMavenLocationAccess().getRepositoriesAssignment_16()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__17
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group__17__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group__17__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getRightCurlyBracketKeyword_17()); }
	'}'
	{ after(grammarAccess.getMavenLocationAccess().getRightCurlyBracketKeyword_17()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenLocation__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group_5__0__Impl
	rule__MavenLocation__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getCommaKeyword_5_0()); }
	','
	{ after(grammarAccess.getMavenLocationAccess().getCommaKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenLocation__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenLocationAccess().getScopesAssignment_5_1()); }
	(rule__MavenLocation__ScopesAssignment_5_1)
	{ after(grammarAccess.getMavenLocationAccess().getScopesAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratedFeature__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__0__Impl
	rule__GeneratedFeature__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getFeatureKeyword_0()); }
	'feature'
	{ after(grammarAccess.getGeneratedFeatureAccess().getFeatureKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__1__Impl
	rule__GeneratedFeature__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__2__Impl
	rule__GeneratedFeature__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getIdKeyword_2()); }
	'id'
	{ after(grammarAccess.getGeneratedFeatureAccess().getIdKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__3__Impl
	rule__GeneratedFeature__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_3()); }
	'='
	{ after(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__4__Impl
	rule__GeneratedFeature__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getIdAssignment_4()); }
	(rule__GeneratedFeature__IdAssignment_4)
	{ after(grammarAccess.getGeneratedFeatureAccess().getIdAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__5__Impl
	rule__GeneratedFeature__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getNameKeyword_5()); }
	'name'
	{ after(grammarAccess.getGeneratedFeatureAccess().getNameKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__6__Impl
	rule__GeneratedFeature__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_6()); }
	'='
	{ after(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__7__Impl
	rule__GeneratedFeature__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getNameAssignment_7()); }
	(rule__GeneratedFeature__NameAssignment_7)
	{ after(grammarAccess.getGeneratedFeatureAccess().getNameAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__8__Impl
	rule__GeneratedFeature__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getVersionKeyword_8()); }
	'version'
	{ after(grammarAccess.getGeneratedFeatureAccess().getVersionKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__9__Impl
	rule__GeneratedFeature__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_9()); }
	'='
	{ after(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__10__Impl
	rule__GeneratedFeature__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getVersionAssignment_10()); }
	(rule__GeneratedFeature__VersionAssignment_10)
	{ after(grammarAccess.getGeneratedFeatureAccess().getVersionAssignment_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__11__Impl
	rule__GeneratedFeature__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getGroup_11()); }
	(rule__GeneratedFeature__Group_11__0)?
	{ after(grammarAccess.getGeneratedFeatureAccess().getGroup_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__12__Impl
	rule__GeneratedFeature__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getGroup_12()); }
	(rule__GeneratedFeature__Group_12__0)?
	{ after(grammarAccess.getGeneratedFeatureAccess().getGroup_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__13__Impl
	rule__GeneratedFeature__Group__14
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getGroup_13()); }
	(rule__GeneratedFeature__Group_13__0)?
	{ after(grammarAccess.getGeneratedFeatureAccess().getGroup_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__14
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group__14__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group__14__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_14()); }
	'}'
	{ after(grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_14()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratedFeature__Group_11__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_11__0__Impl
	rule__GeneratedFeature__Group_11__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_11__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getVendorKeyword_11_0()); }
	'vendor'
	{ after(grammarAccess.getGeneratedFeatureAccess().getVendorKeyword_11_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_11__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_11__1__Impl
	rule__GeneratedFeature__Group_11__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_11__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_11_1()); }
	'='
	{ after(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_11_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_11__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_11__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_11__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getVendorAssignment_11_2()); }
	(rule__GeneratedFeature__VendorAssignment_11_2)
	{ after(grammarAccess.getGeneratedFeatureAccess().getVendorAssignment_11_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratedFeature__Group_12__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_12__0__Impl
	rule__GeneratedFeature__Group_12__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_12__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getInstallLibraryKeyword_12_0()); }
	'installLibrary'
	{ after(grammarAccess.getGeneratedFeatureAccess().getInstallLibraryKeyword_12_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_12__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_12__1__Impl
	rule__GeneratedFeature__Group_12__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_12__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_12_1()); }
	'='
	{ after(grammarAccess.getGeneratedFeatureAccess().getEqualsSignKeyword_12_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_12__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_12__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_12__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getInstalLibraryAssignment_12_2()); }
	(rule__GeneratedFeature__InstalLibraryAssignment_12_2)
	{ after(grammarAccess.getGeneratedFeatureAccess().getInstalLibraryAssignment_12_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__GeneratedFeature__Group_13__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_13__0__Impl
	rule__GeneratedFeature__Group_13__1
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesKeyword_13_0()); }
	'additionalBundles'
	{ after(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesKeyword_13_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_13__1__Impl
	rule__GeneratedFeature__Group_13__2
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_13_1()); }
	'{'
	{ after(grammarAccess.getGeneratedFeatureAccess().getLeftCurlyBracketKeyword_13_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_13__2__Impl
	rule__GeneratedFeature__Group_13__3
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesAssignment_13_2()); }
		(rule__GeneratedFeature__AdditionalBundlesAssignment_13_2)
		{ after(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesAssignment_13_2()); }
	)
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesAssignment_13_2()); }
		(rule__GeneratedFeature__AdditionalBundlesAssignment_13_2)*
		{ after(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesAssignment_13_2()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__GeneratedFeature__Group_13__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__Group_13__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_13_3()); }
	'}'
	{ after(grammarAccess.getGeneratedFeatureAccess().getRightCurlyBracketKeyword_13_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenDependency__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__0__Impl
	rule__MavenDependency__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getDependencyKeyword_0()); }
	'dependency'
	{ after(grammarAccess.getMavenDependencyAccess().getDependencyKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__1__Impl
	rule__MavenDependency__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getMavenDependencyAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__2__Impl
	rule__MavenDependency__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getGroupIdKeyword_2()); }
	'groupId'
	{ after(grammarAccess.getMavenDependencyAccess().getGroupIdKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__3__Impl
	rule__MavenDependency__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_3()); }
	'='
	{ after(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__4__Impl
	rule__MavenDependency__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getGroupIdAssignment_4()); }
	(rule__MavenDependency__GroupIdAssignment_4)
	{ after(grammarAccess.getMavenDependencyAccess().getGroupIdAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__5__Impl
	rule__MavenDependency__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getArtifactIdKeyword_5()); }
	'artifactId'
	{ after(grammarAccess.getMavenDependencyAccess().getArtifactIdKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__6__Impl
	rule__MavenDependency__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_6()); }
	'='
	{ after(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__7__Impl
	rule__MavenDependency__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getArtifactIdAssignment_7()); }
	(rule__MavenDependency__ArtifactIdAssignment_7)
	{ after(grammarAccess.getMavenDependencyAccess().getArtifactIdAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__8__Impl
	rule__MavenDependency__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getVersionKeyword_8()); }
	'version'
	{ after(grammarAccess.getMavenDependencyAccess().getVersionKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__9__Impl
	rule__MavenDependency__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_9()); }
	'='
	{ after(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__10__Impl
	rule__MavenDependency__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getVersionAssignment_10()); }
	(rule__MavenDependency__VersionAssignment_10)
	{ after(grammarAccess.getMavenDependencyAccess().getVersionAssignment_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__11__Impl
	rule__MavenDependency__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getGroup_11()); }
	(rule__MavenDependency__Group_11__0)?
	{ after(grammarAccess.getMavenDependencyAccess().getGroup_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__12__Impl
	rule__MavenDependency__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getGroup_12()); }
	(rule__MavenDependency__Group_12__0)?
	{ after(grammarAccess.getMavenDependencyAccess().getGroup_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group__13__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getRightCurlyBracketKeyword_13()); }
	'}'
	{ after(grammarAccess.getMavenDependencyAccess().getRightCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenDependency__Group_11__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_11__0__Impl
	rule__MavenDependency__Group_11__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_11__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getClassifierKeyword_11_0()); }
	'classifier'
	{ after(grammarAccess.getMavenDependencyAccess().getClassifierKeyword_11_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_11__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_11__1__Impl
	rule__MavenDependency__Group_11__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_11__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_11_1()); }
	'='
	{ after(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_11_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_11__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_11__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_11__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getClassifierAssignment_11_2()); }
	(rule__MavenDependency__ClassifierAssignment_11_2)
	{ after(grammarAccess.getMavenDependencyAccess().getClassifierAssignment_11_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenDependency__Group_12__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_12__0__Impl
	rule__MavenDependency__Group_12__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_12__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getTypeKeyword_12_0()); }
	'type'
	{ after(grammarAccess.getMavenDependencyAccess().getTypeKeyword_12_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_12__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_12__1__Impl
	rule__MavenDependency__Group_12__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_12__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_12_1()); }
	'='
	{ after(grammarAccess.getMavenDependencyAccess().getEqualsSignKeyword_12_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_12__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenDependency__Group_12__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__Group_12__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenDependencyAccess().getTypeAssignment_12_2()); }
	(rule__MavenDependency__TypeAssignment_12_2)
	{ after(grammarAccess.getMavenDependencyAccess().getTypeAssignment_12_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MavenRepository__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__0__Impl
	rule__MavenRepository__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getRepositoryKeyword_0()); }
	'repository'
	{ after(grammarAccess.getMavenRepositoryAccess().getRepositoryKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__1__Impl
	rule__MavenRepository__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getIdKeyword_1()); }
	'id'
	{ after(grammarAccess.getMavenRepositoryAccess().getIdKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__2__Impl
	rule__MavenRepository__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_2()); }
	'='
	{ after(grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__3__Impl
	rule__MavenRepository__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getIdAssignment_3()); }
	(rule__MavenRepository__IdAssignment_3)
	{ after(grammarAccess.getMavenRepositoryAccess().getIdAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__4__Impl
	rule__MavenRepository__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getUrlKeyword_4()); }
	'url'
	{ after(grammarAccess.getMavenRepositoryAccess().getUrlKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__5__Impl
	rule__MavenRepository__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_5()); }
	'='
	{ after(grammarAccess.getMavenRepositoryAccess().getEqualsSignKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MavenRepository__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMavenRepositoryAccess().getUrlAssignment_6()); }
	(rule__MavenRepository__UrlAssignment_6)
	{ after(grammarAccess.getMavenRepositoryAccess().getUrlAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IU__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group__0__Impl
	rule__IU__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getIDAssignment_0()); }
	(rule__IU__IDAssignment_0)
	{ after(grammarAccess.getIUAccess().getIDAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getGroup_1()); }
	(rule__IU__Group_1__0)?
	{ after(grammarAccess.getIUAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IU__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group_1__0__Impl
	rule__IU__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getGroup_1_0()); }
	(rule__IU__Group_1_0__0)?
	{ after(grammarAccess.getIUAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getAlternatives_1_1()); }
	(rule__IU__Alternatives_1_1)
	{ after(grammarAccess.getIUAccess().getAlternatives_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IU__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group_1_0__0__Impl
	rule__IU__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getSemicolonKeyword_1_0_0()); }
	';'
	{ after(grammarAccess.getIUAccess().getSemicolonKeyword_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group_1_0__1__Impl
	rule__IU__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getVersionKeyword_1_0_1()); }
	'version'
	{ after(grammarAccess.getIUAccess().getVersionKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IU__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIUAccess().getEqualsSignKeyword_1_0_2()); }
	'='
	{ after(grammarAccess.getIUAccess().getEqualsSignKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Version__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group__0__Impl
	rule__Version__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getINTTerminalRuleCall_0()); }
	RULE_INT
	{ after(grammarAccess.getVersionAccess().getINTTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getGroup_1()); }
	(rule__Version__Group_1__0)?
	{ after(grammarAccess.getVersionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Version__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1__0__Impl
	rule__Version__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getFullStopKeyword_1_0()); }
	'.'
	{ after(grammarAccess.getVersionAccess().getFullStopKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1__1__Impl
	rule__Version__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_1()); }
	RULE_INT
	{ after(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getGroup_1_2()); }
	(rule__Version__Group_1_2__0)?
	{ after(grammarAccess.getVersionAccess().getGroup_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Version__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1_2__0__Impl
	rule__Version__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getFullStopKeyword_1_2_0()); }
	'.'
	{ after(grammarAccess.getVersionAccess().getFullStopKeyword_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1_2__1__Impl
	rule__Version__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_1()); }
	RULE_INT
	{ after(grammarAccess.getVersionAccess().getINTTerminalRuleCall_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getGroup_1_2_2()); }
	(rule__Version__Group_1_2_2__0)?
	{ after(grammarAccess.getVersionAccess().getGroup_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Version__Group_1_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1_2_2__0__Impl
	rule__Version__Group_1_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getFullStopKeyword_1_2_2_0()); }
	'.'
	{ after(grammarAccess.getVersionAccess().getFullStopKeyword_1_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Version__Group_1_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Version__Group_1_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionAccess().getAlternatives_1_2_2_1()); }
	(rule__Version__Alternatives_1_2_2_1)
	{ after(grammarAccess.getVersionAccess().getAlternatives_1_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VersionRange__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VersionRange__Group_0__0__Impl
	rule__VersionRange__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionRangeAccess().getAlternatives_0_0()); }
	(rule__VersionRange__Alternatives_0_0)
	{ after(grammarAccess.getVersionRangeAccess().getAlternatives_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VersionRange__Group_0__1__Impl
	rule__VersionRange__Group_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_1()); }
	ruleVersion
	{ after(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VersionRange__Group_0__2__Impl
	rule__VersionRange__Group_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionRangeAccess().getCommaKeyword_0_2()); }
	','
	{ after(grammarAccess.getVersionRangeAccess().getCommaKeyword_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VersionRange__Group_0__3__Impl
	rule__VersionRange__Group_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_3()); }
	ruleVersion
	{ after(grammarAccess.getVersionRangeAccess().getVersionParserRuleCall_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VersionRange__Group_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VersionRange__Group_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVersionRangeAccess().getAlternatives_0_4()); }
	(rule__VersionRange__Alternatives_0_4)
	{ after(grammarAccess.getVersionRangeAccess().getAlternatives_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Location__UnorderedGroup_1
	@init {
		int stackSize = keepStackSize();
		getUnorderedGroupHelper().enter(grammarAccess.getLocationAccess().getUnorderedGroup_1());
	}
:
	rule__Location__UnorderedGroup_1__0
	{getUnorderedGroupHelper().canLeave(grammarAccess.getLocationAccess().getUnorderedGroup_1())}?
;
finally {
	getUnorderedGroupHelper().leave(grammarAccess.getLocationAccess().getUnorderedGroup_1());
	restoreStackSize(stackSize);
}

rule__Location__UnorderedGroup_1__Impl
	@init {
		int stackSize = keepStackSize();
		boolean selected = false;
	}
:
		(
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 0)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 0);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getLocationAccess().getIDAssignment_1_0()); }
					(rule__Location__IDAssignment_1_0)
					{ after(grammarAccess.getLocationAccess().getIDAssignment_1_0()); }
				)
			)
		)|
		( 
			{getUnorderedGroupHelper().canSelect(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 1)}?=>(
				{
					getUnorderedGroupHelper().select(grammarAccess.getLocationAccess().getUnorderedGroup_1(), 1);
				}
				{
					selected = true;
				}
				(
					{ before(grammarAccess.getLocationAccess().getUriAssignment_1_1()); }
					(rule__Location__UriAssignment_1_1)
					{ after(grammarAccess.getLocationAccess().getUriAssignment_1_1()); }
				)
			)
		)
		)
;
finally {
	if (selected)
		getUnorderedGroupHelper().returnFromSelection(grammarAccess.getLocationAccess().getUnorderedGroup_1());
	restoreStackSize(stackSize);
}

rule__Location__UnorderedGroup_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__UnorderedGroup_1__Impl
	rule__Location__UnorderedGroup_1__1?
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__UnorderedGroup_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Location__UnorderedGroup_1__Impl
;
finally {
	restoreStackSize(stackSize);
}


rule__TargetPlatform__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTargetPlatformAccess().getNameSTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getTargetPlatformAccess().getNameSTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TargetPlatform__ContentsAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTargetPlatformAccess().getContentsTargetContentParserRuleCall_2_0()); }
		ruleTargetContent
		{ after(grammarAccess.getTargetPlatformAccess().getContentsTargetContentParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__OptionsAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_1_0()); }
		ruleOption
		{ after(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Options__OptionsAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_2_1_0()); }
		ruleOption
		{ after(grammarAccess.getOptionsAccess().getOptionsOptionEnumRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__EnvAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_2_0()); }
		RULE_ID
		{ after(grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Environment__EnvAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_3_1_0()); }
		RULE_ID
		{ after(grammarAccess.getEnvironmentAccess().getEnvIDTerminalRuleCall_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IncludeDeclaration__ImportURIAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIncludeDeclarationAccess().getImportURISTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getIncludeDeclarationAccess().getImportURISTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__IDAssignment_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLocationAccess().getIDIDTerminalRuleCall_1_0_0()); }
		RULE_ID
		{ after(grammarAccess.getLocationAccess().getIDIDTerminalRuleCall_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__UriAssignment_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLocationAccess().getUriSTRINGTerminalRuleCall_1_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getLocationAccess().getUriSTRINGTerminalRuleCall_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__OptionsAssignment_2_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_1_0()); }
		ruleOption
		{ after(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__OptionsAssignment_2_1_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_2_1_0()); }
		ruleOption
		{ after(grammarAccess.getLocationAccess().getOptionsOptionEnumRuleCall_2_1_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Location__IusAssignment_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLocationAccess().getIusIUParserRuleCall_2_2_0()); }
		ruleIU
		{ after(grammarAccess.getLocationAccess().getIusIUParserRuleCall_2_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__LabelAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getLabelIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getMavenLocationAccess().getLabelIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__ScopesAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_4_0()); }
		ruleMavenScope
		{ after(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__ScopesAssignment_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_5_1_0()); }
		ruleMavenScope
		{ after(grammarAccess.getMavenLocationAccess().getScopesMavenScopeEnumRuleCall_5_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__DependencyDepthAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getDependencyDepthMavenDependencyDepthEnumRuleCall_8_0()); }
		ruleMavenDependencyDepth
		{ after(grammarAccess.getMavenLocationAccess().getDependencyDepthMavenDependencyDepthEnumRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__MissingManifestAssignment_11
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getMissingManifestMavenMissingManifestEnumRuleCall_11_0()); }
		ruleMavenMissingManifest
		{ after(grammarAccess.getMavenLocationAccess().getMissingManifestMavenMissingManifestEnumRuleCall_11_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__IncludeSourcesAssignment_12
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0()); }
		(
			{ before(grammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0()); }
			'includeSources'
			{ after(grammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0()); }
		)
		{ after(grammarAccess.getMavenLocationAccess().getIncludeSourcesIncludeSourcesKeyword_12_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__GeneratedFeatureAssignment_14
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getGeneratedFeatureGeneratedFeatureParserRuleCall_14_0()); }
		ruleGeneratedFeature
		{ after(grammarAccess.getMavenLocationAccess().getGeneratedFeatureGeneratedFeatureParserRuleCall_14_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__DependenciesAssignment_15
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getDependenciesMavenDependencyParserRuleCall_15_0()); }
		ruleMavenDependency
		{ after(grammarAccess.getMavenLocationAccess().getDependenciesMavenDependencyParserRuleCall_15_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenLocation__RepositoriesAssignment_16
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenLocationAccess().getRepositoriesMavenRepositoryParserRuleCall_16_0()); }
		ruleMavenRepository
		{ after(grammarAccess.getMavenLocationAccess().getRepositoriesMavenRepositoryParserRuleCall_16_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__IdAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getIdSTRINGTerminalRuleCall_4_0()); }
		RULE_STRING
		{ after(grammarAccess.getGeneratedFeatureAccess().getIdSTRINGTerminalRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__NameAssignment_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getNameSTRINGTerminalRuleCall_7_0()); }
		RULE_STRING
		{ after(grammarAccess.getGeneratedFeatureAccess().getNameSTRINGTerminalRuleCall_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__VersionAssignment_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getVersionSTRINGTerminalRuleCall_10_0()); }
		RULE_STRING
		{ after(grammarAccess.getGeneratedFeatureAccess().getVersionSTRINGTerminalRuleCall_10_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__VendorAssignment_11_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getVendorSTRINGTerminalRuleCall_11_2_0()); }
		RULE_STRING
		{ after(grammarAccess.getGeneratedFeatureAccess().getVendorSTRINGTerminalRuleCall_11_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__InstalLibraryAssignment_12_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getInstalLibrarySTRINGTerminalRuleCall_12_2_0()); }
		RULE_STRING
		{ after(grammarAccess.getGeneratedFeatureAccess().getInstalLibrarySTRINGTerminalRuleCall_12_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__GeneratedFeature__AdditionalBundlesAssignment_13_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesIUParserRuleCall_13_2_0()); }
		ruleIU
		{ after(grammarAccess.getGeneratedFeatureAccess().getAdditionalBundlesIUParserRuleCall_13_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__GroupIdAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getGroupIdSTRINGTerminalRuleCall_4_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenDependencyAccess().getGroupIdSTRINGTerminalRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__ArtifactIdAssignment_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getArtifactIdSTRINGTerminalRuleCall_7_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenDependencyAccess().getArtifactIdSTRINGTerminalRuleCall_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__VersionAssignment_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getVersionSTRINGTerminalRuleCall_10_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenDependencyAccess().getVersionSTRINGTerminalRuleCall_10_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__ClassifierAssignment_11_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getClassifierSTRINGTerminalRuleCall_11_2_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenDependencyAccess().getClassifierSTRINGTerminalRuleCall_11_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenDependency__TypeAssignment_12_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenDependencyAccess().getTypeSTRINGTerminalRuleCall_12_2_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenDependencyAccess().getTypeSTRINGTerminalRuleCall_12_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__IdAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenRepositoryAccess().getIdSTRINGTerminalRuleCall_3_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenRepositoryAccess().getIdSTRINGTerminalRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MavenRepository__UrlAssignment_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMavenRepositoryAccess().getUrlSTRINGTerminalRuleCall_6_0()); }
		RULE_STRING
		{ after(grammarAccess.getMavenRepositoryAccess().getUrlSTRINGTerminalRuleCall_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__IDAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIUAccess().getIDIDTerminalRuleCall_0_0()); }
		RULE_ID
		{ after(grammarAccess.getIUAccess().getIDIDTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__VersionAssignment_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIUAccess().getVersionVersionRangeParserRuleCall_1_1_0_0()); }
		ruleVersionRange
		{ after(grammarAccess.getIUAccess().getVersionVersionRangeParserRuleCall_1_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IU__VersionAssignment_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIUAccess().getVersionSTRINGTerminalRuleCall_1_1_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getIUAccess().getVersionSTRINGTerminalRuleCall_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_INT : ('0'..'9')+;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('.'? ('a'..'z'|'A'..'Z'|'^'|'_'|'-'|'0'..'9'))*;

RULE_QUALIFIER : ('a'..'z'|'A'..'Z'|'_'|'-'|'0'..'9')*;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
