/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.model.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.cbi.targetplatform.model.Environment;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformPackage;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class EnvironmentImpl
extends MinimalEObjectImpl.Container
implements Environment {
    protected EList<String> env;
    protected static final String OPERATING_SYSTEM_EDEFAULT = null;
    protected static final String WINDOWING_SYSTEM_EDEFAULT = null;
    protected static final String ARCHITECTURE_EDEFAULT = null;
    protected static final Locale LOCALIZATION_EDEFAULT = null;
    protected static final IExecutionEnvironment EXECUTION_ENVIRONMENT_EDEFAULT = null;

    protected EnvironmentImpl() {
    }

    protected EClass eStaticClass() {
        return TargetPlatformPackage.Literals.ENVIRONMENT;
    }

    @Override
    public TargetPlatform getTargetPlatform() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (TargetPlatform)this.eContainer();
    }

    public TargetPlatform basicGetTargetPlatform() {
        if (this.eContainerFeatureID() != 0) {
            return null;
        }
        return (TargetPlatform)this.eInternalContainer();
    }

    public NotificationChain basicSetTargetPlatform(TargetPlatform newTargetPlatform, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newTargetPlatform, 0, msgs);
        return msgs;
    }

    @Override
    public void setTargetPlatform(TargetPlatform newTargetPlatform) {
        if (newTargetPlatform != this.eInternalContainer() || this.eContainerFeatureID() != 0 && newTargetPlatform != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newTargetPlatform)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newTargetPlatform != null) {
                msgs = ((InternalEObject)newTargetPlatform).eInverseAdd((InternalEObject)this, 1, TargetPlatform.class, msgs);
            }
            if ((msgs = this.basicSetTargetPlatform(newTargetPlatform, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newTargetPlatform, (Object)newTargetPlatform));
        }
    }

    @Override
    public EList<String> getEnv() {
        if (this.env == null) {
            this.env = new EDataTypeEList(String.class, (InternalEObject)this, 1);
        }
        return this.env;
    }

    @Override
    public String getOperatingSystem() {
        Functions.Function1<Environment, EList<String>> _function = new Functions.Function1<Environment, EList<String>>(){

            public EList<String> apply(Environment it) {
                return it.getEnv();
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                return !_isNullOrEmpty;
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.toUpperCase();
            }
        };
        final List envToUpper = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.getTargetPlatform().getContents(), Environment.class), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<String, Boolean> _function_3 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return envToUpper.contains(it.toUpperCase());
            }
        };
        return (String)IterableExtensions.findFirst(Arrays.asList(Platform.knownOSValues()), (Functions.Function1)_function_3);
    }

    @Override
    public String getWindowingSystem() {
        boolean _lessEqualsThan;
        Functions.Function1<Environment, EList<String>> _function = new Functions.Function1<Environment, EList<String>>(){

            public EList<String> apply(Environment it) {
                return it.getEnv();
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                return !_isNullOrEmpty;
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.toUpperCase();
            }
        };
        final List envToUpper = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.getTargetPlatform().getContents(), Environment.class), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<String, String> _function_3 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.toUpperCase();
            }
        };
        final List knownWSUpperValues = ListExtensions.map(Arrays.asList(Platform.knownWSValues()), (Functions.Function1)_function_3);
        Functions.Function1<String, Boolean> _function_4 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return knownWSUpperValues.contains(it);
            }
        };
        List allWS = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)envToUpper, (Functions.Function1)_function_4));
        boolean _and = false;
        int _size = allWS.size();
        boolean bl = _lessEqualsThan = _size <= 1;
        if (!_lessEqualsThan) {
            _and = false;
        } else {
            boolean _contains;
            String _operatingSystem = this.getOperatingSystem();
            String _upperCase = null;
            if (_operatingSystem != null) {
                _upperCase = _operatingSystem.toUpperCase();
            }
            _and = _contains = allWS.contains(_upperCase);
        }
        if (_and) {
            return null;
        }
        Functions.Function1<String, Boolean> _function_5 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return envToUpper.contains(it.toUpperCase());
            }
        };
        return (String)IterableExtensions.findFirst(Arrays.asList(Platform.knownWSValues()), (Functions.Function1)_function_5);
    }

    @Override
    public String getArchitecture() {
        Functions.Function1<Environment, EList<String>> _function = new Functions.Function1<Environment, EList<String>>(){

            public EList<String> apply(Environment it) {
                return it.getEnv();
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                return !_isNullOrEmpty;
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.toUpperCase();
            }
        };
        final List envToUpper = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.getTargetPlatform().getContents(), Environment.class), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<String, Boolean> _function_3 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return envToUpper.contains(it.toUpperCase());
            }
        };
        return (String)IterableExtensions.findFirst(Arrays.asList(Platform.knownOSArchValues()), (Functions.Function1)_function_3);
    }

    @Override
    public Locale getLocalization() {
        Functions.Function1<Environment, EList<String>> _function = new Functions.Function1<Environment, EList<String>>(){

            public EList<String> apply(Environment it) {
                return it.getEnv();
            }
        };
        Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                return !_isNullOrEmpty;
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return it.toUpperCase();
            }
        };
        final List envToUpper = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.getTargetPlatform().getContents(), Environment.class), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<Locale, String> _function_3 = new Functions.Function1<Locale, String>(){

            public String apply(Locale it) {
                return it.toString();
            }
        };
        Functions.Function1<String, Boolean> _function_4 = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return envToUpper.contains(it.toUpperCase());
            }
        };
        String locale = (String)IterableExtensions.findFirst((Iterable)ListExtensions.map(Arrays.asList(Locale.getAvailableLocales()), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        if (locale != null) {
            boolean _hasNext_2;
            boolean _hasNext_1;
            String language = "";
            String country = "";
            String variant = "";
            Iterator tokens = Splitter.on((String)"_").trimResults().split((CharSequence)locale).iterator();
            boolean _hasNext = tokens.hasNext();
            if (_hasNext) {
                language = (String)tokens.next();
            }
            if (_hasNext_1 = tokens.hasNext()) {
                country = (String)tokens.next();
            }
            if (_hasNext_2 = tokens.hasNext()) {
                variant = (String)tokens.next();
            }
            return new Locale(language, country, variant);
        }
        return null;
    }

    @Override
    public IExecutionEnvironment getExecutionEnvironment() {
        boolean _tripleEquals;
        IExtensionRegistry _registry = RegistryFactory.getRegistry();
        boolean bl = _tripleEquals = _registry == null;
        if (_tripleEquals) {
            return null;
        }
        IExecutionEnvironmentsManager eeManager = JavaRuntime.getExecutionEnvironmentsManager();
        if (eeManager != null) {
            Functions.Function1<Environment, EList<String>> _function = new Functions.Function1<Environment, EList<String>>(){

                public EList<String> apply(Environment it) {
                    return it.getEnv();
                }
            };
            Functions.Function1<String, Boolean> _function_1 = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it);
                    return !_isNullOrEmpty;
                }
            };
            Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it.toUpperCase();
                }
            };
            List envToUpper = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.getTargetPlatform().getContents(), Environment.class), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
            for (final String env : envToUpper) {
                Functions.Function1<IExecutionEnvironment, Boolean> _function_3 = new Functions.Function1<IExecutionEnvironment, Boolean>(){

                    public Boolean apply(IExecutionEnvironment it) {
                        return it.getId().toUpperCase().equals(env);
                    }
                };
                IExecutionEnvironment ee = (IExecutionEnvironment)IterableExtensions.findFirst(Arrays.asList(eeManager.getExecutionEnvironments()), (Functions.Function1)_function_3);
                if (ee == null) continue;
                return ee;
            }
            return null;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetTargetPlatform((TargetPlatform)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetTargetPlatform(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 0: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, TargetPlatform.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getTargetPlatform();
                }
                return this.basicGetTargetPlatform();
            }
            case 1: {
                return this.getEnv();
            }
            case 2: {
                return this.getOperatingSystem();
            }
            case 3: {
                return this.getWindowingSystem();
            }
            case 4: {
                return this.getArchitecture();
            }
            case 5: {
                return this.getLocalization();
            }
            case 6: {
                return this.getExecutionEnvironment();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setTargetPlatform((TargetPlatform)newValue);
                return;
            }
            case 1: {
                this.getEnv().clear();
                this.getEnv().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setTargetPlatform(null);
                return;
            }
            case 1: {
                this.getEnv().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.basicGetTargetPlatform() != null;
            }
            case 1: {
                return this.env != null && !this.env.isEmpty();
            }
            case 2: {
                return OPERATING_SYSTEM_EDEFAULT == null ? this.getOperatingSystem() != null : !OPERATING_SYSTEM_EDEFAULT.equals(this.getOperatingSystem());
            }
            case 3: {
                return WINDOWING_SYSTEM_EDEFAULT == null ? this.getWindowingSystem() != null : !WINDOWING_SYSTEM_EDEFAULT.equals(this.getWindowingSystem());
            }
            case 4: {
                return ARCHITECTURE_EDEFAULT == null ? this.getArchitecture() != null : !ARCHITECTURE_EDEFAULT.equals(this.getArchitecture());
            }
            case 5: {
                return LOCALIZATION_EDEFAULT == null ? this.getLocalization() != null : !LOCALIZATION_EDEFAULT.equals(this.getLocalization());
            }
            case 6: {
                return EXECUTION_ENVIRONMENT_EDEFAULT == null ? this.getExecutionEnvironment() != null : !EXECUTION_ENVIRONMENT_EDEFAULT.equals(this.getExecutionEnvironment());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (env: ");
        result.append(this.env);
        result.append(')');
        return result.toString();
    }
}

