/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudServicePlan;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.LocalCloudService;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.statushandlers.StatusManager;

public class CloudFoundryServicePlanWizardPage
extends WizardPage {
    protected DataBindingContext bindingContext;
    private final CloudFoundryServer cloudServer;
    private List<CloudServiceOffering> serviceOfferings;
    protected WritableMap map;
    private Text nameText;
    protected LocalCloudService service;
    private Composite planDetailsComposite;
    protected Group planGroup;
    private PageBook pageBook;
    private WritableValue planObservable = new WritableValue();
    private Combo typeCombo;
    private Pattern VALID_CHARS = Pattern.compile("[A-Za-z\\$_0-9\\-]+");

    protected CloudFoundryServicePlanWizardPage(CloudFoundryServer cloudServer) {
        super(Messages.CloudFoundryServicePlanWizardPage_TEXT_SERVICE_PAGE);
        this.cloudServer = cloudServer;
        this.setTitle(Messages.CloudFoundryServicePlanWizardPage_TITLE_SERVICE_CONFIG);
        this.setDescription(Messages.CloudFoundryServicePlanWizardPage_TEXT_FINISH_ADD);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        this.service = this.createService();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(10, LayoutConstants.getSpacing().y).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.COMMONTXT_NAME_WITH_COLON);
        this.nameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryServicePlanWizardPage.this.service.setName(CloudFoundryServicePlanWizardPage.this.nameText.getText());
            }
        });
        this.bindingContext = new DataBindingContext();
        this.map = new WritableMap();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.bindingContext);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.nameText, (int)24), Observables.observeMapEntry((IObservableMap)this.map, (Object)"name"), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringValidator()), null);
        label = new Label(composite, 0);
        label.setText(Messages.CloudFoundryServicePlanWizardPage_LABEL_TYPE);
        this.typeCombo = new Combo(composite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeCombo);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = CloudFoundryServicePlanWizardPage.this.typeCombo.getSelectionIndex();
                if (index != -1) {
                    CloudServiceOffering configuration = (CloudServiceOffering)CloudFoundryServicePlanWizardPage.this.serviceOfferings.get(index);
                    CloudFoundryServicePlanWizardPage.this.setCloudService((CloudService)CloudFoundryServicePlanWizardPage.this.service, configuration);
                }
                CloudFoundryServicePlanWizardPage.this.refreshPlan();
            }
        });
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.typeCombo), Observables.observeMapEntry((IObservableMap)this.map, (Object)"type"), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ComboValidator(Messages.CloudFoundryServicePlanWizardPage_TEXT_SELECT_TYPE)), null);
        this.pageBook = new PageBook(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.pageBook);
        this.planGroup = new Group((Composite)this.pageBook, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.planGroup);
        this.planGroup.setLayout((Layout)new GridLayout());
        this.planGroup.setVisible(false);
        this.planGroup.setText(this.getPlanLabel());
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                if (CloudFoundryServicePlanWizardPage.this.planObservable.getValue() == null) {
                    return ValidationStatus.cancel((String)CloudFoundryServicePlanWizardPage.this.getValidationErrorMessage());
                }
                return ValidationStatus.ok();
            }
        };
        this.bindingContext.addValidationStatusProvider((ValidationStatusProvider)validator);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public LocalCloudService getService() {
        return this.service;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.serviceOfferings == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CloudFoundryServicePlanWizardPage.this.getControl().isDisposed()) {
                        CloudFoundryServicePlanWizardPage.this.refresh();
                    }
                }
            });
        }
    }

    protected boolean supportsSpaces() {
        return this.cloudServer != null && this.cloudServer.hasCloudSpace();
    }

    protected void refresh() {
        if (this.updateConfiguration()) {
            this.typeCombo.removeAll();
            for (CloudServiceOffering offering : this.serviceOfferings) {
                String label = offering.getLabel() != null ? String.valueOf(offering.getLabel()) + " - " + offering.getDescription() : offering.getDescription();
                this.typeCombo.add(label);
            }
            this.refreshPlan();
        }
    }

    protected void refreshPlan() {
        int index = this.typeCombo.getSelectionIndex();
        if (index == -1) {
            this.pageBook.setVisible(false);
            this.planGroup.setVisible(false);
            this.planObservable.setValue(null);
        } else {
            this.pageBook.setVisible(true);
            Control[] controlArray = this.planGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            CloudServiceOffering configuration = this.serviceOfferings.get(index);
            List<CloudServicePlan> servicePlans = this.getPlans(configuration);
            if (servicePlans.size() > 1) {
                this.pageBook.showPage((Control)this.planGroup);
                this.planGroup.setVisible(true);
                Button defaultPlanControl = null;
                for (CloudServicePlan plan : servicePlans) {
                    String planLabelText = plan.getName();
                    Button planButton = new Button((Composite)this.planGroup, 16);
                    if (defaultPlanControl == null) {
                        defaultPlanControl = planButton;
                    }
                    planButton.setText(planLabelText);
                    planButton.setData((Object)plan);
                    planButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Button button = (Button)event.widget;
                            if (button.getSelection()) {
                                CloudServicePlan plan = (CloudServicePlan)button.getData();
                                CloudFoundryServicePlanWizardPage.this.setPlan(plan);
                            }
                        }
                    });
                }
                this.planDetailsComposite = new Composite((Composite)this.planGroup, 0);
                GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 10, 0).numColumns(2).applyTo(this.planDetailsComposite);
                if (defaultPlanControl != null) {
                    CloudServicePlan plan;
                    defaultPlanControl.setSelection(true);
                    plan = (CloudServicePlan)defaultPlanControl.getData();
                    this.setPlan(plan);
                }
            } else if (servicePlans.size() == 1) {
                this.planGroup.setVisible(false);
                CloudServicePlan plan = servicePlans.get(0);
                this.setPlan(plan);
            } else {
                this.pageBook.setVisible(false);
            }
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    protected void setPlan(CloudServicePlan plan) {
        this.getService().setPlan(plan.getName());
        this.planObservable.setValue((Object)plan);
    }

    protected boolean updateConfiguration() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            CloudFoundryServicePlanWizardPage.this.serviceOfferings = CloudFoundryServicePlanWizardPage.this.cloudServer.getBehaviour().getServiceOfferings(monitor);
                            Collections.sort(CloudFoundryServicePlanWizardPage.this.serviceOfferings, new Comparator<CloudServiceOffering>(){

                                @Override
                                public int compare(CloudServiceOffering o1, CloudServiceOffering o2) {
                                    return o1.getDescription().compareTo(o2.getDescription());
                                }
                            });
                            CloudFoundryServicePlanWizardPage.this.sortServicePlans(CloudFoundryServicePlanWizardPage.this.serviceOfferings);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            IStatus status = this.cloudServer.error(NLS.bind((String)Messages.CloudFoundryServicePlanWizardPage_ERROR_CONFIG_RETRIVE, (Object)e.getCause().getMessage()), (Exception)e);
            StatusManager.getManager().handle(status, 1);
            this.setMessage(status.getMessage(), 3);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    protected void sortServicePlans(List<CloudServiceOffering> configurations) {
        for (CloudServiceOffering offering : configurations) {
            Collections.sort(offering.getCloudServicePlans(), new Comparator<CloudServicePlan>(){

                @Override
                public int compare(CloudServicePlan o1, CloudServicePlan o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    protected List<CloudServicePlan> getPlans(CloudServiceOffering offering) {
        ArrayList<CloudServicePlan> plans = new ArrayList<CloudServicePlan>();
        List cloudPlans = offering.getCloudServicePlans();
        if (cloudPlans != null) {
            for (CloudServicePlan plan : cloudPlans) {
                plans.add(plan);
            }
        }
        return plans;
    }

    protected String getValidationErrorMessage() {
        return Messages.CloudFoundryServicePlanWizardPage_ERROR_SELECT_PLAN;
    }

    protected String getPlanLabel() {
        return Messages.CloudFoundryServicePlanWizardPage_LABEL_PLAN;
    }

    protected void setCloudService(CloudService service, CloudServiceOffering offering) {
        service.setVersion(offering.getVersion());
        service.setLabel(offering.getLabel());
        service.setProvider(offering.getProvider());
    }

    protected LocalCloudService createService() {
        LocalCloudService service = new LocalCloudService("");
        return service;
    }

    protected class ComboValidator
    implements IValidator {
        private final String message;

        public ComboValidator(String message) {
            this.message = message;
        }

        public IStatus validate(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Status.OK_STATUS;
            }
            return ValidationStatus.cancel((String)this.message);
        }
    }

    protected class StringValidator
    implements IValidator {
        protected StringValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                if (((String)value).length() == 0) {
                    return ValidationStatus.cancel((String)Messages.CloudFoundryServicePlanWizardPage_TEXT_ENTER_NAME);
                }
                Matcher matcher = CloudFoundryServicePlanWizardPage.this.VALID_CHARS.matcher((String)value);
                if (!matcher.matches()) {
                    return ValidationStatus.error((String)Messages.CloudFoundryServicePlanWizardPage_ERROR_INVALID_CHAR);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

