/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.profile.chesscontract.DataTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContractTypes implements Enumerator
{
    STRONG(0, "Strong", "Strong"),
    WEAK(1, "Weak", "Weak");

    public static final int STRONG_VALUE = 0;
    public static final int WEAK_VALUE = 1;
    private static final ContractTypes[] VALUES_ARRAY;
    public static final List<ContractTypes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContractTypes[]{STRONG, WEAK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContractTypes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractTypes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractTypes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractTypes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractTypes get(int value) {
        switch (value) {
            case 0: {
                return STRONG;
            }
            case 1: {
                return WEAK;
            }
        }
        return null;
    }

    private ContractTypes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

