/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLDiagramEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.chess.fla.impl.FlaAnalysisRunnerXml;
import org.polarsys.chess.fla.launch.Activator;

public class FlaAnalysisCommandXml
extends AbstractHandler {
    protected IFile sourceFile;
    List<? extends Object> arguments;
    private IContainer targetFolder;
    protected UMLDiagramEditor diagramEditor = null;
    protected DiagramEditPart clazzdiagrameditPart;
    protected PapyrusMultiDiagramEditor papyrusEditor;
    private static JFrame frame = new JFrame();
    public static final String COMMAND_ID = "org.polarsys.chess.fla.analysis.command";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.sourceFile = this.handleBrowseFile("Concerto-FLA Analysis from XML", "Please choose source XML file");
        if (this.sourceFile == null) {
            return null;
        }
        if (!this.sourceFile.getLocation().getFileExtension().equals("xml") && !this.sourceFile.getLocation().getFileExtension().equals("fla")) {
            JOptionPane.showMessageDialog(frame, "Chosen file is not XML file. To perform Concerto-FLA Analysis please choose XML file. ", "Concerto-FLA Analysis has failed", 0);
            return null;
        }
        this.targetFolder = this.sourceFile.getParent();
        Shell shell = new Shell();
        try {
            ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(shell);
            FlaAnalysisRunnerXml analysisRunner = new FlaAnalysisRunnerXml();
            analysisRunner.setSelectedXmlFile(this.sourceFile);
            analysisRunner.setTargetFolder(this.targetFolder);
            pmDialog.run(true, true, (IRunnableWithProgress)analysisRunner);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            throw new ExecutionException("Error during FLA analysis", (Throwable)e);
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return null;
    }

    private IFile handleBrowseFile(String title, String message) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                String[] extensions = null;
                extensions = new String[]{"xml"};
                try {
                    ret = FlaAnalysisCommandXml.isXMLResource((IResource)element, extensions);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        Object results = dialog.getFirstResult();
        if (results != null && results instanceof IFile) {
            IFile currentFile = (IFile)results;
            return currentFile;
        }
        if (results != null && (results instanceof IFolder || results instanceof IProject)) {
            JOptionPane.showMessageDialog(frame, "CHESS-FPTC Analysis failed. XML file was not chosed. ", "CHESS-FPTC Analysis - Wrong input file", 0);
            return null;
        }
        return null;
    }

    private static boolean isXMLResource(IResource resource, String[] extensions) throws CoreException {
        block8: {
            block7: {
                IResource[] members;
                if (!(resource instanceof IContainer)) break block7;
                if (!((IContainer)resource).isAccessible()) break block8;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (FlaAnalysisCommandXml.isXMLResource(member, extensions)) {
                        return true;
                    }
                    ++n2;
                }
                break block8;
            }
            if (resource instanceof IFile) {
                IFile currentFile = (IFile)resource;
                if (extensions == null) {
                    return true;
                }
                if (currentFile.getFileExtension() != null) {
                    int i = 0;
                    while (i < extensions.length) {
                        String extension = extensions[i];
                        if (currentFile.getFileExtension().toUpperCase().equals(extension.toUpperCase())) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }
}

