/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.monitoringxml.popup.actions;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.polarsys.chess.monitoring.traceanalyser.TraceAnalyser;

public class LaunchTraceAnalysis
implements IObjectActionDelegate {
    private Shell shell;
    private IFile traceFile;
    private IFile inXMLFile;
    private String outXMLFileName;
    private IWorkspaceRoot root;
    private static String XML_MODEL_PATH;
    private static Resource XML_MODEL_RESOURCE;
    private static String UML_MODEL_PATH;
    private static Resource UML_MODEL_RESOURCE;

    public LaunchTraceAnalysis() {
    }

    public LaunchTraceAnalysis(Shell inShell, IFile inTraceFile, IWorkspaceRoot inRoot) {
        this.shell = inShell;
        this.traceFile = inTraceFile;
        this.root = inRoot;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        ISelectionService service = targetPart.getSite().getWorkbenchWindow().getSelectionService();
        this.traceFile = (IFile)((IStructuredSelection)service.getSelection()).getFirstElement();
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void run(IAction action) {
        if (!this.traceFile.getLocation().getFileExtension().equals("txt")) {
            MessageDialog.openError((Shell)this.shell, (String)"The selected file is not a TXT file. To perform monitoring Analysis please select the TXT file containing execution traces. ", (String)"Monitoring Analysis has failed");
        }
        try {
            this.inXMLFile = this.handleBrowseFile("Monitoring trace analysis", "Please choose the input XML list of threads");
            this.outXMLFileName = this.inXMLFile.getName();
            TraceAnalyser ta = new TraceAnalyser(this.shell, this.inXMLFile, this.outXMLFileName, this.traceFile);
            ta.doTraceAnalysis();
            MessageDialog.openInformation((Shell)this.shell, (String)"Monitoring trace analysis", (String)"The analysis has been successfully executed.");
        }
        catch (Exception exMA) {
            System.out.println(exMA.getMessage());
            if (!exMA.getMessage().isEmpty()) {
                MessageDialog.openError((Shell)this.shell, (String)"Monitoring analysis", (String)exMA.getMessage());
            }
            MessageDialog.openError((Shell)this.shell, (String)"Monitoring analysis", (String)"The analysis has not been successfully executed.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void saveResource(XtextResource resource, URI uri) {
        resource.setModified(true);
        try {
            HashMap<String, Boolean> saveOptions = new HashMap<String, Boolean>();
            saveOptions.put(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
            resource.setURI(uri);
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IFile handleBrowseFile(String title, String message) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                String[] extensions = null;
                extensions = new String[]{"xml"};
                try {
                    ret = LaunchTraceAnalysis.isXMLResource((IResource)element, extensions);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
        dialog.setInput((Object)this.root);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        Object results = dialog.getFirstResult();
        if (results != null && results instanceof IFile) {
            IFile currentFile = (IFile)results;
            return currentFile;
        }
        if (results != null && (results instanceof IFolder || results instanceof IProject)) {
            MessageDialog.openError((Shell)this.shell, (String)"Monitoring backpropagation", (String)"The analysis has not been successfully executed. Please select a valid source XML.");
            return null;
        }
        return null;
    }

    private static boolean isXMLResource(IResource resource, String[] extensions) throws CoreException {
        block8: {
            block7: {
                IResource[] members;
                if (!(resource instanceof IContainer)) break block7;
                if (!((IContainer)resource).isAccessible()) break block8;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (LaunchTraceAnalysis.isXMLResource(member, extensions)) {
                        return true;
                    }
                    ++n2;
                }
                break block8;
            }
            if (resource instanceof IFile) {
                IFile currentFile = (IFile)resource;
                if (extensions == null) {
                    return true;
                }
                if (currentFile.getFileExtension() != null) {
                    int i = 0;
                    while (i < extensions.length) {
                        String extension = extensions[i];
                        if (currentFile.getFileExtension().toUpperCase().equals(extension.toUpperCase())) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    public static String getXMLPath() {
        return XML_MODEL_PATH;
    }

    public static Resource getXMLResource() {
        return XML_MODEL_RESOURCE;
    }

    public static String getModelPath() {
        return UML_MODEL_PATH;
    }

    public static Resource getModelResource() {
        return UML_MODEL_RESOURCE;
    }
}

